/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheColoredLampColors;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BlockColoredLamp
extends BlockBase {
    public static final TheColoredLampColors[] ALL_LAMP_TYPES = TheColoredLampColors.values();
    public static final PropertyEnum<TheColoredLampColors> TYPE = PropertyEnum.func_177709_a((String)"type", TheColoredLampColors.class);
    public final boolean isOn;

    public BlockColoredLamp(boolean isOn, String name) {
        super(Material.field_151591_t, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(3.0f);
        this.isOn = isOn;
    }

    public Item func_180660_a(IBlockState state, Random rand, int par3) {
        return Item.func_150898_a((Block)InitBlocks.blockColoredLamp);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int[] oreIDs;
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && stack.func_190926_b()) {
            world.func_180501_a(pos, (this.isOn ? InitBlocks.blockColoredLamp : InitBlocks.blockColoredLampOn).func_176223_P().func_177226_a(TYPE, state.func_177229_b(TYPE)), 2);
            world.func_175679_n(pos);
            return true;
        }
        if (StackUtil.isValid(stack) && (oreIDs = OreDictionary.getOreIDs((ItemStack)stack)).length > 0) {
            for (int oreID : oreIDs) {
                String name = OreDictionary.getOreName((int)oreID);
                TheColoredLampColors color = TheColoredLampColors.getColorFromDyeName(name);
                if (color == null || this.func_176201_c(state) == color.ordinal()) continue;
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, this.func_176203_a(color.ordinal()), 2);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int j = 0; j < ALL_LAMP_TYPES.length; ++j) {
            list.add((Object)new ItemStack((Block)this, 1, j));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isOn ? 15 : 0;
    }

    @Override
    protected ItemBlockBase getItemBlock() {
        return new TheItemBlock(this);
    }

    @Override
    public void registerRendering() {
        for (int i = 0; i < ALL_LAMP_TYPES.length; ++i) {
            ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Block)this, 1, i), this.getRegistryName(), TYPE.func_177701_a() + "=" + BlockColoredLamp.ALL_LAMP_TYPES[i].regName);
        }
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)TheColoredLampColors.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((TheColoredLampColors)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static class TheItemBlock
    extends ItemBlockBase {
        public TheItemBlock(Block block) {
            super(block);
            this.func_77627_a(true);
            this.func_77656_e(0);
        }

        public String func_77653_i(ItemStack stack) {
            if (stack.func_77952_i() >= ALL_LAMP_TYPES.length) {
                return "actuallyadditions.lolWutHowUDoDis";
            }
            if (Util.isClient()) {
                return super.func_77653_i(stack) + (((BlockColoredLamp)this.field_150939_a).isOn ? " (" + StringUtil.localize("tooltip.actuallyadditions.onSuffix.desc") + ")" : "");
            }
            return super.func_77653_i(stack);
        }

        @Override
        public String func_77667_c(ItemStack stack) {
            return InitBlocks.blockColoredLamp.func_149739_a() + "_" + BlockColoredLamp.ALL_LAMP_TYPES[stack.func_77952_i()].regName;
        }
    }
}

