/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.BlockSlabs;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEmpowerer;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEmpowerer
extends BlockContainerBase {
    public BlockEmpowerer(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityEmpowerer();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BlockSlabs.AABB_BOTTOM_HALF;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            TileEntityEmpowerer empowerer = (TileEntityEmpowerer)world.func_175625_s(pos);
            if (empowerer != null) {
                ItemStack stackThere = empowerer.slots.getStackInSlot(0);
                if (StackUtil.isValid(heldItem)) {
                    int maxTransfer;
                    if (!StackUtil.isValid(stackThere) && !TileEntityEmpowerer.getRecipesForInput(heldItem).isEmpty()) {
                        ItemStack toPut = heldItem.func_77946_l();
                        toPut = StackUtil.setStackSize(toPut, 1);
                        empowerer.slots.setStackInSlot(0, toPut);
                        player.func_184611_a(hand, StackUtil.addStackSize(heldItem, -1));
                        return true;
                    }
                    if (ItemUtil.canBeStacked(heldItem, stackThere) && (maxTransfer = Math.min(StackUtil.getStackSize(stackThere), heldItem.func_77976_d() - StackUtil.getStackSize(heldItem))) > 0) {
                        player.func_184611_a(hand, StackUtil.addStackSize(heldItem, maxTransfer));
                        ItemStack newStackThere = stackThere.func_77946_l();
                        newStackThere = StackUtil.addStackSize(newStackThere, -maxTransfer);
                        empowerer.slots.setStackInSlot(0, StackUtil.validateCheck(newStackThere));
                        return true;
                    }
                } else if (StackUtil.isValid(stackThere)) {
                    player.func_184611_a(hand, stackThere.func_77946_l());
                    empowerer.slots.setStackInSlot(0, StackUtil.getEmpty());
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

