/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.base;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaForgeUnitsWrapper;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemEnergy
extends ItemBase {
    private final int maxPower;
    private final int transfer;

    public ItemEnergy(int maxPower, int transfer, String name) {
        super(name);
        this.maxPower = maxPower;
        this.transfer = transfer;
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            NumberFormat format = NumberFormat.getInstance();
            tooltip.add(String.format("%s/%s Crystal Flux", format.format(storage.getEnergyStored()), format.format(storage.getMaxEnergyStored())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tabs)) {
            IEnergyStorage storage;
            ItemStack stackFull = new ItemStack((Item)this);
            if (stackFull.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stackFull.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                this.setEnergy(stackFull, storage.getMaxEnergyStored());
                list.add((Object)stackFull);
            }
            ItemStack stackEmpty = new ItemStack((Item)this);
            this.setEnergy(stackEmpty, 0);
            list.add((Object)stackEmpty);
        }
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            double maxAmount = storage.getMaxEnergyStored();
            double energyDif = maxAmount - (double)storage.getEnergyStored();
            return energyDif / maxAmount;
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        EntityPlayer player = ActuallyAdditions.proxy.getCurrentPlayer();
        if (player != null && player.field_70170_p != null) {
            float[] color = AssetUtil.getWheelColor(player.field_70170_p.func_82737_E() % 256L);
            return MathHelper.func_180183_b((float)(color[0] / 255.0f), (float)(color[1] / 255.0f), (float)(color[2] / 255.0f));
        }
        return super.getRGBDurabilityForDisplay(stack);
    }

    public void setEnergy(ItemStack stack, int energy) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) instanceof CustomEnergyStorage) {
            ((CustomEnergyStorage)storage).setEnergyStored(energy);
        }
    }

    public int receiveEnergyInternal(ItemStack stack, int maxReceive, boolean simulate) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) instanceof CustomEnergyStorage) {
            ((CustomEnergyStorage)storage).receiveEnergyInternal(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergyInternal(ItemStack stack, int maxExtract, boolean simulate) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) instanceof CustomEnergyStorage) {
            ((CustomEnergyStorage)storage).extractEnergyInternal(maxExtract, simulate);
        }
        return 0;
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(ItemStack stack) {
        IEnergyStorage storage;
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyCapabilityProvider(stack, this);
    }

    private static class EnergyCapabilityProvider
    implements ICapabilityProvider {
        public final CustomEnergyStorage storage;
        private Object teslaWrapper;

        public EnergyCapabilityProvider(final ItemStack stack, ItemEnergy item) {
            this.storage = new CustomEnergyStorage(item.maxPower, item.transfer, item.transfer){

                public int getEnergyStored() {
                    if (stack.func_77942_o()) {
                        return stack.func_77978_p().func_74762_e("Energy");
                    }
                    return 0;
                }

                @Override
                public void setEnergyStored(int energy) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74768_a("Energy", energy);
                }
            };
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return this.getCapability(capability, facing) != null;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this.storage);
            }
            if (ActuallyAdditions.teslaLoaded && (capability == TeslaUtil.teslaConsumer || capability == TeslaUtil.teslaProducer || capability == TeslaUtil.teslaHolder)) {
                if (this.teslaWrapper == null) {
                    this.teslaWrapper = new TeslaForgeUnitsWrapper((IEnergyStorage)this.storage);
                }
                return (T)this.teslaWrapper;
            }
            return null;
        }
    }
}

