/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.base;

import de.ellpeck.actuallyadditions.api.misc.IDisableableItem;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.ConfigurationHandler;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;

public class ItemHoeAA
extends ItemHoe
implements IDisableableItem {
    private final String name;
    private final EnumRarity rarity;
    private final ItemStack repairItem;
    private final boolean disabled;

    public ItemHoeAA(Item.ToolMaterial toolMat, ItemStack repairItem, String unlocalizedName, EnumRarity rarity) {
        super(toolMat);
        this.repairItem = repairItem;
        this.name = unlocalizedName;
        this.rarity = rarity;
        this.disabled = ConfigurationHandler.config.getBoolean("Disable: " + StringUtil.badTranslate(this.name), "Tool Control", false, "This will disable the " + StringUtil.badTranslate(this.name) + ". It will not be registered.");
        if (!this.disabled) {
            this.register();
        }
    }

    private void register() {
        ItemUtil.registerItem((Item)this, this.getBaseName(), this.shouldAddCreative());
        this.registerRendering();
    }

    protected String getBaseName() {
        return this.name;
    }

    public boolean shouldAddCreative() {
        return true;
    }

    protected void registerRendering() {
        ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Item)this), this.getRegistryName(), "inventory");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return ItemUtil.areItemsEqual(this.repairItem, stack, false);
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }
}

