/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.lens;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.recipe.IColorLensChanger;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class LensColor
extends Lens {
    public static final int ENERGY_USE = 200;
    public static final float[][] POSSIBLE_COLORS = new float[][]{{158.0f, 43.0f, 39.0f}, {234.0f, 126.0f, 53.0f}, {194.0f, 181.0f, 28.0f}, {57.0f, 186.0f, 46.0f}, {54.0f, 75.0f, 24.0f}, {99.0f, 135.0f, 210.0f}, {38.0f, 113.0f, 145.0f}, {37.0f, 49.0f, 147.0f}, {126.0f, 52.0f, 191.0f}, {190.0f, 73.0f, 201.0f}, {217.0f, 129.0f, 153.0f}, {86.0f, 51.0f, 28.0f}};
    private final Random rand = new Random();

    @Override
    public boolean invoke(IBlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        if (hitBlock != null) {
            int meta;
            IBlockState state;
            Block block;
            ItemStack returnStack;
            if (tile.getEnergy() >= 200 && (returnStack = this.tryConvert(new ItemStack(block = (state = tile.getWorldObject().func_180495_p(hitBlock)).func_177230_c(), 1, meta = block.func_176201_c(state)), hitState, hitBlock, tile)) != null && returnStack.func_77973_b() instanceof ItemBlock) {
                Block toPlace = Block.func_149634_a((Item)returnStack.func_77973_b());
                IBlockState state2Place = toPlace.getStateForPlacement(tile.getWorldObject(), hitBlock, EnumFacing.UP, 0.0f, 0.0f, 0.0f, returnStack.func_77960_j(), (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)tile.getWorldObject())), EnumHand.MAIN_HAND);
                tile.getWorldObject().func_180501_a(hitBlock, state2Place, 2);
                tile.extractEnergy(200);
            }
            ArrayList items = (ArrayList)tile.getWorldObject().func_72872_a(EntityItem.class, new AxisAlignedBB((double)hitBlock.func_177958_n(), (double)hitBlock.func_177956_o(), (double)hitBlock.func_177952_p(), (double)(hitBlock.func_177958_n() + 1), (double)(hitBlock.func_177956_o() + 1), (double)(hitBlock.func_177952_p() + 1)));
            for (EntityItem item : items) {
                ItemStack newStack;
                if (item.field_70128_L || !StackUtil.isValid(item.func_92059_d()) || tile.getEnergy() < 200 || !StackUtil.isValid(newStack = this.tryConvert(item.func_92059_d(), hitState, hitBlock, tile))) continue;
                item.func_70106_y();
                EntityItem newItem = new EntityItem(tile.getWorldObject(), item.field_70165_t, item.field_70163_u, item.field_70161_v, newStack);
                tile.getWorldObject().func_72838_d((Entity)newItem);
                tile.extractEnergy(200);
            }
        }
        return false;
    }

    private ItemStack tryConvert(ItemStack stack, IBlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        Item item;
        if (StackUtil.isValid(stack) && (item = stack.func_77973_b()) != null) {
            for (Map.Entry<Item, IColorLensChanger> changer : ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_COLOR_CHANGERS.entrySet()) {
                if (item != changer.getKey()) continue;
                return changer.getValue().modifyItem(stack, hitState, hitBlock, tile);
            }
        }
        return ItemStack.field_190927_a.func_77946_l();
    }

    @Override
    public float[] getColor() {
        float[] colors = POSSIBLE_COLORS[this.rand.nextInt(POSSIBLE_COLORS.length)];
        return new float[]{colors[0] / 255.0f, colors[1] / 255.0f, colors[2] / 255.0f};
    }

    @Override
    public int getDistance() {
        return 10;
    }

    @Override
    public boolean canInvoke(IAtomicReconstructor tile, EnumFacing sideToShootTo, int energyUsePerShot) {
        return tile.getEnergy() - energyUsePerShot >= 200;
    }
}

