/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.jei.reconstructor;

import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.misc.BookletUtils;
import de.ellpeck.actuallyadditions.mod.jei.RecipeWrapperWithButton;
import de.ellpeck.actuallyadditions.mod.recipe.EnchBookConversion;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class ReconstructorRecipeWrapper
extends RecipeWrapperWithButton {
    public static final IRecipeWrapperFactory<LensConversionRecipe> FACTORY = recipe -> {
        if (recipe instanceof EnchBookConversion) {
            return new EnchBookWrapper((EnchBookConversion)recipe);
        }
        return new ReconstructorRecipeWrapper((LensConversionRecipe)recipe);
    };
    public final LensConversionRecipe theRecipe;

    public ReconstructorRecipeWrapper(LensConversionRecipe recipe) {
        this.theRecipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.theRecipe.inputStack);
        ingredients.setOutput(ItemStack.class, (Object)this.theRecipe.outputStack);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_175065_a(this.theRecipe.energyUse + " CF", 55.0f, 0.0f, 0xFFFFFF, true);
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
    }

    @Override
    public int getButtonX() {
        return 3;
    }

    @Override
    public int getButtonY() {
        return 40;
    }

    @Override
    public IBookletPage getPage() {
        return BookletUtils.findFirstPageForStack(new ItemStack(InitBlocks.blockAtomicReconstructor));
    }

    public static class EnchBookWrapper
    extends ReconstructorRecipeWrapper {
        private static final ItemStack BOOK = new ItemStack(Items.field_151134_bR);
        private static final ItemStack OUT = new ItemStack(Items.field_151134_bR);

        public EnchBookWrapper(EnchBookConversion recipe) {
            super(recipe);
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)BOOK);
            ingredients.setOutput(ItemStack.class, (Object)OUT);
        }

        static {
            OUT.func_151001_c("Split Book");
            NBTTagCompound t = OUT.func_77978_p().func_74775_l("display");
            NBTTagList l = new NBTTagList();
            l.func_74742_a((NBTBase)new NBTTagString("Book will be split based on enchantments!"));
            t.func_74782_a("Lore", (NBTBase)l);
        }
    }
}

