/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.items.ItemBattery;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityBatteryBox
extends TileEntityInventoryBase
implements ISharingEnergyProvider {
    private int lastEnergyStored;
    private int lastCompare;

    public TileEntityBatteryBox() {
        super(1, "batteryBox");
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        ItemStack stack = this.slots.getStackInSlot(0);
        if (StackUtil.isValid(stack) && stack.func_77973_b() instanceof ItemBattery && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        }
        return null;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            int currStorage = 0;
            IEnergyStorage storage = this.getEnergyStorage(null);
            if (storage != null) {
                ItemStack stack = this.slots.getStackInSlot(0);
                if (StackUtil.isValid(stack) && ItemUtil.isEnabled(stack) && storage.getEnergyStored() > 0) {
                    ArrayList<TileEntityBatteryBox> tiles = new ArrayList<TileEntityBatteryBox>();
                    this.energyPushOffLoop(this, tiles);
                    if (!tiles.isEmpty()) {
                        int amount = tiles.size();
                        int energyPer = storage.getEnergyStored() / amount;
                        if (energyPer <= 0) {
                            energyPer = storage.getEnergyStored();
                        }
                        int maxPer = storage.extractEnergy(energyPer, true);
                        for (TileEntityBatteryBox tile : tiles) {
                            IEnergyStorage cap;
                            ItemStack battery = tile.slots.getStackInSlot(0);
                            if (!StackUtil.isValid(battery) || ItemUtil.isEnabled(battery) || !tile.hasCapability(CapabilityEnergy.ENERGY, null) || (cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, null)) == null) continue;
                            int received = cap.receiveEnergy(maxPer, false);
                            storage.extractEnergy(received, false);
                            if (storage.getEnergyStored() > 0) continue;
                            break;
                        }
                    }
                }
                currStorage = storage.getEnergyStored();
            }
            if (this.lastCompare != this.getComparatorStrength()) {
                this.lastCompare = this.getComparatorStrength();
                this.func_70296_d();
            }
            if (this.lastEnergyStored != currStorage && this.sendUpdateWithInterval()) {
                this.lastEnergyStored = currStorage;
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        IEnergyStorage storage = this.getEnergyStorage(null);
        if (storage != null) {
            float calc = (float)storage.getEnergyStored() / (float)storage.getMaxEnergyStored() * 15.0f;
            return (int)calc;
        }
        return 0;
    }

    @Override
    public boolean respondsToPulses() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        ItemStack stack = this.slots.getStackInSlot(0);
        if (StackUtil.isValid(stack)) {
            ItemUtil.changeEnabled(stack);
            this.func_70296_d();
        }
    }

    private void energyPushOffLoop(TileEntityBatteryBox startTile, List<TileEntityBatteryBox> pushOffTo) {
        if (pushOffTo.size() >= 15) {
            return;
        }
        for (TileEntity tile : startTile.tilesAround) {
            TileEntityBatteryBox box;
            if (!(tile instanceof TileEntityBatteryBox) || pushOffTo.contains(box = (TileEntityBatteryBox)tile)) continue;
            pushOffTo.add(box);
            this.energyPushOffLoop(box, pushOffTo);
        }
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return StackUtil.isValid(stack) && stack.func_77973_b() instanceof ItemBattery;
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public int getEnergyToSplitShare() {
        IEnergyStorage storage = this.getEnergyStorage(null);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public EnumFacing[] getEnergyShareSides() {
        return EnumFacing.values();
    }

    @Override
    public boolean canShareTo(TileEntity tile) {
        return !(tile instanceof TileEntityBatteryBox);
    }
}

