/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEnervator
extends TileEntityInventoryBase
implements ISharingEnergyProvider {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(50000, 0, 1000);
    private int lastEnergy;

    public TileEntityEnervator() {
        super(2, "enervator");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (StackUtil.isValid(this.slots.getStackInSlot(0)) && !StackUtil.isValid(this.slots.getStackInSlot(1)) && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
                int extracted = 0;
                boolean canTakeUp = false;
                int maxExtract = this.storage.getMaxEnergyStored() - this.storage.getEnergyStored();
                if (this.slots.getStackInSlot(0).hasCapability(CapabilityEnergy.ENERGY, null)) {
                    IEnergyStorage cap = (IEnergyStorage)this.slots.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY, null);
                    if (cap != null) {
                        extracted = cap.extractEnergy(maxExtract, false);
                        canTakeUp = cap.getEnergyStored() <= 0;
                    }
                } else if (ActuallyAdditions.teslaLoaded) {
                    ITeslaProducer cap;
                    if (this.slots.getStackInSlot(0).hasCapability(TeslaUtil.teslaProducer, null) && (cap = (ITeslaProducer)this.slots.getStackInSlot(0).getCapability(TeslaUtil.teslaProducer, null)) != null) {
                        extracted = (int)cap.takePower((long)maxExtract, false);
                    }
                    if (this.slots.getStackInSlot(0).hasCapability(TeslaUtil.teslaHolder, null) && (cap = (ITeslaHolder)this.slots.getStackInSlot(0).getCapability(TeslaUtil.teslaHolder, null)) != null) {
                        boolean bl = canTakeUp = cap.getStoredPower() <= 0L;
                    }
                }
                if (extracted > 0) {
                    this.storage.receiveEnergyInternal(extracted, false);
                }
                if (canTakeUp) {
                    this.slots.setStackInSlot(1, this.slots.getStackInSlot(0).func_77946_l());
                    this.slots.setStackInSlot(0, StackUtil.addStackSize(this.slots.getStackInSlot(0), -1));
                }
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return i == 0 && (ActuallyAdditions.teslaLoaded && stack.hasCapability(TeslaUtil.teslaProducer, null) || stack.hasCapability(CapabilityEnergy.ENERGY, null));
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        return slot == 1;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public EnumFacing[] getEnergyShareSides() {
        return EnumFacing.values();
    }

    @Override
    public boolean canShareTo(TileEntity tile) {
        return true;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

