/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.ConnectionPair;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityLaserRelay
extends TileEntityInventoryBase {
    public static final int MAX_DISTANCE = 15;
    public static final int MAX_DISTANCE_RANGED = 35;
    public final LaserType type;
    private Network cachedNetwork;
    private int changeAmountAtCaching = -1;
    private int lastRange;

    public TileEntityLaserRelay(String name, LaserType type) {
        super(1, name);
        this.type = type;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SYNC) {
            ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(this.field_174879_c, this.field_145850_b);
            NBTTagList list = compound.func_150295_c("Connections", 10);
            if (!list.func_82582_d()) {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ConnectionPair pair = new ConnectionPair();
                    pair.readFromNBT(list.func_150305_b(i));
                    ActuallyAdditionsAPI.connectionHandler.addConnection(pair.getPositions()[0], pair.getPositions()[1], this.type, this.field_145850_b, pair.doesSuppressRender());
                }
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SYNC) {
            NBTTagList list = new NBTTagList();
            ConcurrentSet<IConnectionPair> connections = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.field_174879_c, this.field_145850_b);
            if (connections != null && !connections.isEmpty()) {
                for (IConnectionPair pair : connections) {
                    NBTTagCompound tag = new NBTTagCompound();
                    pair.writeToNBT(tag);
                    list.func_74742_a((NBTBase)tag);
                }
            }
            compound.func_74782_a("Connections", (NBTBase)list);
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        int range = this.getMaxRange();
        if (this.lastRange != range) {
            ConcurrentSet<IConnectionPair> connections = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.field_174879_c, this.field_145850_b);
            if (connections != null && !connections.isEmpty()) {
                for (IConnectionPair pair : connections) {
                    int distanceSq = (int)pair.getPositions()[0].func_177951_i((Vec3i)pair.getPositions()[1]);
                    if (distanceSq <= range * range) continue;
                    ActuallyAdditionsAPI.connectionHandler.removeConnection(this.field_145850_b, pair.getPositions()[0], pair.getPositions()[1]);
                }
            }
            this.lastRange = range;
        }
    }

    public Network getNetwork() {
        if (this.cachedNetwork == null || this.cachedNetwork.changeAmount != this.changeAmountAtCaching) {
            this.cachedNetwork = ActuallyAdditionsAPI.connectionHandler.getNetworkFor(this.field_174879_c, this.field_145850_b);
            this.changeAmountAtCaching = this.cachedNetwork != null ? this.cachedNetwork.changeAmount : -1;
        }
        return this.cachedNetwork;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return null;
    }

    public int getMaxRange() {
        ItemStack upgrade = this.slots.getStackInSlot(0);
        if (StackUtil.isValid(upgrade) && upgrade.func_77973_b() == InitItems.itemLaserUpgradeRange) {
            return 35;
        }
        return 15;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract String getExtraDisplayString();

    @SideOnly(value=Side.CLIENT)
    public abstract String getCompassDisplayString();

    public abstract void onCompassAction(EntityPlayer var1);
}

