/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotFilter;
import de.ellpeck.actuallyadditions.mod.items.ItemDrill;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerCustom;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLaserRelayItemWhitelist
extends TileEntityLaserRelayItem
implements IButtonReactor {
    public FilterSettings leftFilter = new FilterSettings(12, true, true, false, false, 0, -1000);
    public FilterSettings rightFilter = new FilterSettings(12, true, true, false, false, 0, -2000);

    public TileEntityLaserRelayItemWhitelist() {
        super("laserRelayItemWhitelist");
    }

    @Override
    public int getPriority() {
        return super.getPriority() + 10;
    }

    @Override
    public boolean isWhitelisted(ItemStack stack, boolean output) {
        return output ? this.rightFilter.check(stack) : this.leftFilter.check(stack);
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.leftFilter.writeToNBT(compound, "LeftFilter");
        this.rightFilter.writeToNBT(compound, "RightFilter");
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.leftFilter.readFromNBT(compound, "LeftFilter");
        this.rightFilter.readFromNBT(compound, "RightFilter");
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        this.leftFilter.onButtonPressed(buttonID);
        this.rightFilter.onButtonPressed(buttonID);
        if (buttonID == 2) {
            this.addWhitelistSmart(false);
        } else if (buttonID == 3) {
            this.addWhitelistSmart(true);
        }
    }

    private void addWhitelistSmart(boolean output) {
        for (SlotlessableItemHandlerWrapper handler : this.handlersAround.values()) {
            IItemHandler itemHandler = handler.getNormalHandler();
            if (itemHandler == null) continue;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (!StackUtil.isValid(stack)) continue;
                this.addWhitelistSmart(output, stack);
            }
        }
    }

    private void addWhitelistSmart(boolean output, ItemStack stack) {
        FilterSettings usedSettings = output ? this.rightFilter : this.leftFilter;
        ItemStack copy = stack.func_77946_l();
        if (!FilterSettings.check(copy = StackUtil.setStackSize(copy, 1), usedSettings.filterInventory, true, usedSettings.respectMeta, usedSettings.respectNBT, usedSettings.respectMod, usedSettings.respectOredict)) {
            for (int k = 0; k < usedSettings.filterInventory.getSlots(); ++k) {
                ItemStack slot = usedSettings.filterInventory.getStackInSlot(k);
                if (StackUtil.isValid(slot)) {
                    if (!SlotFilter.isFilter(slot)) continue;
                    ItemStackHandlerCustom inv = new ItemStackHandlerCustom(24);
                    ItemDrill.loadSlotsFromNBT(inv, slot);
                    boolean did = false;
                    for (int j = 0; j < inv.getSlots(); ++j) {
                        if (StackUtil.isValid(inv.getStackInSlot(j))) continue;
                        inv.setStackInSlot(j, copy);
                        did = true;
                        break;
                    }
                    if (!did) continue;
                    ItemDrill.writeSlotsToNBT(inv, slot);
                    break;
                }
                usedSettings.filterInventory.setStackInSlot(k, copy);
                break;
            }
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && (this.leftFilter.needsUpdateSend() || this.rightFilter.needsUpdateSend()) && this.sendUpdateWithInterval()) {
            this.leftFilter.updateLasts();
            this.rightFilter.updateLasts();
        }
    }
}

