/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util.crafting;

import de.ellpeck.actuallyadditions.api.misc.IDisableableItem;
import de.ellpeck.actuallyadditions.mod.RegistryHandler;
import de.ellpeck.actuallyadditions.mod.util.crafting.BlankRecipe;
import de.ellpeck.actuallyadditions.mod.util.crafting.RecipeHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.OreIngredient;

public final class RecipeHelper {
    private static int j = 0;
    private static final String MODID = "actuallyadditions";
    private static final String MODNAME = "Actually Additions";
    public static final List<IRecipe> RECIPE_LIST = RegistryHandler.RECIPES_TO_REGISTER;

    public static void addRecipe(int j, IRecipe rec) {
        RecipeHelper.addRecipe("recipes" + j, rec);
    }

    public static void addRecipe(String name, IRecipe rec) {
        Item i = rec.func_77571_b().func_77973_b();
        if (i instanceof IDisableableItem && ((IDisableableItem)i).isDisabled()) {
            rec = new BlankRecipe();
        }
        if (rec.getRegistryName() == null) {
            RECIPE_LIST.add((IRecipe)rec.setRegistryName(new ResourceLocation(MODID, name)));
        } else {
            RECIPE_LIST.add(rec);
        }
        RecipeHandler.lastRecipe = rec;
    }

    public static void addOldShaped(ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        RecipeHelper.addRecipe(j++, (IRecipe)new ShapedRecipes(new ResourceLocation(MODID, "recipes" + j).toString(), primer.width, primer.height, primer.input, output));
    }

    public static void addOldShaped(String group, ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        RecipeHelper.addRecipe(j++, (IRecipe)new ShapedRecipes(new ResourceLocation(MODID, group).toString(), primer.width, primer.height, primer.input, output));
    }

    public static void addOldShaped(String name, String group, ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        RecipeHelper.addRecipe(j++, (IRecipe)new ShapedRecipes(new ResourceLocation(MODID, group).toString(), primer.width, primer.height, primer.input, output).setRegistryName(MODID, name));
    }

    public static void addOldShapeless(ItemStack output, Object ... input) {
        RecipeHelper.addRecipe(j++, (IRecipe)new ShapelessRecipes(new ResourceLocation(MODID, "recipes" + j).toString(), output, RecipeHelper.createInput(input)));
    }

    public static void addOldShapeless(String group, ItemStack output, Object ... input) {
        RecipeHelper.addRecipe(j++, (IRecipe)new ShapelessRecipes(new ResourceLocation(MODID, group).toString(), output, RecipeHelper.createInput(input)));
    }

    public static void addOldShapeless(String name, String group, ItemStack output, Object ... input) {
        RecipeHelper.addRecipe(j++, (IRecipe)new ShapelessRecipes(new ResourceLocation(MODID, group).toString(), output, RecipeHelper.createInput(input)).setRegistryName(MODID, name));
    }

    public static void addShapeless(ItemStack output, Object ... inputs) {
        RecipeHelper.addRecipe(j++, (IRecipe)new ShapelessRecipes("actuallyadditions:" + j, output, RecipeHelper.createInput(inputs)));
    }

    public static void addShapeless(Item output, Object ... inputs) {
        RecipeHelper.addShapeless(new ItemStack(output), inputs);
    }

    public static void addShapeless(Block output, Object ... inputs) {
        RecipeHelper.addShapeless(new ItemStack(output), inputs);
    }

    public static void addShapeless(String group, ItemStack output, Object ... inputs) {
        RecipeHelper.addRecipe(j++, (IRecipe)new ShapelessRecipes("actuallyadditions:" + group, output, RecipeHelper.createInput(inputs)));
    }

    public static void addShapeless(String group, Item output, Object ... inputs) {
        RecipeHelper.addShapeless(group, new ItemStack(output), inputs);
    }

    public static void addShapeless(String group, Block output, Object ... inputs) {
        RecipeHelper.addShapeless(group, new ItemStack(output), inputs);
    }

    public static void addShaped(ItemStack output, int width, int height, Object ... input) {
        RecipeHelper.addRecipe(j++, (IRecipe)RecipeHelper.genShaped(output, width, height, input));
    }

    public static void addShaped(Item output, int width, int height, Object ... input) {
        RecipeHelper.addShaped(new ItemStack(output), width, height, input);
    }

    public static void addShaped(Block output, int width, int height, Object ... input) {
        RecipeHelper.addShaped(new ItemStack(output), width, height, input);
    }

    public static void addShaped(String group, ItemStack output, int width, int height, Object ... input) {
        RecipeHelper.addRecipe(j++, (IRecipe)RecipeHelper.genShaped("actuallyadditions:" + group, output, width, height, input));
    }

    public static void addShaped(String group, Item output, int width, int height, Object ... input) {
        RecipeHelper.addShaped(group, new ItemStack(output), width, height, input);
    }

    public static void addShaped(String group, Block output, int width, int height, Object ... input) {
        RecipeHelper.addShaped(group, new ItemStack(output), width, height, input);
    }

    public static ShapedRecipes genShaped(ItemStack output, int l, int w, Object[] input) {
        if (input[0] instanceof Object[]) {
            input = (Object[])input[0];
        }
        if (l * w != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of Actually Additions");
        }
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)new OreIngredient((String)k));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).func_190926_b()) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)k}));
                continue;
            }
            if (k instanceof Item) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)k)}));
                continue;
            }
            if (k instanceof Block) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)k)}));
                continue;
            }
            inputL.add(i, (Object)Ingredient.field_193370_a);
        }
        return new ShapedRecipes("actuallyadditions:" + j, l, w, inputL, output);
    }

    public static ShapedRecipes genShaped(String group, ItemStack output, int l, int w, Object[] input) {
        if (input[0] instanceof List) {
            input = ((List)input[0]).toArray();
        } else if (input[0] instanceof Object[]) {
            input = (Object[])input[0];
        }
        if (l * w != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of Actually Additions");
        }
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)new OreIngredient((String)k));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).func_190926_b()) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)k}));
                continue;
            }
            if (k instanceof Item) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)k)}));
                continue;
            }
            if (k instanceof Block) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)k)}));
                continue;
            }
            inputL.add(i, (Object)Ingredient.field_193370_a);
        }
        return new ShapedRecipes(group, l, w, inputL, output);
    }

    public static NonNullList<Ingredient> createInput(Object[] input) {
        if (input[0] instanceof List) {
            input = ((List)input[0]).toArray();
        } else if (input[0] instanceof Object[]) {
            input = (Object[])input[0];
        }
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)new OreIngredient((String)k));
                continue;
            }
            if (k instanceof ItemStack) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)k}));
                continue;
            }
            if (k instanceof Item) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)k)}));
                continue;
            }
            if (k instanceof Block) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)k)}));
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid shapeless recipe.  Complain to the author of Actually Additions");
        }
        return inputL;
    }
}

