/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.rebornstorage.items;

import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import javax.annotation.Nonnull;
import me.modmuss50.rebornstorage.init.EnumItemStorage;
import me.modmuss50.rebornstorage.items.ItemBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemRebornStorageCell
extends ItemBase
implements IStorageDiskProvider<ItemStack> {
    public static final String[] types = new String[]{"256k", "1024k", "4096k", "16384k"};

    public ItemRebornStorageCell() {
        this.func_77655_b("rebornstorage.storagecell");
        this.func_77627_a(true);
        this.setRegistryName("rebornstorage", "storagecell");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int meta = 0; meta < EnumItemStorage.values().length; ++meta) {
                subItems.add((Object)API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.ITEMS, new ItemStack((Item)this, 1, meta)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!stack.func_77942_o()) {
            API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.ITEMS, stack);
        }
    }

    public void func_77624_a(ItemStack disk, World world, List<String> tooltip, ITooltipFlag flag) {
        IStorageDisk<ItemStack> storage = this.create(disk);
        if (storage.isValid(disk)) {
            if (storage.getCapacity() == -1) {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{storage.getStored()}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{storage.getStored(), storage.getCapacity()}));
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.ITEMS, stack);
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return API.instance().getDefaultStorageDiskBehavior().getShareTag(StorageDiskType.ITEMS, stack);
    }

    @Nonnull
    public IStorageDisk<ItemStack> create(ItemStack disk) {
        return API.instance().getDefaultStorageDiskBehavior().createItemStorage(disk.func_77978_p(), EnumItemStorage.getById(disk.func_77952_i()).getCap());
    }

    public String func_77658_a() {
        return "item.rebornstorage:storagecell";
    }

    public String func_77667_c(ItemStack itemStack) {
        int meta = itemStack.func_77952_i();
        if (meta < 0 || meta >= EnumItemStorage.values().length) {
            meta = 0;
        }
        return super.func_77658_a() + "." + types[meta];
    }
}

