/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.rebornstorage.multiblocks;

import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import me.modmuss50.rebornstorage.blocks.BlockMultiCrafter;
import me.modmuss50.rebornstorage.tiles.TileMultiCrafter;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.rectangular.RectangularMultiblockControllerBase;

public class MultiBlockCrafter
extends RectangularMultiblockControllerBase {
    public Map<Integer, ItemHandlerBase> invs = new TreeMap<Integer, ItemHandlerBase>();
    public int speed = 0;
    public int pages = 0;

    public MultiBlockCrafter(World world) {
        super(world);
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart iMultiblockPart, NBTTagCompound nbtTagCompound) {
    }

    protected void onBlockAdded(IMultiblockPart iMultiblockPart) {
    }

    protected void onBlockRemoved(IMultiblockPart iMultiblockPart) {
    }

    protected void onMachineAssembled() {
        this.updateInfo();
    }

    public void updateInfo() {
        this.speed = 0;
        this.pages = 0;
        this.invs.clear();
        TreeMap<Integer, TileMultiCrafter> collector = new TreeMap<Integer, TileMultiCrafter>();
        int append = 2745;
        for (IMultiblockPart part : this.connectedParts) {
            if (((String)((Object)part.getBlockState().func_177229_b((IProperty)BlockMultiCrafter.VARIANTS))).equals("storage")) {
                ++this.pages;
                TileMultiCrafter tile = (TileMultiCrafter)part;
                tile.getNode().rebuildPatterns();
                if (tile.page.isPresent()) {
                    collector.put(tile.page.get(), tile);
                } else {
                    collector.put(append++, tile);
                }
            }
            if (!((String)((Object)part.getBlockState().func_177229_b((IProperty)BlockMultiCrafter.VARIANTS))).equals("cpu")) continue;
            ++this.speed;
        }
        int newid = 0;
        for (TileMultiCrafter tile : collector.values()) {
            tile.page = Optional.of(++newid);
            this.invs.put(newid, tile.getNode().patterns);
        }
    }

    public ItemHandlerBase getInvForPage(int page) {
        return this.invs.get(page);
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
        for (IMultiblockPart part : this.connectedParts) {
            TileMultiCrafter tile = (TileMultiCrafter)part;
            tile.getNode().rebuildPatterns();
        }
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 27;
    }

    protected int getMaximumXSize() {
        return 16;
    }

    protected int getMaximumZSize() {
        return 16;
    }

    protected int getMaximumYSize() {
        return 16;
    }

    protected int getMinimumXSize() {
        return 3;
    }

    protected int getMinimumYSize() {
        return 3;
    }

    protected int getMinimumZSize() {
        return 3;
    }

    protected void onAssimilate(MultiblockControllerBase multiblockControllerBase) {
    }

    protected void onAssimilated(MultiblockControllerBase multiblockControllerBase) {
    }

    protected boolean updateServer() {
        return false;
    }

    protected void updateClient() {
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
    }

    public void formatDescriptionPacket(NBTTagCompound nbtTagCompound) {
        this.writeToNBT(nbtTagCompound);
    }

    public void decodeDescriptionPacket(NBTTagCompound nbtTagCompound) {
        this.readFromNBT(nbtTagCompound);
    }
}

