/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.controller;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.controller.OrbitalEffectController;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.tile.TileAttunementAltar;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;

public class OrbitalPropertiesAttunement
implements OrbitalEffectController.OrbitPersistence,
OrbitalEffectController.OrbitPointEffect {
    private static final Random rand = new Random();
    private int persistanceRequests = 8;
    private final TileAttunementAltar ta;
    private final boolean player;

    public OrbitalPropertiesAttunement(TileAttunementAltar ta, boolean player) {
        this.ta = ta;
        this.player = player;
    }

    public void setPersistanceRequests(int req) {
        this.persistanceRequests = req;
    }

    @Override
    public boolean canPersist(OrbitalEffectController controller) {
        int mode = this.ta.getMode();
        if (this.player) {
            if (mode != 1) {
                return false;
            }
            --this.persistanceRequests;
            return this.persistanceRequests >= 0;
        }
        if (mode != 2) {
            return false;
        }
        --this.persistanceRequests;
        return this.persistanceRequests >= 0;
    }

    @Override
    public void doPointTickEffect(OrbitalEffectController ctrl, Vector3 pos) {
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(pos.getX(), pos.getY(), pos.getZ());
        p.motion(rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1));
        p.setMaxAge(25);
        p.scale(0.3f).gravity(0.004);
        if (rand.nextBoolean()) {
            p = EffectHelper.genericFlareParticle(pos.getX(), pos.getY(), pos.getZ());
            p.motion(0.0, 0.03 + (double)(rand.nextFloat() * 0.04f), 0.0);
            p.setMaxAge(35);
            p.scale(0.25f).gravity(0.004).setColor(Color.WHITE);
        }
        if (rand.nextBoolean()) {
            p = EffectHelper.genericFlareParticle(pos.getX(), pos.getY(), pos.getZ());
            p.motion(0.0, 0.03 + (double)(rand.nextFloat() * 0.04f), 0.0);
            p.setMaxAge(35);
            p.scale(0.25f).gravity(0.004).setColor(Color.WHITE);
        }
    }
}

