/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.fx;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.IComplexEffect;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public abstract class EntityFXFacingSprite
extends EntityComplexFX
implements IComplexEffect.PreventRemoval {
    private final SpriteSheetResource spriteSheet;
    private double x;
    private double y;
    private double z;
    private double prevX;
    private double prevY;
    private double prevZ;
    private final float scale;
    private Color overlayColor = Color.WHITE;
    private EntityComplexFX.RefreshFunction refreshFunction;
    private EntityComplexFX.PositionController positionUpdateFunction;

    public EntityFXFacingSprite(SpriteSheetResource spriteSheet, double x, double y, double z) {
        this(spriteSheet, x, y, z, 1.0f);
    }

    public EntityFXFacingSprite(SpriteSheetResource spriteSheet, double x, double y, double z, float scale) {
        this.spriteSheet = spriteSheet;
        this.x = x;
        this.y = y;
        this.z = z;
        this.prevX = x;
        this.prevY = y;
        this.prevZ = z;
        this.scale = scale;
        this.maxAge = spriteSheet.getFrameCount();
    }

    public EntityFXFacingSprite updatePosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public void setOverlayColor(@Nonnull Color overlayColor) {
        this.overlayColor = overlayColor;
    }

    public static EntityFXFacingSprite fromSpriteSheet(SpriteSheetResource res, double x, double y, double z, float scale, final int rLayer) {
        return new EntityFXFacingSprite(res, x, y, z, scale){

            @Override
            public int getLayer() {
                return rLayer;
            }
        };
    }

    public EntityFXFacingSprite setPositionUpdateFunction(EntityComplexFX.PositionController positionUpdateFunction) {
        this.positionUpdateFunction = positionUpdateFunction;
        return this;
    }

    public EntityFXFacingSprite setRefreshFunc(EntityComplexFX.RefreshFunction func) {
        this.refreshFunction = func;
        return this;
    }

    protected float getULengthMultiplier() {
        return 1.0f;
    }

    protected float getVLengthMultiplier() {
        return 1.0f;
    }

    protected int getAgeBasedFrame() {
        float perc = (float)this.age / (float)this.maxAge;
        return MathHelper.func_76141_d((float)((float)this.spriteSheet.getFrameCount() * perc));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.maxAge >= 0 && this.age >= this.maxAge && this.refreshFunction != null) {
            Entity rView = Minecraft.func_71410_x().func_175606_aa();
            if (rView == null) {
                rView = Minecraft.func_71410_x().field_71439_g;
            }
            if (rView.func_70092_e(this.x, this.y, this.z) <= (double)Config.maxEffectRenderDistanceSq && this.refreshFunction.shouldRefresh()) {
                this.age = 0;
            }
        }
        if (this.positionUpdateFunction != null) {
            this.prevX = this.x;
            this.prevY = this.y;
            this.prevZ = this.z;
            Vector3 newPos = this.positionUpdateFunction.updatePosition(this, new Vector3(this.x, this.y, this.z), new Vector3());
            this.x = newPos.getX();
            this.y = newPos.getY();
            this.z = newPos.getZ();
        }
    }

    @Override
    public void render(float pTicks) {
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        Color c = this.overlayColor;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int frame = this.getAgeBasedFrame();
        Tuple<Double, Double> uv = this.spriteSheet.getUVOffset(frame);
        this.spriteSheet.getResource().bind();
        double iX = RenderingUtils.interpolate(this.prevX, this.x, pTicks);
        double iY = RenderingUtils.interpolate(this.prevY, this.y, pTicks);
        double iZ = RenderingUtils.interpolate(this.prevZ, this.z, pTicks);
        RenderingUtils.renderFacingColoredQuad(iX, iY, iZ, pTicks, this.scale, 0.0f, (Double)uv.key, (Double)uv.value, this.spriteSheet.getULength() * (double)this.getULengthMultiplier(), this.spriteSheet.getVLength() * (double)this.getVLengthMultiplier(), c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        GlStateManager.func_179084_k();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
    }
}

