/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.fx;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class EntityFXFloatingCube
extends EntityComplexFX {
    private final TextureAtlasSprite tas;
    private EntityComplexFX.MotionController<EntityFXFloatingCube> motionController = (fx, v) -> v;
    private EntityComplexFX.PositionController<EntityFXFloatingCube> positionController = (fx, v, m) -> v.add(m);
    private Vector3 rotationDegreeAxis = new Vector3();
    private Vector3 prevRotationDegreeAxis = new Vector3();
    private Vector3 rotationChange = new Vector3();
    private Vector3 motion = new Vector3();
    private Vector3 position = new Vector3();
    private Vector3 prevPosition = new Vector3();
    private Blending blending = Blending.ADDITIVEDARK;
    private EntityComplexFX.AlphaFunction alphaFunction = EntityComplexFX.AlphaFunction.CONSTANT;
    private float alphaMultiplier = 1.0f;
    private EntityComplexFX.ScaleFunction<EntityFXFloatingCube> scaleFunction = (fx, pTicks, scaleIn) -> scaleIn;
    private float scale = 1.0f;
    private boolean disableDepth = false;
    private float textureSubSizePercentage = 1.0f;
    private int lightCoordX = -1;
    private int lightCoordY = -1;

    public EntityFXFloatingCube(IBlockState blockState) {
        this.tas = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockState);
    }

    public EntityFXFloatingCube(TextureAtlasSprite tas) {
        this.tas = tas;
    }

    public EntityFXFloatingCube setDisableDepth(boolean disableDepth) {
        this.disableDepth = disableDepth;
        return this;
    }

    public EntityFXFloatingCube setWorldLightCoord(World iba, BlockPos pos) {
        int light = iba.func_175667_e(pos) ? iba.func_175626_b(pos, 0) : 0;
        this.lightCoordX = light >> 16 & 0xFFFF;
        this.lightCoordY = light & 0xFFFF;
        return this;
    }

    public EntityFXFloatingCube setTextureSubSizePercentage(float textureSubSizePercentage) {
        this.textureSubSizePercentage = textureSubSizePercentage;
        return this;
    }

    public EntityFXFloatingCube setBlendMode(Blending blending) {
        this.blending = blending;
        return this;
    }

    public EntityFXFloatingCube setPosition(Vector3 position) {
        this.position = position;
        this.prevPosition = this.position.clone();
        return this;
    }

    public EntityFXFloatingCube setPosition(double x, double y, double z) {
        this.position = new Vector3(x, y, z);
        this.prevPosition = this.position.clone();
        return this;
    }

    public EntityFXFloatingCube setMotion(Vector3 motion) {
        this.motion = motion;
        return this;
    }

    public EntityFXFloatingCube setMotion(double x, double y, double z) {
        this.motion = new Vector3(x, y, z);
        return this;
    }

    public EntityFXFloatingCube setMotionController(EntityComplexFX.MotionController<EntityFXFloatingCube> motionController) {
        this.motionController = motionController;
        return this;
    }

    public EntityFXFloatingCube setPositionController(EntityComplexFX.PositionController<EntityFXFloatingCube> positionController) {
        this.positionController = positionController;
        return this;
    }

    public EntityFXFloatingCube setAlphaFunction(EntityComplexFX.AlphaFunction alphaFunction) {
        this.alphaFunction = alphaFunction;
        return this;
    }

    public EntityFXFloatingCube setAlphaMultiplier(float alphaMultiplier) {
        this.alphaMultiplier = alphaMultiplier;
        return this;
    }

    public EntityFXFloatingCube setScaleFunction(EntityComplexFX.ScaleFunction<EntityFXFloatingCube> scaleFunction) {
        this.scaleFunction = scaleFunction;
        return this;
    }

    public EntityFXFloatingCube setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public EntityFXFloatingCube tumble() {
        this.rotationDegreeAxis = Vector3.positiveYRandom().multiply(360);
        this.rotationChange = Vector3.random().multiply(12);
        return this;
    }

    public Vector3 getMotion() {
        return this.motion;
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public Vector3 getRotation() {
        return this.rotationDegreeAxis;
    }

    public Vector3 getInterpolatedPosition(float percent) {
        return new Vector3(RenderingUtils.interpolate(this.prevPosition.getX(), this.position.getX(), percent), RenderingUtils.interpolate(this.prevPosition.getY(), this.position.getY(), percent), RenderingUtils.interpolate(this.prevPosition.getZ(), this.position.getZ(), percent));
    }

    public Vector3 getInterpolatedRotation(float percent) {
        return new Vector3(RenderingUtils.interpolate(this.prevRotationDegreeAxis.getX(), this.rotationDegreeAxis.getX(), percent), RenderingUtils.interpolate(this.prevRotationDegreeAxis.getY(), this.rotationDegreeAxis.getY(), percent), RenderingUtils.interpolate(this.prevRotationDegreeAxis.getZ(), this.rotationDegreeAxis.getZ(), percent));
    }

    @Override
    public int getLayer() {
        return 1;
    }

    @Override
    public void tick() {
        super.tick();
        Vector3 motion = this.motion.clone();
        if (this.motionController != null) {
            motion = this.motionController.updateMotion(this, motion);
        }
        this.motion = motion.clone();
        if (this.positionController != null) {
            Vector3 newPos = this.positionController.updatePosition(this, this.position.clone(), this.motion);
            this.prevPosition = this.position.clone();
            this.position = newPos;
        } else {
            this.prevPosition = this.position.clone();
            this.position.add(this.motion);
        }
        if (this.rotationChange.lengthSquared() > 0.0) {
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
            this.rotationDegreeAxis.add(this.rotationChange);
        }
    }

    @Override
    public void render(float pTicks) {
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.blending == null) {
            GL11.glDisable((int)3042);
        } else {
            GL11.glEnable((int)3042);
            this.blending.apply();
        }
        if (this.disableDepth) {
            GL11.glDisable((int)2929);
        }
        GL11.glDisable((int)2884);
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        Vector3 translateTo = this.getInterpolatedPosition(pTicks);
        GL11.glTranslated((double)translateTo.getX(), (double)translateTo.getY(), (double)translateTo.getZ());
        float alpha = this.alphaFunction.getAlpha(this.age, this.maxAge);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha *= this.alphaMultiplier));
        float scaleF = this.scale;
        scaleF = this.scaleFunction.getScale(this, pTicks, scaleF);
        GL11.glScaled((double)scaleF, (double)scaleF, (double)scaleF);
        Vector3 rotation = this.getInterpolatedRotation(pTicks);
        GL11.glRotated((double)rotation.getX(), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotation.getY(), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotation.getZ(), (double)0.0, (double)0.0, (double)1.0);
        double u = this.tas.func_94209_e();
        double v = this.tas.func_94206_g();
        double uLength = (this.tas.func_94212_f() - this.tas.func_94209_e()) * this.textureSubSizePercentage;
        double vLength = (this.tas.func_94210_h() - this.tas.func_94206_g()) * this.textureSubSizePercentage;
        if (this.lightCoordX == -1 && this.lightCoordY == -1) {
            RenderingUtils.renderTexturedCubeCentralWithColor(new Vector3(), scaleF, u, v, uLength, vLength, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderingUtils.renderTexturedCubeCentralWithLightAndColor(new Vector3(), scaleF, u, v, uLength, vLength, this.lightCoordX, this.lightCoordY, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        GL11.glEnable((int)2884);
        if (this.disableDepth) {
            GL11.glEnable((int)2929);
        }
        Blending.DEFAULT.apply();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        TextureHelper.refreshTextureBindState();
    }

    private int getLight() {
        BlockPos blockpos = this.position.toBlockPos();
        return Minecraft.func_71410_x().field_71441_e.func_175667_e(blockpos) ? Minecraft.func_71410_x().field_71441_e.func_175626_b(blockpos, 0) : 0;
    }
}

