/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.GuiTelescope;
import hellfirepvp.astralsorcery.client.gui.GuiWHScreen;
import hellfirepvp.astralsorcery.client.sky.RenderAstralSkybox;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktDiscoverConstellation;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class GuiHandTelescope
extends GuiWHScreen {
    private static final Random random = new Random();
    private static final BindableResource textureGrid = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "gridhandtelescope");
    private static final BindableResource textureConnection = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionperks");
    private static final Rectangle rectDrawing = new Rectangle(6, 6, 210, 210);
    private IMajorConstellation drawnConstellation = null;
    private Map<StarLocation, Rectangle> drawnStars = null;
    private static final int randomStars = 40;
    private List<StarPosition> usedStars = new ArrayList<StarPosition>(40);
    private IMajorConstellation topFound = null;
    private float selectedYaw = 0.0f;
    private float selectedPitch = 0.0f;
    private boolean grabCursor = false;
    private static final float THRESHOLD_TO_START = 0.8f;
    private static final float THRESHOLD_TO_SHIFT_BLUEGRAD = 0.5f;
    private static final float THRESHOLD_TO_MAX_BLUEGRAD = 0.2f;
    private static final float THRESHOLD_FROM_START = 1.0f;
    private static final float THRESHOLD_FROM_SHIFT_BLUEGRAD = 0.6f;
    private static final float THRESHOLD_FROM_MAX_BLUEGRAD = 0.3f;
    private LinkedList<GuiTelescope.Line> drawnLines = new LinkedList();
    private Point start;
    private Point end;

    public GuiHandTelescope() {
        super(216, 216);
        Optional<Long> currSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e);
        if (currSeed.isPresent()) {
            this.setupInitialStars(currSeed.get());
        }
    }

    private void setupInitialStars(long seed) {
        IMajorConstellation bestGuess;
        int offsetX = 6;
        int offsetY = 6;
        int width = this.guiWidth - 6;
        int height = this.guiHeight - 6;
        Random rand = new Random(seed);
        int day = (int)(Minecraft.func_71410_x().field_71441_e.func_72820_D() / 24000L);
        for (int i = 0; i < day; ++i) {
            rand.nextLong();
        }
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        if (handle != null && (bestGuess = (IMajorConstellation)handle.getHighestDistributionConstellation(rand, c -> c instanceof IMajorConstellation)) != null && handle.getCurrentDistribution(bestGuess, f -> Float.valueOf(1.0f)).floatValue() >= 0.8f && bestGuess.canDiscover(ResearchManager.clientProgress)) {
            this.topFound = bestGuess;
            this.selectedYaw = rand.nextFloat() * 360.0f - 180.0f;
            this.selectedPitch = -90.0f + rand.nextFloat() * 25.0f;
        }
        for (int i = 0; i < 40; ++i) {
            this.usedStars.add(new StarPosition((float)offsetX + rand.nextFloat() * (float)width, (float)offsetY + rand.nextFloat() * (float)height));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.field_146297_k.func_71381_h();
        if (Minecraft.field_142025_a) {
            Mouse.setGrabbed((boolean)false);
            Mouse.setCursorPosition((int)(Display.getWidth() / 2), (int)(Display.getHeight() / 2 - 20));
            Mouse.setGrabbed((boolean)true);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71417_B.func_74372_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        this.drawWHRect(textureGrid);
        TextureHelper.refreshTextureBindState();
        this.handleMouseMovement(partialTicks);
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        float pitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        float transparency = 0.0f;
        if (pitch < -60.0f) {
            transparency = 1.0f;
        } else if (pitch < -10.0f) {
            transparency = (Math.abs(pitch) - 10.0f) / 50.0f;
            if (ConstellationSkyHandler.getInstance().isNight((World)w)) {
                transparency *= transparency;
            }
        }
        boolean canSeeSky = this.canTelescopeSeeSky((World)w);
        if (this.usedStars.isEmpty()) {
            Optional<Long> currSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e);
            if (currSeed.isPresent()) {
                this.setupInitialStars(currSeed.get());
                this.field_73735_i -= 5.0f;
                this.drawCellWithEffects(partialTicks, canSeeSky, transparency);
                this.field_73735_i += 5.0f;
            }
        } else {
            this.field_73735_i -= 5.0f;
            this.drawCellWithEffects(partialTicks, canSeeSky, transparency);
            this.field_73735_i += 5.0f;
        }
        TextureHelper.refreshTextureBindState();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void handleMouseMovement(float pticks) {
        boolean ctrl = GuiHandTelescope.func_146272_n();
        if (this.grabCursor && !ctrl) {
            Minecraft.func_71410_x().field_71417_B.func_74372_a();
            this.grabCursor = false;
            this.clearLines();
        }
        if (!this.grabCursor && ctrl) {
            Minecraft.func_71410_x().field_71417_B.func_74373_b();
            this.grabCursor = true;
        }
        if (!ctrl) {
            float movementY;
            float movementX;
            this.field_146297_k.field_71417_B.func_74374_c();
            float f = this.field_146297_k.field_71474_y.field_74341_c * 0.6f + 0.2f;
            float f1 = f * f * f * 8.0f;
            float f2 = (float)this.field_146297_k.field_71417_B.field_74377_a * f1;
            float f3 = (float)this.field_146297_k.field_71417_B.field_74375_b * f1;
            int i = 1;
            if (this.field_146297_k.field_71474_y.field_74338_d) {
                i = -1;
            }
            EntityRenderer er = Minecraft.func_71410_x().field_71460_t;
            if (this.field_146297_k.field_71474_y.field_74326_T) {
                er.field_78496_H += f2;
                er.field_78497_I += f3;
                float f4 = pticks - er.field_78492_L;
                er.field_78492_L = pticks;
                f2 = er.field_78498_J * f4;
                f3 = er.field_78499_K * f4;
                movementX = f2;
                movementY = f3 * (float)i;
            } else {
                er.field_78496_H = 0.0f;
                er.field_78497_I = 0.0f;
                movementX = f2;
                movementY = f3 * (float)i;
            }
            boolean nullify = this.field_146297_k.field_71439_g.field_70125_A <= -89.99f && Math.abs(movementY) == movementY;
            this.field_146297_k.field_71439_g.func_70082_c(movementX, movementY);
            if (nullify) {
                movementY = 0.0f;
            }
            this.handleHandMovement(MathHelper.func_76141_d((float)movementX), MathHelper.func_76141_d((float)movementY));
        }
    }

    private void handleHandMovement(int changeX, int changeY) {
        int offsetX = 6;
        int offsetY = 6;
        int width = this.guiWidth - 12;
        int height = this.guiHeight - 12;
        Iterator<StarPosition> iterator = this.usedStars.iterator();
        while (iterator.hasNext()) {
            StarPosition sl;
            StarPosition starPosition = sl = iterator.next();
            starPosition.x = starPosition.x - (float)changeX;
            starPosition = sl;
            starPosition.y = starPosition.y + (float)changeY;
            if (sl.x < (float)offsetX) {
                starPosition = sl;
                starPosition.x = starPosition.x + (float)width;
            } else if (sl.x > (float)(offsetX + width)) {
                starPosition = sl;
                starPosition.x = starPosition.x - (float)width;
            }
            if (sl.y < (float)offsetY) {
                starPosition = sl;
                starPosition.y = starPosition.y + (float)height;
                continue;
            }
            if (!(sl.y > (float)(offsetY + height))) continue;
            starPosition = sl;
            starPosition.y = starPosition.y - (float)height;
        }
    }

    private void drawCellWithEffects(float partialTicks, boolean canSeeSky, float transparency) {
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        int lastTracked = handle == null ? 5 : handle.lastRecordedDay;
        Optional<Long> seed = ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e);
        long s = 0L;
        if (seed.isPresent()) {
            s = seed.get();
        }
        Random r = new Random(s * 31L + (long)(lastTracked * 31));
        this.drawnConstellation = null;
        this.drawnStars = null;
        if (handle != null) {
            IMajorConstellation bestGuess = (IMajorConstellation)handle.getHighestDistributionConstellation(r, c -> c instanceof IMajorConstellation);
            if ((this.topFound == null || !this.topFound.equals(bestGuess)) && handle.getCurrentDistribution(bestGuess, f -> Float.valueOf(1.0f)).floatValue() >= 0.8f) {
                this.topFound = bestGuess;
                this.selectedYaw = r.nextFloat() * 360.0f - 180.0f;
                this.selectedPitch = -90.0f + r.nextFloat() * 45.0f;
            }
        }
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        this.drawGridBackground(partialTicks, canSeeSky, transparency);
        if (canSeeSky) {
            int offsetX = this.guiLeft;
            int offsetZ = this.guiTop;
            this.field_73735_i += 1.0f;
            Optional<Map<StarLocation, Rectangle>> stars = this.drawCellEffect(offsetX, offsetZ, this.getGuiWidth(), this.getGuiHeight(), partialTicks, transparency);
            this.field_73735_i -= 1.0f;
            if (stars.isPresent()) {
                this.drawnConstellation = this.topFound;
                this.drawnStars = stars.get();
            }
        } else {
            this.abortDrawing();
            this.clearLines();
        }
        this.field_73735_i += 2.0f;
        this.drawDrawnLines(r, partialTicks);
        this.field_73735_i -= 2.0f;
    }

    private void drawDrawnLines(final Random r, final float pTicks) {
        if (!this.canStartDrawing()) {
            this.clearLines();
            this.abortDrawing();
            return;
        }
        float linebreadth = 2.0f;
        RenderConstellation.BrightnessFunction func = new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), pTicks, 5 + r.nextInt(15));
            }
        };
        textureConnection.bind();
        for (int j = 0; j < 2; ++j) {
            for (GuiTelescope.Line l : this.drawnLines) {
                this.drawLine(l.start, l.end, func, linebreadth, true);
            }
            if (this.start == null || this.end == null) continue;
            Point adjStart = new Point(this.start.x - this.guiLeft, this.start.y - this.guiTop);
            Point adjEnd = new Point(this.end.x - this.guiLeft, this.end.y - this.guiTop);
            this.drawLine(adjStart, adjEnd, func, linebreadth, false);
        }
    }

    private void drawLine(Point start, Point end, RenderConstellation.BrightnessFunction func, float linebreadth, boolean applyFunc) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        float brightness = applyFunc ? func.getBrightness() : 1.0f;
        float starBr = Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f);
        if (starBr <= 0.0f) {
            return;
        }
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)(brightness < 0.0f ? 0.0f : (brightness *= starBr * 2.0f)));
        Vector3 fromStar = new Vector3((double)this.guiLeft + start.getX(), (double)this.guiTop + start.getY(), (double)this.field_73735_i);
        Vector3 toStar = new Vector3((double)this.guiLeft + end.getX(), (double)this.guiTop + end.getY(), (double)this.field_73735_i);
        Vector3 dir = toStar.clone().subtract(fromStar);
        Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(linebreadth);
        Vector3 vec00 = fromStar.clone().add(degLot);
        Vector3 vecV = degLot.clone().multiply(-2);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
        }
        tes.func_78381_a();
    }

    private Optional<Map<StarLocation, Rectangle>> drawCellEffect(int offsetX, int offsetY, int width, int height, final float partialTicks, final float transparency) {
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        GL11.glDisable((int)3008);
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        int lastTracked = handle == null ? 5 : handle.lastRecordedDay;
        final Random r = new Random();
        RenderAstralSkybox.TEX_STAR_1.bind();
        for (StarPosition stars : this.usedStars) {
            r.setSeed(stars.seed);
            GL11.glPushMatrix();
            float brightness = 0.3f + RenderConstellation.stdFlicker(ClientScheduler.getClientTick(), partialTicks, 10 + r.nextInt(20)) * 0.6f;
            brightness *= Minecraft.func_71410_x().field_71441_e.func_72880_h(partialTicks) * 2.0f * transparency;
            GL11.glColor4f((float)(brightness *= 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks)), (float)brightness, (float)brightness, (float)brightness);
            this.drawRect(MathHelper.func_76141_d((float)((float)offsetX + stars.x)), MathHelper.func_76141_d((float)((float)offsetY + stars.y)), 5, 5);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        r.setSeed(lastTracked * 31);
        Map<StarLocation, Rectangle> rectangles = null;
        if (this.topFound != null) {
            this.field_73735_i += 1.0f;
            float playerYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z % 360.0f;
            if (playerYaw < 0.0f) {
                playerYaw += 360.0f;
            }
            if (playerYaw >= 180.0f) {
                playerYaw -= 360.0f;
            }
            float playerPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
            float diffYaw = playerYaw - this.selectedYaw;
            float diffPitch = playerPitch - this.selectedPitch;
            float sFactor = 35.0f;
            if ((Math.abs(diffYaw) <= sFactor || Math.abs(playerYaw + 360.0f) <= sFactor) && Math.abs(diffPitch) <= sFactor) {
                ScaledResolution res = new ScaledResolution(this.field_146297_k);
                GL11.glEnable((int)3089);
                GL11.glScissor((int)((this.guiLeft + 5) * res.func_78325_e()), (int)((this.guiTop + 5) * res.func_78325_e()), (int)((this.guiWidth - 10) * res.func_78325_e()), (int)((this.guiHeight - 10) * res.func_78325_e()));
                int wPart = (int)((float)width * 0.1f);
                int hPart = (int)((float)height * 0.1f);
                rectangles = RenderConstellation.renderConstellationIntoGUI(this.topFound, offsetX + wPart + MathHelper.func_76141_d((float)(diffYaw / sFactor * (float)width)), offsetY + hPart + MathHelper.func_76141_d((float)(diffPitch / sFactor * (float)height)), this.field_73735_i, width - (int)((float)wPart * 1.5f), height - (int)((float)hPart * 1.5f), 2.0, new RenderConstellation.BrightnessFunction(){

                    @Override
                    public float getBrightness() {
                        return (0.3f + 0.7f * RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), partialTicks, 5 + r.nextInt(15))) * transparency;
                    }
                }, ResearchManager.clientProgress.hasConstellationDiscovered(this.topFound.getUnlocalizedName()), true);
                GL11.glDisable((int)3089);
            }
            this.field_73735_i -= 1.0f;
        }
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glPopAttrib();
        return Optional.ofNullable(rectangles);
    }

    private void drawGridBackground(float partialTicks, boolean canSeeSky, float angleTransparency) {
        int rgbTo;
        int rgbFrom;
        GL11.glPushAttrib((int)1048575);
        Blending.PREALPHA.apply();
        WorldClient renderWorld = Minecraft.func_71410_x().field_71441_e;
        if (canSeeSky && (double)angleTransparency > 1.0E-4) {
            float starBr = renderWorld.func_72880_h(partialTicks) * 2.0f;
            float rain = renderWorld.func_72867_j(partialTicks);
            rgbFrom = RenderingUtils.clampToColorWithMultiplier(this.calcRGBFromWithRain(starBr, rain), angleTransparency).getRGB();
            rgbTo = RenderingUtils.clampToColorWithMultiplier(this.calcRGBToWithRain(starBr, rain), angleTransparency).getRGB();
        } else {
            rgbFrom = 0;
            rgbTo = 0;
        }
        int alphaMask = -16777216;
        RenderingUtils.drawGradientRect(this.guiLeft + 4, this.guiTop + 4, this.field_73735_i, this.guiLeft + this.guiWidth - 4, this.guiTop + this.guiHeight - 4, new Color(alphaMask | rgbFrom), new Color(alphaMask | rgbTo));
        Blending.DEFAULT.apply();
        GL11.glPopAttrib();
    }

    private boolean canTelescopeSeeSky(World renderWorld) {
        BlockPos pos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                BlockPos other = pos.func_177982_a(xx, 0, zz);
                if (renderWorld.func_175678_i(other)) continue;
                return false;
            }
        }
        return renderWorld.func_175678_i(pos);
    }

    private int calcRGBToWithRain(float starBr, float rain) {
        int to = this.calcRGBTo(starBr);
        if (starBr <= 0.8f) {
            float starMul = 1.0f;
            if (starBr > 0.5f) {
                starMul = 1.0f - (starBr - 0.5f) / 0.3f;
            }
            float interpDeg = starMul * rain;
            Color safeTo = RenderingUtils.clampToColor(to);
            Vector3 vTo = new Vector3(safeTo.getRed(), safeTo.getGreen(), safeTo.getBlue()).divide(255.0);
            Vector3 rainC = new Vector3(102, 114, 137).divide(255.0);
            Vector3 interpVec = vTo.copyInterpolateWith(rainC, interpDeg);
            Color newColor = RenderingUtils.clampToColor((int)(interpVec.getX() * 255.0), (int)(interpVec.getY() * 255.0), (int)(interpVec.getZ() * 255.0));
            to = newColor.getRGB();
        }
        return RenderingUtils.clampToColor(to).getRGB();
    }

    private int calcRGBTo(float starBr) {
        if (starBr >= 0.8f) {
            return 0;
        }
        if (starBr >= 0.5f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.5f) / partSize;
            return (int)(perc * 170.0f);
        }
        if (starBr >= 0.2f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.2f) / partSize;
            int green = (int)(perc * 85.0f);
            int blue = green + 170;
            return green << 8 | blue;
        }
        float partSize = 0.2f;
        float perc = 1.0f - (starBr - 0.0f) / partSize;
        int green = 85 + (int)(perc * 90.0f);
        int red = (int)(perc * 140.0f);
        return red << 16 | green << 8 | 0xFF;
    }

    private int calcRGBFromWithRain(float starBr, float rain) {
        int to = this.calcRGBFrom(starBr);
        if (starBr <= 1.0f) {
            float starMul = 1.0f;
            if (starBr > 0.6f) {
                starMul = 1.0f - (starBr - 0.6f) / 0.39999998f;
            }
            float interpDeg = starMul * rain;
            Color safeTo = RenderingUtils.clampToColor(to);
            Vector3 vTo = new Vector3(safeTo.getRed(), safeTo.getGreen(), safeTo.getBlue()).divide(255.0);
            Vector3 rainC = new Vector3(102, 114, 137).divide(255.0);
            Vector3 interpVec = vTo.copyInterpolateWith(rainC, interpDeg);
            Color newColor = RenderingUtils.clampToColor((int)(interpVec.getX() * 255.0), (int)(interpVec.getY() * 255.0), (int)(interpVec.getZ() * 255.0));
            to = newColor.getRGB();
        }
        return RenderingUtils.clampToColor(to).getRGB();
    }

    private int calcRGBFrom(float starBr) {
        if (starBr >= 1.0f) {
            return 0;
        }
        if (starBr >= 0.6f) {
            float partSize = 0.39999998f;
            float perc = 1.0f - (starBr - 0.6f) / partSize;
            return (int)(perc * 170.0f);
        }
        if (starBr >= 0.3f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.3f) / partSize;
            int green = (int)(perc * 85.0f);
            int blue = green + 170;
            return green << 8 | blue;
        }
        float partSize = 0.3f;
        float perc = 1.0f - (starBr - 0.0f) / partSize;
        int green = 85 + (int)(perc * 90.0f);
        int red = (int)(perc * 140.0f);
        return red << 16 | green << 8 | 0xFF;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            this.tryStartDrawing(mouseX, mouseY);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (clickedMouseButton == 0) {
            this.informMovement(mouseX, mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.informRelease(mouseX, mouseY);
        }
    }

    private void tryStartDrawing(int mouseX, int mouseY) {
        if (!this.canStartDrawing()) {
            return;
        }
        if (this.isInDrawingCell(mouseX, mouseY)) {
            this.start = new Point(mouseX, mouseY);
            this.end = new Point(mouseX, mouseY);
        } else {
            this.abortDrawing();
            this.clearLines();
        }
    }

    private boolean canStartDrawing() {
        return Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f) >= 0.35f && Minecraft.func_71410_x().field_71441_e.func_72867_j(1.0f) <= 0.1f && Minecraft.func_71410_x().field_71439_g.field_70125_A <= -45.0f;
    }

    private void clearLines() {
        this.drawnLines.clear();
    }

    private boolean isInDrawingCell(int x, int y) {
        return rectDrawing.contains(x - this.guiLeft, y - this.guiTop);
    }

    private void informMovement(int mouseX, int mouseY) {
        if (!this.isInDrawingCell(mouseX, mouseY)) {
            this.abortDrawing();
            this.clearLines();
        } else {
            this.end = new Point(mouseX, mouseY);
        }
    }

    private void informRelease(int mouseX, int mouseY) {
        if (!this.isInDrawingCell(mouseX, mouseY)) {
            this.abortDrawing();
            this.clearLines();
        } else {
            if (this.start != null) {
                this.end = new Point(mouseX, mouseY);
                this.pushDrawnLine(this.start, this.end);
            } else {
                this.start = null;
                this.end = null;
            }
            this.abortDrawing();
            this.checkConstellation(this.drawnLines);
        }
    }

    private void checkConstellation(List<GuiTelescope.Line> drawnLines) {
        IMajorConstellation c = this.drawnConstellation;
        if (c == null || ResearchManager.clientProgress.hasConstellationDiscovered(c.getUnlocalizedName())) {
            return;
        }
        PlayerProgress client = ResearchManager.clientProgress;
        if (client == null) {
            return;
        }
        boolean has = false;
        for (String strConstellation : client.getSeenConstellations()) {
            IConstellation ce = ConstellationRegistry.getConstellationByName(strConstellation);
            if (ce == null || !ce.equals(c)) continue;
            has = true;
            break;
        }
        if (!has) {
            return;
        }
        List<StarConnection> sc = c.getStarConnections();
        if (sc.size() != drawnLines.size()) {
            return;
        }
        if (!c.canDiscover(ResearchManager.clientProgress)) {
            return;
        }
        for (StarConnection connection : sc) {
            Rectangle fromRect = this.drawnStars.get(connection.from);
            if (fromRect == null) {
                AstralSorcery.log.info("[AstralSorcery] Could not check constellation of telescope drawing - starLocation is missing?");
                return;
            }
            Rectangle toRect = this.drawnStars.get(connection.to);
            if (toRect == null) {
                AstralSorcery.log.info("[AstralSorcery] Could not check constellation of telescope drawing - starLocation is missing?");
                return;
            }
            if (this.containsMatch(drawnLines, fromRect, toRect)) continue;
            return;
        }
        PacketChannel.CHANNEL.sendToServer((IMessage)new PktDiscoverConstellation(c.getUnlocalizedName()));
        this.clearLines();
        this.abortDrawing();
    }

    private boolean containsMatch(List<GuiTelescope.Line> drawnLines, Rectangle r1, Rectangle r2) {
        for (GuiTelescope.Line l : drawnLines) {
            Point start = l.start;
            Point end = l.end;
            start = new Point(start.x + this.guiLeft, start.y + this.guiTop);
            end = new Point(end.x + this.guiLeft, end.y + this.guiTop);
            if ((!r1.contains(start) || !r2.contains(end)) && (!r2.contains(start) || !r1.contains(end))) continue;
            return true;
        }
        return false;
    }

    private void pushDrawnLine(Point start, Point end) {
        if (Math.abs(start.getX() - end.getX()) <= 2.0 && Math.abs(start.getY() - end.getY()) <= 2.0) {
            return;
        }
        Point adjStart = new Point(start.x - this.guiLeft, start.y - this.guiTop);
        Point adjEnd = new Point(end.x - this.guiLeft, end.y - this.guiTop);
        GuiTelescope.Line l = new GuiTelescope.Line(adjStart, adjEnd);
        this.drawnLines.addLast(l);
    }

    private void abortDrawing() {
        this.start = null;
        this.end = null;
    }

    static /* synthetic */ Random access$400() {
        return random;
    }

    private static class StarPosition {
        private float x;
        private float y;
        private long seed = GuiHandTelescope.access$400().nextLong();

        private StarPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

