/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.GuiJournalConstellationCluster;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.mappings.ClientPerkTextureMapping;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerkMap;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerks;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktUnlockPerk;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiJournalPerkMap
extends GuiScreenJournal {
    private static final BindableResource textureResBack = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiresbg");
    private static final float mouseHoverMerge = 0.03f;
    private float mouseHoverPerc = 0.0f;
    private static final double widthHeight = 70.0;
    private Map<ConstellationPerks, Long> unlockPlayMap = new HashMap<ConstellationPerks, Long>();
    private ConstellationPerkMap mapToDisplay = null;
    private IMajorConstellation attunedConstellation = null;
    private Map<Rectangle, ConstellationPerks> thisFramePerks = new HashMap<Rectangle, ConstellationPerks>();

    public GuiJournalPerkMap() {
        super(2);
        ConstellationPerkMap map;
        IMajorConstellation attuned = ResearchManager.clientProgress.getAttunedConstellation();
        if (attuned != null && (map = attuned.getPerkMap()) != null) {
            this.mapToDisplay = map;
            this.attunedConstellation = attuned;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.thisFramePerks.clear();
        Rectangle rectHover = new Rectangle(this.guiLeft + 10, this.guiTop + 5, this.guiWidth - 20, this.guiHeight - 10);
        this.mouseHoverPerc = rectHover.contains(mouseX, mouseY) ? Math.min(1.0f, this.mouseHoverPerc + 0.03f) : Math.max(0.0f, this.mouseHoverPerc - 0.03f);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.refreshTextureBindState();
        this.drawDefault(textureResShell);
        this.drawBaseBackground(this.field_73735_i - 50.0f);
        if (this.mapToDisplay != null) {
            this.drawPerkMap(this.mapToDisplay, new Point(mouseX, mouseY));
        }
        if (this.attunedConstellation != null) {
            this.drawOverlayTexture(this.attunedConstellation);
        }
        this.drawUnlockEffects();
        TextureHelper.refreshTextureBindState();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawUnlockEffects() {
        double whStar = 80.0;
        double whBetweenStars = 10.0;
        double offsetX = (double)this.guiLeft + (double)this.guiWidth / 2.0 - 70.0;
        double offsetY = (double)this.guiTop + (double)this.guiHeight / 2.0 - 70.0;
        Vector3 offset = new Vector3(offsetX, offsetY, (double)this.field_73735_i);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        Iterator<ConstellationPerks> iterator = this.unlockPlayMap.keySet().iterator();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        GL11.glDisable((int)3008);
        while (iterator.hasNext()) {
            SpriteSheetResource sprite;
            ConstellationPerks perk = iterator.next();
            ConstellationPerkMap.Position position = this.mapToDisplay.getPosition(perk);
            if (position == null) continue;
            Long startTick = this.unlockPlayMap.get((Object)perk);
            int count = (int)(ClientScheduler.getClientTick() - startTick);
            if (count >= (sprite = SpriteLibrary.spritePerkActivate).getFrameCount()) {
                iterator.remove();
                continue;
            }
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            sprite.getResource().bind();
            int starX = position.x;
            int starY = position.y;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + 0.8f * this.mouseHoverPerc));
            Vector3 starVec = offset.clone().addX((double)starX * whBetweenStars - whStar).addY((double)starY * whBetweenStars - whStar);
            double uLength = sprite.getULength();
            double vLength = sprite.getVLength();
            Tuple<Double, Double> frameUV = sprite.getUVOffset(count);
            for (int i = 0; i < 4; ++i) {
                int u = (i + 1 & 2) >> 1;
                int v = (i + 2 & 2) >> 1;
                Vector3 pos = starVec.clone().addX(whStar * (double)u * 2.0).addY(whStar * (double)v * 2.0);
                vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181675_d();
            }
            tes.func_78381_a();
        }
        Blending.DEFAULT.apply();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        TextureHelper.refreshTextureBindState();
    }

    private void drawPerkMap(ConstellationPerkMap mapToDisplay, Point mouse) {
        GL11.glDisable((int)3008);
        double whStar = 12.0;
        double whBetweenStars = 10.0;
        double offsetX = (double)this.guiLeft + (double)this.guiWidth / 2.0 - 70.0;
        double offsetY = (double)this.guiTop + (double)this.guiHeight / 2.0 - 70.0;
        this.drawConnections(mapToDisplay, offsetX, offsetY, whBetweenStars, 3.0);
        Map<Rectangle, ConstellationPerks> rects = this.drawStars(mapToDisplay.getPerks(), offsetX, offsetY, whStar, whBetweenStars);
        this.thisFramePerks.putAll(rects);
        for (Rectangle r : rects.keySet()) {
            String unlockStr;
            if (!r.contains(mouse)) continue;
            LinkedList<String> toolTip = new LinkedList<String>();
            ConstellationPerk perk = rects.get(r).getSingleInstance();
            perk.addLocalizedDescription(toolTip);
            toolTip.add("");
            PlayerProgress prog = ResearchManager.clientProgress;
            if (prog.hasPerkUnlocked(perk)) {
                int unlock = prog.getAppliedPerks().get(perk);
                if (unlock > 0) {
                    toolTip.add(I18n.func_135052_a((String)"perk.info.unlocked.level", (Object[])new Object[]{unlock}));
                } else {
                    toolTip.add(I18n.func_135052_a((String)"perk.info.unlocked.free", (Object[])new Object[0]));
                }
                unlockStr = prog.isPerkActive(perk) ? "perk.info.active" : "perk.info.inactive";
            } else if (this.mayUnlockClient(prog, perk)) {
                toolTip.add(I18n.func_135052_a((String)"perk.info.unlock.level", (Object[])new Object[]{prog.getNextFreeLevel()}));
                unlockStr = "perk.info.available";
            } else {
                unlockStr = "perk.info.locked";
            }
            toolTip.add(I18n.func_135052_a((String)unlockStr, (Object[])new Object[0]));
            RenderingUtils.renderBlueTooltip(mouse.x, mouse.y, toolTip, Minecraft.func_71410_x().field_71466_p);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glEnable((int)3008);
    }

    private boolean mayUnlockClient(PlayerProgress prog, ConstellationPerk perk) {
        if (!prog.hasFreeAlignmentLevel()) {
            return false;
        }
        ConstellationPerks enumPerk = ConstellationPerks.getById(perk.getId());
        Map<ConstellationPerk, Integer> appliedPerks = prog.getAppliedPerks();
        if (!appliedPerks.containsKey(perk)) {
            boolean canUnlock = prog.hasFreeAlignmentLevel();
            for (ConstellationPerkMap.Dependency d : this.mapToDisplay.getPerkDependencies()) {
                if (!d.to.equals((Object)enumPerk) || appliedPerks.containsKey(d.from.getSingleInstance())) continue;
                canUnlock = false;
            }
            return canUnlock;
        }
        return false;
    }

    public void playUnlockAnimation(ConstellationPerks perk) {
        ConstellationPerkMap.Position pos = this.mapToDisplay.getPosition(perk);
        if (pos != null) {
            this.unlockPlayMap.put(perk, ClientScheduler.getClientTick());
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"perk.info.unlock", (Object[])new Object[]{I18n.func_135052_a((String)perk.getSingleInstance().getUnlocalizedName(), (Object[])new Object[0])})));
        }
    }

    private void drawConnections(ConstellationPerkMap mapToDisplay, double offsetX, double offsetY, double whBetweenStars, double linebreadth) {
        PlayerProgress prog = ResearchManager.clientProgress;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        Vector3 offset = new Vector3(offsetX, offsetY, (double)this.field_73735_i);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ConstellationPerkMap.Dependency dep : mapToDisplay.getPerkDependencies()) {
            float br;
            BindableResource tex;
            Color overlay = null;
            if (prog.hasPerkUnlocked(dep.to)) {
                tex = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionperks");
                overlay = new Color(0xEEEE00);
            } else {
                tex = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionperks");
                overlay = new Color(0xBBBBFF);
            }
            ConstellationPerkMap.Position from = mapToDisplay.getPosition(dep.from);
            ConstellationPerkMap.Position to = mapToDisplay.getPosition(dep.to);
            if (from == null || to == null) continue;
            long count = ClientScheduler.getClientTick() + (long)from.x + (long)from.y + (long)to.x + (long)to.y;
            double part = (Math.sin(Math.toRadians((double)(count * 8L) % 360.0)) + 1.0) / 4.0;
            float rR = br = 0.5f + 0.2f * (2.0f - (float)part);
            float rG = br;
            float rB = br;
            float rA = br;
            if (overlay != null) {
                rR *= (float)overlay.getRed() / 255.0f;
                rG *= (float)overlay.getGreen() / 255.0f;
                rB *= (float)overlay.getBlue() / 255.0f;
                rA *= (float)overlay.getAlpha() / 255.0f;
            }
            float aPart = 0.15f * rA;
            GL11.glColor4f((float)rR, (float)rG, (float)rB, (float)(aPart + rA * 0.85f * this.mouseHoverPerc));
            tex.bind();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Vector3 fromStar = new Vector3(offset.getX() + (double)from.x * whBetweenStars, offset.getY() + (double)from.y * whBetweenStars, offset.getZ());
            Vector3 toStar = new Vector3(offset.getX() + (double)to.x * whBetweenStars, offset.getY() + (double)to.y * whBetweenStars, offset.getZ());
            Vector3 dir = toStar.clone().subtract(fromStar);
            Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(linebreadth);
            Vector3 vec00 = fromStar.clone().add(degLot);
            Vector3 vecV = degLot.clone().multiply(-2);
            for (int i = 0; i < 4; ++i) {
                int u = (i + 1 & 2) >> 1;
                int v = (i + 2 & 2) >> 1;
                Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
                vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
            }
            tes.func_78381_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private Map<Rectangle, ConstellationPerks> drawStars(Map<ConstellationPerks, ConstellationPerkMap.Position> perks, double offsetX, double offsetY, double whStar, double whBetweenStars) {
        HashMap<Rectangle, ConstellationPerks> drawn = new HashMap<Rectangle, ConstellationPerks>(perks.size());
        PlayerProgress prog = ResearchManager.clientProgress;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        Vector3 offset = new Vector3(offsetX, offsetY, (double)this.field_73735_i);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Map.Entry<ConstellationPerks, ConstellationPerkMap.Position> star : perks.entrySet()) {
            float br;
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            SpriteSheetResource sprite = prog.hasPerkUnlocked(star.getKey()) ? SpriteLibrary.spritePerkActive : (this.mayUnlockClient(prog, star.getKey().getSingleInstance()) ? SpriteLibrary.spritePerkActivateable : SpriteLibrary.spritePerkInactive);
            sprite.getResource().bind();
            int starX = star.getValue().x;
            int starY = star.getValue().y;
            long count = ClientScheduler.getClientTick() + (long)starX + (long)starY;
            float rR = br = 1.0f;
            float rG = br;
            float rB = br;
            float rA = br;
            float aPart = 0.2f * rA;
            GL11.glColor4f((float)rR, (float)rG, (float)rB, (float)(aPart + rA * 0.8f * this.mouseHoverPerc));
            Vector3 starVec = offset.clone().addX((double)starX * whBetweenStars - whStar).addY((double)starY * whBetweenStars - whStar);
            Point upperLeft = new Point(starVec.getBlockX(), starVec.getBlockY());
            double uLength = sprite.getULength();
            double vLength = sprite.getVLength();
            Tuple<Double, Double> frameUV = sprite.getUVOffset(count);
            for (int i = 0; i < 4; ++i) {
                int u = (i + 1 & 2) >> 1;
                int v = (i + 2 & 2) >> 1;
                Vector3 pos = starVec.clone().addX(whStar * (double)u * 2.0).addY(whStar * (double)v * 2.0);
                vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181675_d();
            }
            drawn.put(new Rectangle(upperLeft.x, upperLeft.y, (int)(whStar * 2.0), (int)(whStar * 2.0)), star.getKey());
            tes.func_78381_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return drawn;
    }

    private void drawOverlayTexture(IMajorConstellation attunedConstellation) {
        BindableResource overlayTex = ClientPerkTextureMapping.getOverlayTexture(attunedConstellation);
        if (overlayTex == null) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)0.87058824f, (float)0.0f, (float)(0.05f + 0.35f * (1.0f - this.mouseHoverPerc)));
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        double overlayWH = 90.0;
        double cX = (double)this.guiLeft + (double)this.guiWidth / 2.0 - overlayWH;
        double cY = (double)this.guiTop + (double)this.guiHeight / 2.0 - overlayWH;
        overlayTex.bind();
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(cX, cY + overlayWH * 2.0, (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b(cX + overlayWH * 2.0, cY + overlayWH * 2.0, (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b(cX + overlayWH * 2.0, cY, (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b(cX, cY, (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawBaseBackground(float zLevel) {
        float br = 0.5f;
        GL11.glColor4f((float)br, (float)br, (float)br, (float)1.0f);
        GL11.glDisable((int)3042);
        textureResBack.bind();
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(this.guiLeft + 10), (double)(this.guiTop - 10 + this.guiHeight), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft - 10 + this.guiWidth), (double)(this.guiTop - 10 + this.guiHeight), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft - 10 + this.guiWidth), (double)(this.guiTop + 10), (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft + 10), (double)(this.guiTop + 10), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        Point p = new Point(mouseX, mouseY);
        if (this.rectResearchBookmark != null && this.rectResearchBookmark.contains(p)) {
            GuiJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalProgression.getJournalInstance());
            return;
        }
        if (this.rectConstellationBookmark != null && this.rectConstellationBookmark.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalConstellationCluster.getConstellationScreen());
            return;
        }
        for (Rectangle r : this.thisFramePerks.keySet()) {
            if (!r.contains(mouseX, mouseY)) continue;
            PlayerProgress prog = ResearchManager.clientProgress;
            ConstellationPerks perk = this.thisFramePerks.get(r);
            if (!prog.hasPerkUnlocked(perk) && this.mayUnlockClient(prog, perk.getSingleInstance())) {
                PktUnlockPerk pkt = new PktUnlockPerk(perk, this.attunedConstellation);
                PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
            }
            return;
        }
    }
}

