/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.GuiJournalConstellationCluster;
import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkMap;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiJournalPages
extends GuiScreenJournal {
    private static GuiJournalPages openGuiInstance;
    private static boolean saveSite;
    private static final BindableResource texArrow;
    private static final BindableResource texUnderline;
    @Nullable
    private final GuiJournalProgression origin;
    @Nullable
    private final GuiScreen previous;
    private final ResearchNode researchNode;
    private List<IGuiRenderablePage> pages;
    private String unlocTitle;
    private boolean informPreviousClose = true;
    private int currentPageOffset = 0;
    private Rectangle rectBack;
    private Rectangle rectNext;
    private Rectangle rectPrev;

    GuiJournalPages(@Nullable GuiJournalProgression origin, ResearchNode node) {
        super(-1);
        this.researchNode = node;
        this.origin = origin;
        this.previous = null;
        this.pages = new ArrayList<IGuiRenderablePage>(node.getPages().size());
        this.pages.addAll(node.getPages().stream().map(IJournalPage::buildRenderPage).collect(Collectors.toList()));
        this.unlocTitle = node.getUnLocalizedName();
    }

    public GuiJournalPages(@Nullable GuiScreen previous, ResearchNode detailedInformation, int exactPage) {
        super(-1);
        this.researchNode = detailedInformation;
        this.origin = null;
        this.previous = previous;
        this.pages = new ArrayList<IGuiRenderablePage>(detailedInformation.getPages().size());
        this.pages.addAll(detailedInformation.getPages().stream().map(IJournalPage::buildRenderPage).collect(Collectors.toList()));
        this.unlocTitle = detailedInformation.getUnLocalizedName();
        this.currentPageOffset = exactPage / 2;
    }

    public int getCurrentPageOffset() {
        return this.currentPageOffset;
    }

    public ResearchNode getResearchNode() {
        return this.researchNode;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.origin != null) {
            this.origin.rescaleAndRefresh = false;
            this.origin.func_183500_a(this.field_146294_l, this.field_146295_m);
            this.origin.func_73866_w_();
        }
    }

    public static GuiJournalPages getClearOpenGuiInstance() {
        GuiJournalPages gui = openGuiInstance;
        openGuiInstance = null;
        return gui;
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.origin != null) {
            if (saveSite) {
                openGuiInstance = this;
                GuiJournalProgression.getJournalInstance().rescaleAndRefresh = false;
            } else {
                saveSite = true;
                openGuiInstance = null;
            }
        }
        if (this.previous != null && this.informPreviousClose) {
            this.previous.func_146281_b();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        if (this.origin != null) {
            this.drawDefault(textureResBlank);
        } else {
            this.drawWHRect(textureResBlank);
        }
        TextureHelper.refreshTextureBindState();
        this.field_73735_i += 100.0f;
        int pageOffsetY = 20;
        if (this.currentPageOffset == 0) {
            TextureHelper.refreshTextureBindState();
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            String name = I18n.func_135052_a((String)this.unlocTitle, (Object[])new Object[0]);
            double width = this.field_146289_q.func_78256_a(name);
            GL11.glTranslated((double)(this.guiLeft + 117), (double)(this.guiTop + 22), (double)0.0);
            GL11.glScaled((double)1.3, (double)1.3, (double)1.3);
            GL11.glTranslated((double)(-(width / 2.0)), (double)0.0, (double)0.0);
            this.field_146289_q.func_78276_b(name, 0, 0, 0xDDDDDD);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
            texUnderline.bind();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.guiLeft + 30), (double)(this.guiTop + 35), (double)this.field_73735_i);
            this.drawTexturedRectAtCurrentPos(175.0, 6.0);
            GL11.glPopMatrix();
            pageOffsetY = 50;
            TextureHelper.refreshTextureBindState();
        }
        int index = this.currentPageOffset * 2;
        if (this.pages.size() > index) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            IGuiRenderablePage page = this.pages.get(index);
            page.render(this.guiLeft + 30, this.guiTop + pageOffsetY, partialTicks, this.field_73735_i, mouseX, mouseY);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
        }
        if (this.pages.size() > ++index) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            IGuiRenderablePage page = this.pages.get(index);
            page.render(this.guiLeft + 220, this.guiTop + 20, partialTicks, this.field_73735_i, mouseX, mouseY);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
        }
        this.drawBackArrow(partialTicks);
        this.drawNavArrows(partialTicks);
        TextureHelper.refreshTextureBindState();
        index = this.currentPageOffset * 2;
        if (this.pages.size() > index) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            IGuiRenderablePage page = this.pages.get(index);
            page.postRender(this.guiLeft + 30, this.guiTop + pageOffsetY, partialTicks, this.field_73735_i, mouseX, mouseY);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
        }
        if (this.pages.size() > ++index) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            IGuiRenderablePage page = this.pages.get(index);
            page.postRender(this.guiLeft + 220, this.guiTop + 20, partialTicks, this.field_73735_i, mouseX, mouseY);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
        }
        this.field_73735_i -= 100.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawBackArrow(float partialTicks) {
        GL11.glDisable((int)2929);
        Point mouse = this.getCurrentMousePoint();
        int width = 30;
        int height = 15;
        this.rectBack = new Rectangle(this.guiLeft + 197, this.guiTop + 230, width, height);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.rectBack.getX() + (double)(width / 2)), (double)(this.rectBack.getY() + (double)(height / 2)), (double)0.0);
        float uFrom = 0.0f;
        float vFrom = 0.5f;
        if (this.rectBack.contains(mouse)) {
            uFrom = 0.5f;
            GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
        } else {
            double t = (float)ClientScheduler.getClientTick() + partialTicks;
            float sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
            GL11.glScaled((double)sin, (double)sin, (double)sin);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GL11.glTranslated((double)(-(width / 2)), (double)(-(height / 2)), (double)0.0);
        texArrow.bind();
        this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
    }

    private void drawNavArrows(float partialTicks) {
        GL11.glDisable((int)2929);
        Point mouse = this.getCurrentMousePoint();
        int cIndex = this.currentPageOffset * 2;
        this.rectNext = null;
        this.rectPrev = null;
        if (cIndex > 0) {
            int width = 30;
            int height = 15;
            this.rectPrev = new Rectangle(this.guiLeft + 25, this.guiTop + 220, width, height);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.rectPrev.getX() + (double)(width / 2)), (double)(this.rectPrev.getY() + (double)(height / 2)), (double)0.0);
            float uFrom = 0.0f;
            float vFrom = 0.5f;
            if (this.rectPrev.contains(mouse)) {
                uFrom = 0.5f;
                GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
            } else {
                double t = (float)ClientScheduler.getClientTick() + partialTicks;
                float sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                GL11.glScaled((double)sin, (double)sin, (double)sin);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            GL11.glTranslated((double)(-(width / 2)), (double)(-(height / 2)), (double)0.0);
            texArrow.bind();
            this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
            GL11.glPopMatrix();
        }
        int nextIndex = cIndex + 2;
        if (this.pages.size() >= nextIndex + 1) {
            int width = 30;
            int height = 15;
            this.rectNext = new Rectangle(this.guiLeft + 367, this.guiTop + 220, width, height);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.rectNext.getX() + (double)(width / 2)), (double)(this.rectNext.getY() + (double)(height / 2)), (double)0.0);
            float uFrom = 0.0f;
            float vFrom = 0.0f;
            if (this.rectNext.contains(mouse)) {
                uFrom = 0.5f;
                GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
            } else {
                double t = (float)ClientScheduler.getClientTick() + partialTicks;
                float sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                GL11.glScaled((double)sin, (double)sin, (double)sin);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            GL11.glTranslated((double)(-(width / 2)), (double)(-(height / 2)), (double)0.0);
            texArrow.bind();
            this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2929);
    }

    @Override
    protected boolean handleRightClickClose(int mouseX, int mouseY) {
        if (this.origin != null) {
            this.origin.expectReinit = true;
            saveSite = false;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.origin);
        } else {
            this.informPreviousClose = false;
            Minecraft.func_71410_x().func_147108_a(this.previous);
        }
        return true;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        IGuiRenderablePage page;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        Point p = new Point(mouseX, mouseY);
        if (this.origin != null) {
            if (this.rectResearchBookmark != null && this.rectResearchBookmark.contains(p)) {
                saveSite = false;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)this.origin);
                return;
            }
            if (this.rectConstellationBookmark != null && this.rectConstellationBookmark.contains(p)) {
                saveSite = false;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalConstellationCluster.getConstellationScreen());
                return;
            }
            if (this.rectPerkMapBookmark != null && this.rectPerkMapBookmark.contains(p)) {
                saveSite = false;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalPerkMap());
                return;
            }
        }
        if (this.rectBack != null && this.rectBack.contains(p)) {
            if (this.origin != null) {
                this.origin.expectReinit = true;
                saveSite = false;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)this.origin);
                return;
            }
            this.informPreviousClose = false;
            Minecraft.func_71410_x().func_147108_a(this.previous);
            return;
        }
        if (this.rectPrev != null && this.rectPrev.contains(p)) {
            --this.currentPageOffset;
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            return;
        }
        if (this.rectNext != null && this.rectNext.contains(p)) {
            ++this.currentPageOffset;
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            return;
        }
        int index = this.currentPageOffset * 2;
        if (this.pages.size() > index && (page = this.pages.get(index)) != null && page.propagateMouseClick(mouseX, mouseY)) {
            return;
        }
        if (this.pages.size() > ++index && (page = this.pages.get(index)) != null) {
            page.propagateMouseClick(mouseX, mouseY);
        }
    }

    static {
        saveSite = true;
        texArrow = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijarrow");
        texUnderline = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MISC, "underline");
    }
}

