/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import hellfirepvp.astralsorcery.client.util.AirBlockRenderWorld;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.tile.TileTranslucent;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class TESRTranslucentBlock
extends TileEntitySpecialRenderer<TileTranslucent> {
    protected static final List<TranslucentBlockState> blocks = new LinkedList<TranslucentBlockState>();
    private static int hash = -1;
    private static int batchDList = -1;

    public static void renderTranslucentBlocks() {
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        RenderingUtils.removeStandartTranslationFromTESRMatrix(Minecraft.func_71410_x().func_184121_ak());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (batchDList == -1) {
            TESRTranslucentBlock.batchBlocks();
            hash = TESRTranslucentBlock.hashBlocks();
            blocks.clear();
        } else {
            int currentHash = TESRTranslucentBlock.hashBlocks();
            if (hash != currentHash) {
                GLAllocation.func_74523_b((int)batchDList);
                TESRTranslucentBlock.batchBlocks();
                hash = currentHash;
                blocks.clear();
            }
        }
        GL11.glEnable((int)3042);
        Blending.CONSTANT_ALPHA.apply();
        GL11.glCallList((int)batchDList);
        blocks.clear();
        Blending.DEFAULT.apply();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private static void batchBlocks() {
        AirBlockRenderWorld iba = new AirBlockRenderWorld(Biomes.field_76772_c, Minecraft.func_71410_x().field_71441_e.func_175624_G());
        batchDList = GLAllocation.func_74526_a((int)1);
        GL11.glEnable((int)3042);
        Blending.CONSTANT_ALPHA.apply();
        GL11.glNewList((int)batchDList, (int)4864);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (TranslucentBlockState tbs : blocks) {
            Minecraft.func_71410_x().func_175602_ab().func_175018_a(tbs.state, tbs.pos, (IBlockAccess)iba, vb);
        }
        tes.func_78381_a();
        GL11.glEndList();
        Blending.DEFAULT.apply();
    }

    private static int hashBlocks() {
        int hash = 80238287;
        for (TranslucentBlockState tbs : blocks) {
            hash = hash << 4 ^ hash >> 28 ^ tbs.pos.func_177958_n() * 5449 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.pos.func_177956_o() * 5449 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.pos.func_177952_p() * 5449 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.state.hashCode() * 5449 % 130651;
        }
        return hash % 75327403;
    }

    public static void cleanUp() {
        hash = -1;
        if (batchDList != -1) {
            GLAllocation.func_74523_b((int)batchDList);
            batchDList = -1;
        }
    }

    public void render(TileTranslucent te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getFakedState() == null) {
            return;
        }
        IBlockState renderState = te.getFakedState();
        TESRTranslucentBlock.addForRender(renderState, te.func_174877_v());
    }

    public static void addForRender(IBlockState state, BlockPos pos) {
        blocks.add(new TranslucentBlockState(state, pos));
    }

    public static class TranslucentBlockState {
        public final IBlockState state;
        public final BlockPos pos;

        public TranslucentBlockState(IBlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

