/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.camera;

import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Collections;
import java.util.EnumSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientCameraManager
implements ITickHandler {
    private static final ClientCameraManager instance = new ClientCameraManager();
    private TreeSet<ICameraTransformer> transformers = new TreeSet((t1, t2) -> t1.getPriority() - t2.getPriority());
    private ICameraTransformer lastTransformer = null;

    private ClientCameraManager() {
    }

    public static ClientCameraManager getInstance() {
        return instance;
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        if (type == TickEvent.Type.RENDER) {
            float pTicks = ((Float)context[0]).floatValue();
            if (!this.transformers.isEmpty()) {
                ICameraTransformer prio = this.transformers.last();
                if (prio != this.lastTransformer) {
                    if (this.lastTransformer != null) {
                        this.lastTransformer.onStopTransforming(pTicks);
                    }
                    prio.onStartTransforming(pTicks);
                    this.lastTransformer = prio;
                }
                prio.transformRenderView(pTicks);
                if (prio.needsRemoval()) {
                    prio.onStopTransforming(pTicks);
                    this.transformers.remove(prio);
                }
            } else if (this.lastTransformer != null) {
                this.lastTransformer.onStopTransforming(pTicks);
                this.lastTransformer = null;
            }
        } else if (!this.transformers.isEmpty()) {
            ICameraTransformer prio = this.transformers.last();
            prio.onClientTick();
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.RENDER, TickEvent.Type.CLIENT);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.START;
    }

    @Override
    public String getName() {
        return "Client Camera Manager";
    }

    public void removeAllAndCleanup() {
        if (!this.transformers.isEmpty()) {
            ICameraTransformer last = this.transformers.last();
            last.onStopTransforming(0.0f);
        }
        this.transformers.clear();
    }

    public void addTransformer(ICameraTransformer transformer) {
        this.transformers.add(transformer);
    }

    public boolean hasActiveTransformer() {
        return !this.transformers.isEmpty();
    }

    public static class EntityClientReplacement
    extends AbstractClientPlayer {
        public EntityClientReplacement() {
            super((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_146103_bH());
        }
    }

    public static abstract class EntityRenderViewReplacement
    extends EntityPlayerSP {
        private Vector3 cameraFocus = null;

        public EntityRenderViewReplacement() {
            super(Minecraft.func_71410_x(), (World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.field_71174_a, Minecraft.func_71410_x().field_71439_g.func_146107_m(), Minecraft.func_71410_x().field_71439_g.func_192035_E());
            this.field_71075_bZ.field_75101_c = true;
            this.field_71075_bZ.field_75100_b = true;
        }

        @Nullable
        public Vector3 getCameraFocus() {
            return this.cameraFocus;
        }

        public void setCameraFocus(@Nullable Vector3 cameraFocus) {
            this.cameraFocus = cameraFocus;
        }

        public void setAsRenderViewEntity() {
            Minecraft.func_71410_x().func_175607_a((Entity)this);
        }

        public void transformToFocusOnPoint(Vector3 toFocus, float pTicks, boolean propagate) {
            Vector3 angles = new Vector3(this.field_70165_t, this.field_70163_u, this.field_70161_v).subtract(toFocus).copyToPolar();
            Vector3 prevAngles = new Vector3(this.field_70169_q, this.field_70167_r, this.field_70166_s).subtract(toFocus).copyToPolar();
            double pitch = 90.0 - angles.getY();
            double pitchPrev = 90.0 - prevAngles.getY();
            double yaw = -angles.getZ();
            double yawPrev = -prevAngles.getZ();
            if (propagate) {
                RenderingUtils.unsafe_preRenderHackCamera((EntityPlayer)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70169_q, this.field_70167_r, this.field_70166_s, yaw, yawPrev, pitch, pitchPrev);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70082_c(float yaw, float pitch) {
        }

        public abstract void moveEntityTick(EntityRenderViewReplacement var1, EntityClientReplacement var2, int var3);

        public abstract void onStopTransforming();

        public boolean func_175149_v() {
            return false;
        }

        public boolean func_184812_l_() {
            return false;
        }

        public Iterable<ItemStack> func_184193_aE() {
            return Collections.emptyList();
        }

        @Nonnull
        public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
            return ItemStack.field_190927_a;
        }

        public void func_184201_a(EntityEquipmentSlot slotIn, @Nullable ItemStack stack) {
        }

        public EnumHandSide func_184591_cq() {
            return EnumHandSide.RIGHT;
        }
    }

    public static interface PersistencyFunction {
        public boolean needsRemoval();
    }

    public static class CameraTransformerRenderReplacement
    extends CameraTransformerSettingsCache {
        private final EntityRenderViewReplacement entity;
        private final PersistencyFunction func;
        private EntityClientReplacement clientEntity;

        public CameraTransformerRenderReplacement(EntityRenderViewReplacement renderView, PersistencyFunction func) {
            this.entity = renderView;
            this.func = func;
        }

        @Override
        public void onStartTransforming(float pTicks) {
            super.onStartTransforming(pTicks);
            EntityClientReplacement repl = new EntityClientReplacement();
            repl.func_70020_e(Minecraft.func_71410_x().field_71439_g.func_189511_e(new NBTTagCompound()));
            Minecraft.func_71410_x().field_71441_e.func_72838_d((Entity)repl);
            this.clientEntity = repl;
            this.entity.setAsRenderViewEntity();
        }

        @Override
        public void onStopTransforming(float pTicks) {
            super.onStopTransforming(pTicks);
            if (Minecraft.func_71410_x().field_71441_e != null) {
                Minecraft.func_71410_x().field_71441_e.func_72900_e((Entity)this.clientEntity);
            }
            if (Minecraft.func_71410_x().field_71439_g != null) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                player.func_70080_a(this.clientEntity.field_70165_t, this.clientEntity.field_70163_u, this.clientEntity.field_70161_v, this.clientEntity.field_70177_z, this.clientEntity.field_70125_A);
                player.func_70016_h(0.0, 0.0, 0.0);
            }
            RenderingUtils.unsafe_resetCamera();
            if (Minecraft.func_71410_x().field_71441_e != null) {
                this.entity.onStopTransforming();
            }
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public void transformRenderView(float pTicks) {
            super.transformRenderView(pTicks);
            Vector3 focus = this.entity.getCameraFocus();
            if (focus != null) {
                this.entity.transformToFocusOnPoint(focus, pTicks, true);
            }
        }

        @Override
        public boolean needsRemoval() {
            return this.func.needsRemoval();
        }

        @Override
        public void onClientTick() {
            ++this.entity.field_70173_aa;
            if (this.clientEntity != null) {
                this.entity.moveEntityTick(this.entity, this.clientEntity, this.entity.field_70173_aa);
            }
        }
    }

    public static abstract class CameraTransformerSettingsCache
    implements ICameraTransformer {
        private boolean active = false;
        private boolean viewBobbing = false;
        private boolean hideGui = false;
        private boolean flying = false;
        private int thirdPersonView = 0;
        private Vector3 startPosition;
        private float startYaw;
        private float startPitch;

        @Override
        public void onStartTransforming(float pTicks) {
            this.viewBobbing = Minecraft.func_71410_x().field_71474_y.field_74336_f;
            this.hideGui = Minecraft.func_71410_x().field_71474_y.field_74319_N;
            this.thirdPersonView = Minecraft.func_71410_x().field_71474_y.field_74320_O;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            this.flying = player.field_71075_bZ.field_75100_b;
            this.startPosition = new Vector3(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            this.startYaw = player.field_70177_z;
            this.startPitch = player.field_70125_A;
            player.func_70016_h(0.0, 0.0, 0.0);
            this.active = true;
        }

        @Override
        public void onStopTransforming(float pTicks) {
            if (this.active) {
                GameSettings settings = Minecraft.func_71410_x().field_71474_y;
                settings.field_74336_f = this.viewBobbing;
                settings.field_74319_N = this.hideGui;
                settings.field_74320_O = this.thirdPersonView;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                player.field_71075_bZ.field_75100_b = this.flying;
                player.func_70080_a(this.startPosition.getX(), this.startPosition.getY(), this.startPosition.getZ(), this.startYaw, this.startPitch);
                player.func_70016_h(0.0, 0.0, 0.0);
                this.active = false;
            }
        }

        @Override
        public void transformRenderView(float pTicks) {
            if (!this.active) {
                return;
            }
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            settings.field_74319_N = true;
            settings.field_74336_f = false;
            settings.field_74320_O = 0;
            Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75100_b = true;
            Minecraft.func_71410_x().field_71439_g.func_70016_h(0.0, 0.0, 0.0);
        }
    }

    public static interface ICameraTransformer {
        public int getPriority();

        public boolean needsRemoval();

        public void onClientTick();

        public void onStartTransforming(float var1);

        public void onStopTransforming(float var1);

        public void transformRenderView(float var1);
    }
}

