/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;

public class SwordSharpenHelper {
    public static List<Class<?>> otherSharpenableSwordSuperClasses = new LinkedList();
    public static List<String> blacklistedSharpenableSwordClassNames = new LinkedList<String>();

    public static boolean isSwordSharpened(@Nonnull ItemStack stack) {
        if (!SwordSharpenHelper.isSharpenableItem(stack)) {
            return false;
        }
        return NBTHelper.getData(stack).func_74767_n("sharp");
    }

    public static void setSwordSharpened(@Nonnull ItemStack stack) {
        if (!SwordSharpenHelper.isSharpenableItem(stack)) {
            return;
        }
        NBTHelper.getData(stack).func_74757_a("sharp", true);
    }

    public static boolean canBeSharpened(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item i = stack.func_77973_b();
        if (blacklistedSharpenableSwordClassNames.contains(i.getClass().getName())) {
            return false;
        }
        if (SwordSharpenHelper.isSharpenableItem(stack)) {
            return true;
        }
        Class<?> itemClass = stack.func_77973_b().getClass();
        for (Class<?> clazz : otherSharpenableSwordSuperClasses) {
            if (!clazz.isAssignableFrom(itemClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSharpenableItem(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemAxe);
    }
}

