/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.World;

public class WorldChaliceCache {
    private static Map<Integer, List<TileChalice>> chaliceCache = new HashMap<Integer, List<TileChalice>>();

    private WorldChaliceCache() {
    }

    public static void wipeCache() {
        chaliceCache.clear();
    }

    public static void register(TileChalice chalice) {
        chaliceCache.computeIfAbsent(chalice.func_145831_w().field_73011_w.getDimension(), i -> Lists.newArrayList()).add(chalice);
    }

    public static void remove(TileChalice chalice) {
        List<TileChalice> ch = chaliceCache.get(chalice.func_145831_w().field_73011_w.getDimension());
        if (ch != null) {
            ch.remove(chalice);
        }
    }

    @Nonnull
    public static List<TileChalice> getChalices(World world) {
        List<TileChalice> ch = chaliceCache.get(world.field_73011_w.getDimension());
        return ch == null ? Lists.newArrayList() : ch;
    }
}

