/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import java.time.LocalDateTime;
import java.time.Month;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface BlockDynamicStateMapper {
    default public boolean handleRegisterStateMapper() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    default public void registerStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this.getBlock(), this::getModelLocations);
    }

    default public Block getBlock() {
        return (Block)this;
    }

    public Map<IBlockState, ModelResourceLocation> getModelLocations(Block var1);

    default public String getPropertyString(Map<IProperty<?>, Comparable<?>> values) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(this.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    default public <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    public static interface Festive
    extends BlockDynamicStateMapper {
        @Override
        default public boolean handleRegisterStateMapper() {
            LocalDateTime now = LocalDateTime.now();
            return now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 21 && now.getDayOfMonth() <= 31;
        }
    }
}

