/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapeEffectArmara
extends CapeArmorEffect {
    private static int immunityRechargeTicks = 80;
    private static int immunityStacks = 3;

    public CapeEffectArmara(NBTTagCompound cmp) {
        super(cmp, "armara");
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.armara;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playActiveParticleTick(EntityPlayer pl) {
        this.playConstellationCapeSparkles(pl, 0.2f);
        Vector3 offset = Vector3.atEntityCorner((Entity)pl);
        offset.addY(pl.field_70131_O / 2.0f);
        Color c = new Color(7368447);
        int stacks = this.getCurrentImmunityStacks();
        if (stacks > 0) {
            Random r = new Random(pl.func_110124_au().hashCode());
            for (int i = 0; i < stacks; ++i) {
                Vector3 axis = Vector3.random(r);
                axis.setX(axis.getX() * (double)0.35f);
                axis.setZ(axis.getZ() * (double)0.35f);
                Vector3 perpEffect = axis.clone().perpendicular();
                int ticksPerCircle = 80 + r.nextInt(50);
                int tick = pl.field_70173_aa % ticksPerCircle;
                Vector3 pos = perpEffect.normalize().multiply(r.nextFloat() * 0.4f + 0.9f).rotate(Math.toRadians(360.0f * ((float)tick / (float)ticksPerCircle)), axis).add(offset);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(pos);
                p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                float scale = rand.nextFloat() * 0.2f + 0.2f;
                p.scale(scale);
                p.gravity(0.004);
                p.setMaxAge(20 + rand.nextInt(20));
                p = EffectHelper.genericFlareParticle(pos);
                p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                p.scale(scale * 0.45f);
                p.gravity(0.004);
                p.setMaxAge(10 + rand.nextInt(10));
            }
        }
    }

    private int getCurrentImmunityRechargeTick() {
        return this.getData().func_74762_e("AS_Armara_ImmunityTick");
    }

    private void setCurrentImmunityRechargeTick(int tick) {
        this.getData().func_74768_a("AS_Armara_ImmunityTick", tick);
    }

    private int getCurrentImmunityStacks() {
        return this.getData().func_74762_e("AS_Armara_ImmunityStacks");
    }

    private void setCurrentImmunityStacks(int stacks) {
        this.getData().func_74768_a("AS_Armara_ImmunityStacks", stacks);
    }

    public boolean shouldPreventDamage(DamageSource source, boolean simulate) {
        if (source.func_76357_e()) {
            return false;
        }
        int stacks = this.getCurrentImmunityStacks();
        if (stacks <= 0) {
            return false;
        }
        if (!simulate) {
            this.setCurrentImmunityStacks(--stacks);
        }
        return true;
    }

    public void wornTick() {
        if (this.getCurrentImmunityStacks() >= immunityStacks) {
            this.setCurrentImmunityRechargeTick(immunityRechargeTicks);
            return;
        }
        int tick = this.getCurrentImmunityRechargeTick();
        if (--tick <= 0) {
            this.setCurrentImmunityRechargeTick(immunityRechargeTicks);
            this.setCurrentImmunityStacks(this.getCurrentImmunityStacks() + 1);
        } else {
            this.setCurrentImmunityRechargeTick(tick);
        }
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        immunityRechargeTicks = cfg.getInt(this.getKey() + "RechargeTicks", this.getConfigurationSection(), immunityRechargeTicks, 1, 10000, "Defines the ticks you need to wear the cape until you get a immunty-stack that prevents 1 attack/damage-hit you'd take.");
        immunityStacks = cfg.getInt(this.getKey() + "ImmunityStacks", this.getConfigurationSection(), immunityStacks, 1, 30, "Defines the maximum amount of immunity-stacks you can overall charge up.");
    }
}

