/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingDepthParticle;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapeEffectLucerna
extends CapeArmorEffect {
    private static boolean findSpawners = true;
    private static float range = 36.0f;

    public CapeEffectLucerna(NBTTagCompound cmp) {
        super(cmp, "lucerna");
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.lucerna;
    }

    @SideOnly(value=Side.CLIENT)
    public void playClientHighlightTick(EntityPlayer player) {
        World w = player.func_130014_f_();
        List entities = w.func_175644_a(EntityLivingBase.class, EntitySelectors.func_188443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)range));
        for (EntityLivingBase entity : entities) {
            Vector3 at;
            if (entity == null || entity.field_70128_L || entity.equals((Object)player) || (double)rand.nextFloat() > 0.4 || (at = Vector3.atEntityCorner((Entity)entity)).distance((Vec3i)player.func_180425_c()) < 6.0) continue;
            at.add(entity.field_70130_N * rand.nextFloat(), entity.field_70131_O * rand.nextFloat(), entity.field_70130_N * rand.nextFloat());
            EntityFXFacingDepthParticle p = EffectHelper.genericDepthIgnoringFlareParticle(at.getX(), at.getY(), at.getZ());
            p.setColor(Constellations.lucerna.getConstellationColor()).setAlphaMultiplier(1.0f).scale(0.6f * rand.nextFloat() + 0.6f).gravity(0.004).setMaxAge(30 + rand.nextInt(20));
            if (rand.nextInt(3) == 0) {
                p.setColor(IConstellation.weak);
            }
            if (!(rand.nextFloat() < 0.8f)) continue;
            p = EffectHelper.genericDepthIgnoringFlareParticle(at.getX(), at.getY(), at.getZ());
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(rand.nextFloat() * 0.3f + 0.3f).gravity(0.004);
            p.setMaxAge(20 + rand.nextInt(10));
        }
        ArrayList list = Lists.newArrayList();
        int minX = MathHelper.func_76128_c((double)((player.field_70165_t - (double)range) / 16.0));
        int maxX = MathHelper.func_76128_c((double)((player.field_70165_t + (double)range) / 16.0));
        int minZ = MathHelper.func_76128_c((double)((player.field_70161_v - (double)range) / 16.0));
        int maxZ = MathHelper.func_76128_c((double)((player.field_70161_v + (double)range) / 16.0));
        for (int xx = minX; xx <= maxX; ++xx) {
            for (int zz = minZ; zz <= maxZ; ++zz) {
                Chunk ch = w.func_72964_e(xx, zz);
                if (ch.func_76621_g()) continue;
                Map map = ch.func_177434_r();
                for (Map.Entry teEntry : map.entrySet()) {
                    TileEntity te = (TileEntity)teEntry.getValue();
                    if (te == null || !(te instanceof TileEntityMobSpawner) || (double)rand.nextFloat() > 0.4) continue;
                    list.add((TileEntityMobSpawner)te);
                }
            }
        }
        for (TileEntityMobSpawner spawner : list) {
            Vector3 at = new Vector3(spawner.func_174877_v());
            at.add(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
            EntityFXFacingDepthParticle p = EffectHelper.genericDepthIgnoringFlareParticle(at.getX(), at.getY(), at.getZ());
            p.setColor(new Color(10223872)).setAlphaMultiplier(1.0f).scale(0.6f * rand.nextFloat() + 0.6f).gravity(0.004).setMaxAge(30 + rand.nextInt(20));
            if (rand.nextInt(3) == 0) {
                p.setColor(IConstellation.weak);
            }
            if (!(rand.nextFloat() < 0.8f)) continue;
            p = EffectHelper.genericDepthIgnoringFlareParticle(at.getX(), at.getY(), at.getZ());
            p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(rand.nextFloat() * 0.3f + 0.3f).gravity(0.004);
            p.setMaxAge(20 + rand.nextInt(10));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playActiveParticleTick(EntityPlayer pl) {
        this.playConstellationCapeSparkles(pl, 0.14f);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        findSpawners = cfg.getBoolean(this.getKey() + "FindSpawners", this.getConfigurationSection(), findSpawners, "If this is set to true, particles spawned by the lucerna cape effect will also highlight spawners nearby.");
        range = cfg.getFloat(this.getKey() + "Range", this.getConfigurationSection(), range, 12.0f, 512.0f, "Sets the maximum range of where the lucerna cape effect will get entities (and potentially spawners given the config option is enabled) to highlight.");
    }
}

