/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.block.EffectTranslucentFallingBlock;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapeEffectMineralis
extends CapeArmorEffect {
    private static int highlightRange = 8;

    public CapeEffectMineralis(NBTTagCompound cmp) {
        super(cmp, "mineralis");
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.mineralis;
    }

    @Override
    public void playActiveParticleTick(EntityPlayer pl) {
        this.playConstellationCapeSparkles(pl, 0.15f);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        highlightRange = cfg.getInt(this.getKey() + "HighlightRange", this.getConfigurationSection(), highlightRange, 4, 32, "Sets the highlight radius in which the cape effect will search for the block you're holding.");
    }

    @SideOnly(value=Side.CLIENT)
    public void playClientHighlightTick(EntityPlayer pl) {
        if (rand.nextFloat() > 0.2f) {
            return;
        }
        ItemStack main = pl.func_184614_ca();
        IBlockState check = null;
        if (!main.func_190926_b()) {
            try {
                check = ItemUtils.createBlockState(main);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (check == null) {
            main = pl.func_184592_cb();
            try {
                check = ItemUtils.createBlockState(main);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (check != null) {
            int index;
            int meta;
            Block b;
            try {
                b = check.func_177230_c();
                meta = b.func_176201_c(check);
            }
            catch (Exception e) {
                return;
            }
            List<BlockPos> blocks = MiscUtils.searchAreaFor(pl.field_70170_p, pl.func_180425_c(), b, meta, highlightRange);
            if (blocks.isEmpty()) {
                return;
            }
            int n = index = blocks.size() > 10 ? rand.nextInt(blocks.size()) : rand.nextInt(10);
            if (index >= blocks.size()) {
                return;
            }
            BlockPos at = blocks.get(index);
            IBlockState act = pl.field_70170_p.func_180495_p(at);
            EffectTranslucentFallingBlock bl = EffectHandler.getInstance().translucentFallingBlock(new Vector3(at).add(0.5, 0.5, 0.5), act);
            bl.setDisableDepth(true).setScaleFunction(new EntityComplexFX.ScaleFunction.Shrink<EffectTranslucentFallingBlock>());
            bl.setMotion(0.0, 0.02, 0.0).setAlphaFunction(EntityComplexFX.AlphaFunction.PYRAMID);
            bl.tumble();
            bl.setMaxAge(40 + rand.nextInt(15));
        }
    }
}

