/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionListGen;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.CropHelper;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectAevitas
extends CEffectPositionListGen<CropHelper.GrowablePlant> {
    public static boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static int searchRange = 16;
    public static int maxCropCount = 200;
    public static int potionAmplifier = 1;

    public CEffectAevitas(@Nullable ILocatable origin) {
        super(origin, Constellations.aevitas, "aevitas", searchRange, maxCropCount, (world, pos) -> CropHelper.wrapPlant(world, pos) != null, CropHelper.GrowableWrapper::new);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        if (rand.nextBoolean()) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)((float)pos.func_177958_n() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5, (double)((float)pos.func_177956_o() + rand.nextFloat() * 2.0f) + 0.5, (double)((float)pos.func_177952_p() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5);
            p.motion(0.0, 0.0, 0.0).gravity(0.05);
            p.scale(0.45f).setColor(new Color(63, 255, 63)).setMaxAge(35);
        }
    }

    @Override
    public boolean playMainEffect(World world, BlockPos pos, float percStrength, boolean mayDoTraitEffect, @Nullable IMinorConstellation possibleTraitEffect) {
        if (!enabled) {
            return false;
        }
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        boolean changed = false;
        CropHelper.GrowablePlant plant = (CropHelper.GrowablePlant)this.getRandomElementByChance(rand);
        if (plant != null && MiscUtils.isChunkLoaded(world, new ChunkPos(plant.getPos()))) {
            if (!plant.isValid(world, true)) {
                this.removeElement(plant);
                changed = true;
            } else if (plant.tryGrow(world, rand)) {
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)plant.getPos());
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)plant.getPos(), 8.0));
                changed = true;
            }
        }
        if (this.findNewPosition(world, pos)) {
            changed = true;
        }
        if (this.findNewPosition(world, pos)) {
            changed = true;
        }
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos).func_186662_g((double)searchRange));
        for (EntityLivingBase entity : entities) {
            if (entity.field_70128_L) continue;
            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, potionAmplifier));
        }
        return changed;
    }

    @Override
    public CropHelper.GrowablePlant newElement(World world, BlockPos at) {
        return CropHelper.wrapPlant(world, at);
    }

    @Override
    public boolean playTraitEffect(World world, BlockPos pos, IMinorConstellation traitType, float traitStrength) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playParticles(PktParticleEvent event) {
        Vector3 at = event.getVec();
        for (int i = 0; i < 8; ++i) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX() + (double)rand.nextFloat(), at.getY() + 0.2, at.getZ() + (double)rand.nextFloat());
            p.motion(0.0, 0.005 + (double)rand.nextFloat() * 0.01, 0.0);
            p.scale(0.2f).setColor(Color.GREEN);
        }
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        searchRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), 16, 1, 32, "Defines the radius (in blocks) in which the ritual will search for valid crops.");
        maxCropCount = cfg.getInt(this.getKey() + "Count", this.getConfigurationSection(), 200, 1, 4000, "Defines the amount of crops the ritual can cache at max. count");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        potionAmplifier = cfg.getInt(this.getKey() + "RegenerationAmplifier", this.getConfigurationSection(), 1, 0, Short.MAX_VALUE, "Set the amplifier for the regeneration potion effect.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

