/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionListGen;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.BlockBreakAssist;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectEvorsio
extends CEffectPositionListGen<BlockBreakAssist.BreakEntry> {
    private static BlockArray copyResizedPedestal = null;
    public static boolean enabled = true;
    public static float potencyMultiplier = 1.0f;
    public static int searchRange = 13;

    public CEffectEvorsio(@Nullable ILocatable origin) {
        super(origin, Constellations.evorsio, "evorsio", searchRange, 2, (w, pos) -> CEffectEvorsio.isAllowedToBreak(origin, w, pos), pos -> null);
    }

    private static boolean isAllowedToBreak(@Nullable ILocatable origin, World world, BlockPos pos) {
        if (!MiscUtils.isChunkLoaded(world, pos)) {
            return false;
        }
        float hardness = world.func_180495_p(pos).func_185887_b(world, pos);
        if (world.func_175623_d(pos) || hardness < 0.0f || hardness > 75.0f) {
            return false;
        }
        if (origin != null && MiscUtils.isChunkLoaded(world, origin.getPos())) {
            TileRitualPedestal pedestal = MiscUtils.getTileAt((IBlockAccess)world, origin.getPos(), TileRitualPedestal.class, true);
            if (pedestal != null) {
                if (copyResizedPedestal == null && MultiBlockArrays.patternRitualPedestal != null) {
                    copyResizedPedestal = new BlockArray();
                    int i = 0;
                    while (i < 5) {
                        int finalI = i++;
                        copyResizedPedestal.addAll(MultiBlockArrays.patternRitualPedestal, p -> p.func_177982_a(0, finalI, 0));
                    }
                }
                if (copyResizedPedestal != null && copyResizedPedestal.hasBlockAt(pos.func_177973_b((Vec3i)origin.getPos()))) {
                    return false;
                }
            } else {
                TileRitualLink link = MiscUtils.getTileAt((IBlockAccess)world, origin.getPos(), TileRitualLink.class, true);
                if (link != null) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public BlockBreakAssist.BreakEntry newElement(World world, BlockPos at) {
        return new BlockBreakAssist.BreakEntry(Float.valueOf(0.0f), world, at, world.func_180495_p(at));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        if (rand.nextInt(4) == 0) {
            Vector3 at = new Vector3((double)((float)pos.func_177958_n() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5, (double)((float)pos.func_177956_o() + rand.nextFloat() * 2.0f) + 0.5, (double)((float)pos.func_177952_p() + rand.nextFloat() * 5.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5);
            block4: for (int i = 0; i < 15; ++i) {
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.gravity(0.004);
                p.scale(0.25f).setMaxAge(35 + rand.nextInt(10));
                Vector3 mot = new Vector3();
                MiscUtils.applyRandomOffset(mot, rand, 0.01f * rand.nextFloat() + 0.01f);
                p.motion(mot.getX(), mot.getY(), mot.getZ());
                switch (rand.nextInt(3)) {
                    case 0: 
                    case 1: {
                        p.setColor(Constellations.evorsio.getConstellationColor());
                        continue block4;
                    }
                    case 2: {
                        p.setColor(Constellations.armara.getConstellationColor());
                    }
                }
            }
        }
    }

    @Override
    public boolean playMainEffect(World world, BlockPos pos, float percStrength, boolean mayDoTraitEffect, @Nullable IMinorConstellation possibleTraitEffect) {
        BlockBreakAssist.BreakEntry be;
        if (!enabled) {
            return false;
        }
        if ((percStrength *= potencyMultiplier) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        if (world instanceof WorldServer && this.findNewPosition(world, pos) && (be = (BlockBreakAssist.BreakEntry)this.getRandomElement(world.field_73012_v)) != null) {
            this.removeElement(be);
            BlockDropCaptureAssist.startCapturing();
            MiscUtils.breakBlockWithoutPlayer((WorldServer)world, be.getPos(), world.func_180495_p(be.getPos()), true, true, true);
            NonNullList<ItemStack> captured = BlockDropCaptureAssist.getCapturedStacksAndStop();
            captured.forEach(stack -> ItemUtils.dropItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, stack));
            PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_BREAK_BLOCK, (Vec3i)be.getPos());
            PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)be.getPos(), 16.0));
        }
        return false;
    }

    @Override
    public boolean playTraitEffect(World world, BlockPos pos, IMinorConstellation traitType, float traitStrength) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playBreakEffects(PktParticleEvent pktParticleEvent) {
        Vector3 at = pktParticleEvent.getVec().add(0.5, 0.5, 0.5);
        block5: for (int i = 0; i < 15; ++i) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
            p.gravity(0.004);
            p.scale(0.25f).setMaxAge(35 + rand.nextInt(10));
            Vector3 mot = new Vector3();
            MiscUtils.applyRandomOffset(mot, rand, 0.01f * rand.nextFloat() + 0.01f);
            p.motion(mot.getX(), mot.getY(), mot.getZ());
            switch (rand.nextInt(3)) {
                case 0: {
                    p.setColor(Color.WHITE);
                    continue block5;
                }
                case 1: {
                    p.setColor(Constellations.evorsio.getConstellationColor());
                    continue block5;
                }
                case 2: {
                    p.setColor(Constellations.armara.getConstellationColor());
                }
            }
        }
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        searchRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), searchRange, 1, 32, "Defines the radius (in blocks) in which the ritual will search for blocks to break.");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), enabled, "Set to false to disable this ConstellationEffect.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), potencyMultiplier, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

