/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;

public class PerkDamageKnockedback
extends ConstellationPerk {
    private static float dmgMultiplier = 2.0f;
    private static int ticksDuration = 60;

    public PerkDamageKnockedback() {
        super("DMG_KNOCK", ConstellationPerk.Target.ENTITY_KNOCKBACK, ConstellationPerk.Target.ENTITY_ATTACK);
    }

    @Override
    public float onEntityAttack(EntityPlayer attacker, EntityLivingBase attacked, float dmgIn) {
        if (this.isCooldownActiveForPlayer(attacker)) {
            this.addAlignmentCharge(attacker, 0.4 * (double)Math.max(0.0f, dmgIn));
            dmgIn *= dmgMultiplier;
        }
        return dmgIn;
    }

    @Override
    public void onEntityKnockback(EntityPlayer attacker, EntityLivingBase attacked) {
        this.setCooldownActiveForPlayer(attacker, ticksDuration);
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        dmgMultiplier = cfg.getFloat(this.getKey() + "DamageIncrease", this.getConfigurationSection(), dmgMultiplier, 1.0f, 2.0f, "Sets the damage multiplier that is applied to entity damaged after knocked back if the player has this perk.");
        ticksDuration = cfg.getInt(this.getKey() + "KnockbackDuration", this.getConfigurationSection(), ticksDuration, 1, 1000, "Sets the duration on how long the player gets additional damage on the mob when it was knocked back.");
    }
}

