/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.crafting.IGatedRecipe;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.RecipeAdapter;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractAltarRecipe {
    private AbstractAltarRecipe specialEffectRecovery = null;
    private int experiencePerCraft = 5;
    private int passiveStarlightRequirement;
    private final TileAltar.AltarLevel neededLevel;
    private final AccessibleRecipe recipe;
    private ItemStack out = ItemStack.field_190927_a;
    private int uniqueRecipeId = -1;

    public AbstractAltarRecipe(TileAltar.AltarLevel neededLevel, AccessibleRecipe recipe) {
        this.neededLevel = neededLevel;
        this.recipe = recipe;
        this.out = recipe.func_77571_b();
    }

    public final void updateUniqueId(int id) {
        this.uniqueRecipeId = id;
    }

    public final int getUniqueRecipeId() {
        return this.uniqueRecipeId;
    }

    public final void setSpecialEffectRecovery(AbstractAltarRecipe specialEffectRecovery) {
        this.specialEffectRecovery = specialEffectRecovery;
    }

    @Nonnull
    public ItemStack getOutputForRender() {
        return ItemUtils.copyStackWithSize(this.out, this.out.func_190916_E());
    }

    public AccessibleRecipe getNativeRecipe() {
        return this.recipe;
    }

    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        return ItemUtils.copyStackWithSize(this.out, this.out.func_190916_E());
    }

    @Nonnull
    public ItemStack getOutputForMatching() {
        return ItemUtils.copyStackWithSize(this.out, this.out.func_190916_E());
    }

    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        if (!ignoreStarlightRequirement && !this.fulfillesStarlightRequirement(altar)) {
            return false;
        }
        if (this instanceof IGatedRecipe && altar.func_145831_w().field_72995_K && !((IGatedRecipe)((Object)this)).hasProgressionClient()) {
            return false;
        }
        if (this instanceof INighttimeRecipe && !ConstellationSkyHandler.getInstance().isNight(altar.func_145831_w())) {
            return false;
        }
        ItemStack[] altarInv = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            altarInv[i] = invHandler.getStackInSlot(i);
        }
        RecipeAdapter adapter = new RecipeAdapter(altar.getCraftingRecipeWidth(), altar.getCraftingRecipeHeight());
        adapter.fill(altarInv);
        return this.recipe.func_77569_a(adapter, altar.func_145831_w());
    }

    public boolean fulfillesStarlightRequirement(TileAltar altar) {
        return altar.getStarlightStored() >= this.getPassiveStarlightRequired();
    }

    public AbstractAltarRecipe setPassiveStarlightRequirement(int starlightRequirement) {
        this.passiveStarlightRequirement = starlightRequirement;
        return this;
    }

    public int getPassiveStarlightRequired() {
        return this.passiveStarlightRequirement;
    }

    public AbstractAltarRecipe setCraftExperience(int exp) {
        this.experiencePerCraft = exp;
        return this;
    }

    public boolean allowsForChaining() {
        return true;
    }

    public int getCraftExperience() {
        return this.experiencePerCraft;
    }

    public float getCraftExperienceMultiplier() {
        return 1.0f;
    }

    public TileAltar.AltarLevel getNeededLevel() {
        return this.neededLevel;
    }

    public int craftingTickTime() {
        return 100;
    }

    public boolean mayDecrement(TileAltar ta, ShapedRecipeSlot slot) {
        ItemHandle handle = this.recipe.getExpectedStackHandle(slot);
        if (handle == null || handle.getFluidTypeAndAmount() == null) {
            return true;
        }
        ItemStack current = ta.getInventoryHandler().getStackInSlot(slot.getSlotID());
        return current.func_190926_b() || ForgeHooks.getContainerItem((ItemStack)current).func_190926_b();
    }

    public boolean mayDecrement(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
        if (!(this instanceof AttunementRecipe)) {
            return true;
        }
        AttunementRecipe thisRecipe = (AttunementRecipe)this;
        ItemHandle handle = thisRecipe.getAttItemHandle(slot);
        if (handle == null || handle.getFluidTypeAndAmount() == null) {
            return true;
        }
        ItemStack current = ta.getInventoryHandler().getStackInSlot(slot.getSlotId());
        return current.func_190926_b() || ForgeHooks.getContainerItem((ItemStack)current).func_190926_b();
    }

    public boolean mayDecrement(TileAltar ta, ConstellationRecipe.ConstellationAtlarSlot slot) {
        if (!(this instanceof ConstellationRecipe)) {
            return true;
        }
        ConstellationRecipe thisRecipe = (ConstellationRecipe)this;
        ItemHandle handle = thisRecipe.getCstItemHandle(slot);
        if (handle == null || handle.getFluidTypeAndAmount() == null) {
            return true;
        }
        ItemStack current = ta.getInventoryHandler().getStackInSlot(slot.getSlotId());
        return current.func_190926_b() || ForgeHooks.getContainerItem((ItemStack)current).func_190926_b();
    }

    public boolean mayDecrement(TileAltar ta, TraitRecipe.TraitRecipeSlot slot) {
        if (!(this instanceof TraitRecipe)) {
            return true;
        }
        TraitRecipe thisRecipe = (TraitRecipe)this;
        ItemHandle handle = thisRecipe.getInnerTraitItemHandle(slot);
        if (handle == null || handle.getFluidTypeAndAmount() == null) {
            return true;
        }
        ItemStack current = ta.getInventoryHandler().getStackInSlot(slot.getSlotId());
        return current.func_190926_b() || ForgeHooks.getContainerItem((ItemStack)current).func_190926_b();
    }

    public void handleItemConsumption(TileAltar ta, ShapedRecipeSlot slot) {
        ItemHandle handle = this.recipe.getExpectedStackHandle(slot);
        if (handle == null) {
            return;
        }
        TileReceiverBaseInventory.ItemHandlerTile inventory = ta.getInventoryHandler();
        ItemStack stack = inventory.getStackInSlot(slot.getSlotID());
        if (!stack.func_190926_b()) {
            FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
            if (fs != null) {
                FluidActionResult fas = ItemUtils.drainFluidFromItem(stack, handle.getFluidTypeAndAmount(), true);
                if (fas.isSuccess()) {
                    inventory.setStackInSlot(slot.getSlotID(), fas.getResult());
                }
            } else {
                inventory.setStackInSlot(slot.getSlotID(), ForgeHooks.getContainerItem((ItemStack)stack));
            }
        }
    }

    public void handleItemConsumption(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
        if (!(this instanceof AttunementRecipe)) {
            return;
        }
        AttunementRecipe thisRecipe = (AttunementRecipe)this;
        ItemHandle handle = thisRecipe.getAttItemHandle(slot);
        if (handle == null) {
            return;
        }
        TileReceiverBaseInventory.ItemHandlerTile inventory = ta.getInventoryHandler();
        ItemStack stack = inventory.getStackInSlot(slot.getSlotId());
        if (!stack.func_190926_b()) {
            FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
            if (fs != null) {
                FluidActionResult fas = ItemUtils.drainFluidFromItem(stack, handle.getFluidTypeAndAmount(), true);
                if (fas.isSuccess()) {
                    inventory.setStackInSlot(slot.getSlotId(), fas.getResult());
                }
            } else {
                inventory.setStackInSlot(slot.getSlotId(), ForgeHooks.getContainerItem((ItemStack)stack));
            }
        }
    }

    public void handleItemConsumption(TileAltar ta, ConstellationRecipe.ConstellationAtlarSlot slot) {
        if (!(this instanceof ConstellationRecipe)) {
            return;
        }
        ConstellationRecipe thisRecipe = (ConstellationRecipe)this;
        ItemHandle handle = thisRecipe.getCstItemHandle(slot);
        if (handle == null) {
            return;
        }
        TileReceiverBaseInventory.ItemHandlerTile inventory = ta.getInventoryHandler();
        ItemStack stack = inventory.getStackInSlot(slot.getSlotId());
        if (!stack.func_190926_b()) {
            FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
            if (fs != null) {
                FluidActionResult fas = ItemUtils.drainFluidFromItem(stack, handle.getFluidTypeAndAmount(), true);
                if (fas.isSuccess()) {
                    inventory.setStackInSlot(slot.getSlotId(), fas.getResult());
                }
            } else {
                inventory.setStackInSlot(slot.getSlotId(), ForgeHooks.getContainerItem((ItemStack)stack));
            }
        }
    }

    public void handleItemConsumption(TileAltar ta, TraitRecipe.TraitRecipeSlot slot) {
        if (!(this instanceof TraitRecipe)) {
            return;
        }
        TraitRecipe thisRecipe = (TraitRecipe)this;
        ItemHandle handle = thisRecipe.getInnerTraitItemHandle(slot);
        if (handle == null) {
            return;
        }
        TileReceiverBaseInventory.ItemHandlerTile inventory = ta.getInventoryHandler();
        ItemStack stack = inventory.getStackInSlot(slot.getSlotId());
        if (!stack.func_190926_b()) {
            FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
            if (fs != null) {
                FluidActionResult fas = ItemUtils.drainFluidFromItem(stack, handle.getFluidTypeAndAmount(), true);
                if (fas.isSuccess()) {
                    inventory.setStackInSlot(slot.getSlotId(), fas.getResult());
                }
            } else {
                inventory.setStackInSlot(slot.getSlotId(), ForgeHooks.getContainerItem((ItemStack)stack));
            }
        }
    }

    protected static ShapedRecipe.Builder shapedRecipe(String basicName, Item out) {
        return ShapedRecipe.Builder.newShapedRecipe("internal/altar/" + basicName, out);
    }

    protected static ShapedRecipe.Builder shapedRecipe(String basicName, Block out) {
        return ShapedRecipe.Builder.newShapedRecipe("internal/altar/" + basicName, out);
    }

    protected static ShapedRecipe.Builder shapedRecipe(String basicName, ItemStack out) {
        return ShapedRecipe.Builder.newShapedRecipe("internal/altar/" + basicName, out);
    }

    public void applyOutputModificationsServer(TileAltar ta, Random rand) {
    }

    public void onCraftServerFinish(TileAltar altar, Random rand) {
    }

    public void onCraftServerTick(TileAltar altar, ActiveCraftingTask.CraftingState state, int tick, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        if (this.specialEffectRecovery != null) {
            try {
                this.specialEffectRecovery.onCraftClientTick(altar, state, tick, rand);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onCraftTESRRender(TileAltar te, double x, double y, double z, float partialTicks) {
        if (this.specialEffectRecovery != null) {
            try {
                this.specialEffectRecovery.onCraftTESRRender(te, x, y, z, partialTicks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

