/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data;

import hellfirepvp.astralsorcery.common.data.AbstractData;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionChain;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class DataLightConnections
extends AbstractData {
    private final Object lock = new Object();
    public boolean clientReceivingData = false;
    private Map<Integer, Map<BlockPos, List<BlockPos>>> clientPosBuffer = new ConcurrentHashMap<Integer, Map<BlockPos, List<BlockPos>>>();
    private Map<Integer, Map<BlockPos, List<BlockPos>>> serverPosBuffer = new HashMap<Integer, Map<BlockPos, List<BlockPos>>>();
    private Map<Integer, LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>>> serverChangeBuffer = new HashMap<Integer, LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>>>();
    private NBTTagCompound clientReadBuffer = new NBTTagCompound();

    public void updateNewConnectionsThreaded(int dimensionId, List<TransmissionChain.LightConnection> newlyAddedConnections) {
        Map<BlockPos, List<BlockPos>> posBufferDim = this.serverPosBuffer.get(dimensionId);
        if (posBufferDim == null) {
            posBufferDim = new HashMap<BlockPos, List<BlockPos>>();
            this.serverPosBuffer.put(dimensionId, posBufferDim);
        }
        for (TransmissionChain.LightConnection c : newlyAddedConnections) {
            BlockPos start = c.getStart();
            BlockPos end = c.getEnd();
            List<BlockPos> endpoints = posBufferDim.get(start);
            if (endpoints == null) {
                endpoints = new LinkedList<BlockPos>();
                posBufferDim.put(start, endpoints);
            }
            if (endpoints.contains(end)) continue;
            endpoints.add(end);
        }
        this.notifyConnectionAdd(dimensionId, newlyAddedConnections);
        if (newlyAddedConnections.size() > 0) {
            this.markDirty();
        }
    }

    public void removeOldConnectionsThreaded(int dimensionId, List<TransmissionChain.LightConnection> invalidConnections) {
        Map<BlockPos, List<BlockPos>> posBufferDim = this.serverPosBuffer.get(dimensionId);
        if (posBufferDim != null) {
            for (TransmissionChain.LightConnection c : invalidConnections) {
                BlockPos start = c.getStart();
                List<BlockPos> ends = posBufferDim.get(start);
                if (ends == null) continue;
                if (ends.contains(c.getEnd())) {
                    ends.remove(c.getEnd());
                }
                if (!ends.isEmpty()) continue;
                posBufferDim.remove(start);
            }
        }
        this.notifyConnectionRemoval(dimensionId, invalidConnections);
        if (invalidConnections.size() > 0) {
            this.markDirty();
        }
    }

    public void clearDimensionPositions(int dimId) {
        if (this.serverPosBuffer.remove(dimId) != null) {
            this.setDimClearFlag(dimId);
            this.markDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDimClearFlag(int dim) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>> ch = this.serverChangeBuffer.get(dim);
            if (ch == null) {
                ch = new LinkedList();
                this.serverChangeBuffer.put(dim, ch);
            }
            ch.clear();
            ch.add(new Tuple<Object, Boolean>(null, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectionAdd(int dimid, List<TransmissionChain.LightConnection> added) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>> ch = this.serverChangeBuffer.get(dimid);
            if (ch == null) {
                ch = new LinkedList();
                this.serverChangeBuffer.put(dimid, ch);
            }
            for (TransmissionChain.LightConnection l : added) {
                ch.add(new Tuple<TransmissionChain.LightConnection, Boolean>(l, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectionRemoval(int dimid, List<TransmissionChain.LightConnection> removal) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>> ch = this.serverChangeBuffer.get(dimid);
            if (ch == null) {
                ch = new LinkedList();
                this.serverChangeBuffer.put(dimid, ch);
            }
            for (TransmissionChain.LightConnection l : removal) {
                ch.add(new Tuple<TransmissionChain.LightConnection, Boolean>(l, false));
            }
        }
    }

    @Nullable
    public Map<BlockPos, List<BlockPos>> getClientConnections(int dimId) {
        return this.clientPosBuffer.get(dimId);
    }

    public void clientClean() {
        this.clientPosBuffer.clear();
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        for (int dimId : this.serverPosBuffer.keySet()) {
            Map<BlockPos, List<BlockPos>> dat = this.serverPosBuffer.get(dimId);
            NBTTagList dataList = new NBTTagList();
            for (BlockPos pos : dat.keySet()) {
                List<BlockPos> connections = dat.get(pos);
                if (connections == null) continue;
                for (BlockPos end : connections) {
                    NBTTagCompound cmp = new NBTTagCompound();
                    cmp.func_74772_a("sta", pos.func_177986_g());
                    cmp.func_74772_a("end", end.func_177986_g());
                    cmp.func_74757_a("s", true);
                    dataList.func_74742_a((NBTBase)cmp);
                }
            }
            compound.func_74782_a("" + dimId, (NBTBase)dataList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToPacket(NBTTagCompound compound) {
        Object object = this.lock;
        synchronized (object) {
            for (int dimId : this.serverChangeBuffer.keySet()) {
                LinkedList<Tuple<TransmissionChain.LightConnection, Boolean>> changes = this.serverChangeBuffer.get(dimId);
                if (changes.isEmpty()) continue;
                NBTTagList list = new NBTTagList();
                for (Tuple tuple : changes) {
                    if (tuple.key == null) {
                        list = new NBTTagList();
                        NBTTagCompound cm = new NBTTagCompound();
                        cm.func_74757_a("clear", true);
                        list.func_74742_a((NBTBase)cm);
                        break;
                    }
                    NBTTagCompound cmp = new NBTTagCompound();
                    cmp.func_74772_a("sta", ((TransmissionChain.LightConnection)tuple.key).getStart().func_177986_g());
                    cmp.func_74772_a("end", ((TransmissionChain.LightConnection)tuple.key).getEnd().func_177986_g());
                    cmp.func_74757_a("s", ((Boolean)tuple.value).booleanValue());
                    list.func_74742_a((NBTBase)cmp);
                }
                compound.func_74782_a("" + dimId, (NBTBase)list);
            }
            this.serverChangeBuffer.clear();
        }
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        this.clientReadBuffer = compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleIncomingData(AbstractData serverData) {
        if (!(serverData instanceof DataLightConnections)) {
            return;
        }
        this.clientReceivingData = true;
        try {
            for (String dimStr : ((DataLightConnections)serverData).clientReadBuffer.func_150296_c()) {
                int dimId = Integer.parseInt(dimStr);
                NBTTagList list = ((DataLightConnections)serverData).clientReadBuffer.func_150295_c(dimStr, 10);
                Map<BlockPos, List<BlockPos>> connectionMap = this.clientPosBuffer.get(dimId);
                if (connectionMap == null) {
                    connectionMap = new ConcurrentHashMap<BlockPos, List<BlockPos>>();
                    this.clientPosBuffer.put(dimId, connectionMap);
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound connection = list.func_150305_b(i);
                    if (connection.func_74764_b("clear")) {
                        this.clientPosBuffer.remove(dimId);
                        break;
                    }
                    BlockPos start = BlockPos.func_177969_a((long)connection.func_74763_f("sta"));
                    BlockPos end = BlockPos.func_177969_a((long)connection.func_74763_f("end"));
                    boolean set = connection.func_74767_n("s");
                    List<BlockPos> to = connectionMap.get(start);
                    if (set) {
                        if (to == null) {
                            to = new LinkedList<BlockPos>();
                            connectionMap.put(start, to);
                        }
                        if (to.contains(end)) continue;
                        to.add(end);
                        continue;
                    }
                    if (to == null) continue;
                    to.remove(end);
                    if (!to.isEmpty()) continue;
                    connectionMap.remove(start);
                }
                if (!connectionMap.isEmpty()) continue;
                this.clientPosBuffer.remove(dimId);
            }
        }
        finally {
            this.clientReceivingData = false;
        }
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataLightConnections> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataLightConnections provideNewInstance() {
            return new DataLightConnections();
        }
    }
}

