/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerkLevelManager;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerks;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncKnowledge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;

public class PlayerProgress {
    private List<String> knownConstellations = new ArrayList<String>();
    private List<String> seenConstellations = new ArrayList<String>();
    private IMajorConstellation attunedConstellation = null;
    private boolean wasOnceAttuned = false;
    private Map<ConstellationPerk, Integer> appliedPerks = new HashMap<ConstellationPerk, Integer>();
    private List<ResearchProgression> researchProgression = new LinkedList<ResearchProgression>();
    private ProgressionTier tierReached = ProgressionTier.DISCOVERY;
    private double alignmentCharge = 0.0;

    public void load(NBTTagCompound compound) {
        int i;
        NBTTagList list;
        this.knownConstellations.clear();
        this.researchProgression.clear();
        this.appliedPerks.clear();
        this.attunedConstellation = null;
        this.tierReached = ProgressionTier.DISCOVERY;
        this.alignmentCharge = 0.0;
        this.wasOnceAttuned = false;
        if (compound.func_74764_b("seenConstellations")) {
            list = compound.func_150295_c("seenConstellations", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.seenConstellations.add(list.func_150307_f(i));
            }
        }
        if (compound.func_74764_b("constellations")) {
            list = compound.func_150295_c("constellations", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                String s = list.func_150307_f(i);
                this.knownConstellations.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("listPerks")) {
            list = compound.func_150295_c("listPerks", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                ConstellationPerks perkEnum = ConstellationPerks.getById(tag.func_74762_e("perkId"));
                Integer unlockLevel = tag.func_74762_e("perkLevel");
                if (perkEnum == null) continue;
                this.appliedPerks.put(perkEnum.createPerk(), unlockLevel);
            }
        }
        if (compound.func_74764_b("attuned")) {
            String cst = compound.func_74779_i("attuned");
            IConstellation c = ConstellationRegistry.getConstellationByName(cst);
            if (c == null || !(c instanceof IMajorConstellation)) {
                AstralSorcery.log.warn("[AstralSorcery] Failed to load attuned Constellation: " + cst + " - constellation doesn't exist or isn't major.");
            } else {
                this.attunedConstellation = (IMajorConstellation)c;
            }
        }
        if (compound.func_74764_b("tierReached")) {
            int tierOrdinal = compound.func_74762_e("tierReached");
            this.tierReached = ProgressionTier.values()[MathHelper.func_76125_a((int)tierOrdinal, (int)0, (int)(ProgressionTier.values().length - 1))];
        }
        if (compound.func_74764_b("research")) {
            int[] research;
            for (int resOrdinal : research = compound.func_74759_k("research")) {
                ResearchProgression prog = ResearchProgression.getById(resOrdinal);
                if (prog == null) continue;
                this.researchProgression.add(prog);
            }
        }
        this.wasOnceAttuned = compound.func_74767_n("wasAttuned");
        if (compound.func_74764_b("alignmentCharge")) {
            this.alignmentCharge = compound.func_74769_h("alignmentCharge");
        }
    }

    public void store(NBTTagCompound cmp) {
        NBTTagList list = new NBTTagList();
        for (String string : this.knownConstellations) {
            list.func_74742_a((NBTBase)new NBTTagString(string));
        }
        NBTTagList l = new NBTTagList();
        for (String s : this.seenConstellations) {
            l.func_74742_a((NBTBase)new NBTTagString(s));
        }
        cmp.func_74782_a("constellations", (NBTBase)list);
        cmp.func_74782_a("seenConstellations", (NBTBase)l);
        cmp.func_74768_a("tierReached", this.tierReached.ordinal());
        cmp.func_74757_a("wasAttuned", this.wasOnceAttuned);
        int[] nArray = new int[this.researchProgression.size()];
        for (int i = 0; i < this.researchProgression.size(); ++i) {
            ResearchProgression progression = this.researchProgression.get(i);
            nArray[i] = progression.getProgressId();
        }
        cmp.func_74783_a("research", nArray);
        if (this.attunedConstellation != null) {
            cmp.func_74778_a("attuned", this.attunedConstellation.getUnlocalizedName());
        }
        list = new NBTTagList();
        for (ConstellationPerk perk : this.appliedPerks.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("perkId", perk.getId());
            tag.func_74768_a("perkLevel", this.appliedPerks.get(perk).intValue());
            list.func_74742_a((NBTBase)tag);
        }
        cmp.func_74782_a("listPerks", (NBTBase)list);
        cmp.func_74780_a("alignmentCharge", this.alignmentCharge);
    }

    public void storeKnowledge(NBTTagCompound cmp) {
        NBTTagList list = new NBTTagList();
        for (String string : this.knownConstellations) {
            list.func_74742_a((NBTBase)new NBTTagString(string));
        }
        NBTTagList l = new NBTTagList();
        for (String s : this.seenConstellations) {
            l.func_74742_a((NBTBase)new NBTTagString(s));
        }
        cmp.func_74782_a("constellations", (NBTBase)list);
        cmp.func_74782_a("seenConstellations", (NBTBase)l);
        cmp.func_74768_a("tierReached", this.tierReached.ordinal());
        cmp.func_74757_a("wasAttuned", this.wasOnceAttuned);
        int[] nArray = new int[this.researchProgression.size()];
        for (int i = 0; i < this.researchProgression.size(); ++i) {
            ResearchProgression progression = this.researchProgression.get(i);
            nArray[i] = progression.getProgressId();
        }
        cmp.func_74783_a("research", nArray);
    }

    public void loadKnowledge(NBTTagCompound compound) {
        int i;
        NBTTagList list;
        this.knownConstellations.clear();
        this.researchProgression.clear();
        this.appliedPerks.clear();
        this.attunedConstellation = null;
        this.tierReached = ProgressionTier.DISCOVERY;
        this.alignmentCharge = 0.0;
        this.wasOnceAttuned = false;
        if (compound.func_74764_b("seenConstellations")) {
            list = compound.func_150295_c("seenConstellations", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.seenConstellations.add(list.func_150307_f(i));
            }
        }
        if (compound.func_74764_b("constellations")) {
            list = compound.func_150295_c("constellations", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                String s = list.func_150307_f(i);
                this.knownConstellations.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("tierReached")) {
            int tierOrdinal = compound.func_74762_e("tierReached");
            this.tierReached = ProgressionTier.values()[MathHelper.func_76125_a((int)tierOrdinal, (int)0, (int)(ProgressionTier.values().length - 1))];
        }
        if (compound.func_74764_b("research")) {
            int[] research;
            for (int resOrdinal : research = compound.func_74759_k("research")) {
                ResearchProgression prog = ResearchProgression.getById(resOrdinal);
                if (prog == null) continue;
                this.researchProgression.add(prog);
            }
        }
        this.wasOnceAttuned = compound.func_74767_n("wasAttuned");
    }

    protected boolean forceGainResearch(ResearchProgression progression) {
        if (!this.researchProgression.contains((Object)progression)) {
            this.researchProgression.add(progression);
            return true;
        }
        return false;
    }

    protected void setAttunedConstellation(IMajorConstellation constellation) {
        this.attunedConstellation = constellation;
        this.wasOnceAttuned = true;
    }

    public void addPerk(ConstellationPerk singleInstance, Integer alignmentLevelUnlocked) {
        this.appliedPerks.put(singleInstance, alignmentLevelUnlocked);
    }

    public void clearPerks() {
        this.appliedPerks.clear();
    }

    public List<ResearchProgression> getResearchProgression() {
        this.researchProgression.removeIf(Objects::isNull);
        return Lists.newLinkedList(this.researchProgression);
    }

    public ProgressionTier getTierReached() {
        return this.tierReached;
    }

    public IMajorConstellation getAttunedConstellation() {
        return this.attunedConstellation;
    }

    public boolean wasOnceAttuned() {
        return this.wasOnceAttuned;
    }

    protected void setAttunedBefore(boolean attuned) {
        this.wasOnceAttuned = attuned;
    }

    public Map<ConstellationPerk, Integer> getAppliedPerks() {
        return this.appliedPerks == null ? Maps.newHashMap() : Collections.unmodifiableMap(this.appliedPerks);
    }

    public boolean hasPerkUnlocked(ConstellationPerks perk) {
        return this.hasPerkUnlocked(perk.getSingleInstance());
    }

    public boolean hasPerkUnlocked(ConstellationPerk perk) {
        return this.appliedPerks.containsKey(perk);
    }

    public boolean isPerkActive(ConstellationPerk perk) {
        return this.hasPerkUnlocked(perk) && this.appliedPerks.get(perk) <= this.getAlignmentLevel();
    }

    public int getNextFreeLevel() {
        int level = this.getAlignmentLevel();
        for (int i = 0; i <= level; ++i) {
            if (this.appliedPerks.values().contains(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasFreeAlignmentLevel() {
        return this.getNextFreeLevel() > -1;
    }

    public double getAlignmentCharge() {
        return this.alignmentCharge;
    }

    public int getAlignmentLevel() {
        return ConstellationPerkLevelManager.getAlignmentLevel(this);
    }

    protected void modifyCharge(double charge) {
        this.alignmentCharge = MathHelper.func_151237_a((double)(this.alignmentCharge + charge), (double)0.0, (double)5000.0);
    }

    protected void forceCharge(int charge) {
        this.alignmentCharge = MathHelper.func_76125_a((int)charge, (int)0, (int)5000);
    }

    protected boolean stepTier() {
        if (this.getTierReached().hasNextTier()) {
            this.setTierReached(ProgressionTier.values()[this.getTierReached().ordinal() + 1]);
            return true;
        }
        return false;
    }

    protected void setTierReached(ProgressionTier tier) {
        this.tierReached = tier;
    }

    public List<String> getKnownConstellations() {
        return this.knownConstellations;
    }

    public List<String> getSeenConstellations() {
        return this.seenConstellations;
    }

    public boolean hasConstellationDiscovered(String constellation) {
        return this.knownConstellations.contains(constellation);
    }

    protected void discoverConstellation(String name) {
        this.memorizeConstellation(name);
        if (!this.knownConstellations.contains(name)) {
            this.knownConstellations.add(name);
        }
    }

    protected void memorizeConstellation(String name) {
        if (!this.seenConstellations.contains(name)) {
            this.seenConstellations.add(name);
        }
    }

    protected void receive(PktSyncKnowledge message) {
        this.knownConstellations = message.knownConstellations;
        this.seenConstellations = message.seenConstellations;
        this.researchProgression = message.researchProgression;
        this.tierReached = ProgressionTier.values()[MathHelper.func_76125_a((int)message.progressTier, (int)0, (int)(ProgressionTier.values().length - 1))];
        this.attunedConstellation = message.attunedConstellation;
        this.appliedPerks = message.appliedPerks;
        this.alignmentCharge = message.alignmentCharge;
        this.wasOnceAttuned = message.wasOnceAttuned;
    }

    public void acceptMergeFrom(PlayerProgress toMergeFrom) {
        for (String seen : toMergeFrom.seenConstellations) {
            this.memorizeConstellation(seen);
        }
        for (String known : toMergeFrom.knownConstellations) {
            this.discoverConstellation(known);
        }
        if (toMergeFrom.wasOnceAttuned) {
            this.wasOnceAttuned = true;
        }
        if (toMergeFrom.tierReached.isThisLaterOrEqual(this.tierReached)) {
            this.tierReached = toMergeFrom.tierReached;
        }
        for (ResearchProgression prog : toMergeFrom.researchProgression) {
            this.forceGainResearch(prog);
        }
    }
}

