/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.entities.EntityTechnicalAmbient;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGrapplingHook
extends EntityThrowable
implements IEntityAdditionalSpawnData,
EntityTechnicalAmbient {
    private static DataParameter<Integer> PULLING_ENTITY = EntityDataManager.func_187226_a(EntityGrapplingHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private static DataParameter<Boolean> PULLING = EntityDataManager.func_187226_a(EntityGrapplingHook.class, (DataSerializer)DataSerializers.field_187198_h);
    private boolean boosted = false;
    private int timeout = 0;
    private int previousDist = 0;
    public int despawning = -1;
    public float pullFactor = 0.0f;
    private EntityLivingBase throwingEntity;

    public EntityGrapplingHook(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityGrapplingHook(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
        float f = -MathHelper.func_76126_a((float)(throwerIn.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(throwerIn.field_70125_A * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(throwerIn.field_70125_A * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(throwerIn.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(throwerIn.field_70125_A * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, 1.7f, 0.0f);
        this.throwingEntity = throwerIn;
        this.func_70105_a(0.1f, 0.1f);
    }

    public void readSpawnData(ByteBuf additionalData) {
        int id = additionalData.readInt();
        try {
            if (id > 0) {
                this.throwingEntity = (EntityLivingBase)this.field_70170_p.func_73045_a(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        int id = -1;
        if (this.throwingEntity != null) {
            id = this.throwingEntity.func_145782_y();
        }
        buffer.writeInt(id);
    }

    protected float func_70185_h() {
        return this.isPulling() ? 0.0f : 0.03f;
    }

    public void setPulling(boolean pull, @Nullable EntityLivingBase hit) {
        this.field_70180_af.func_187227_b(PULLING, (Object)pull);
        this.field_70180_af.func_187227_b(PULLING_ENTITY, (Object)(hit == null ? -1 : hit.func_145782_y()));
    }

    public boolean isPulling() {
        return (Boolean)this.field_70180_af.func_187225_a(PULLING);
    }

    @Nullable
    public EntityLivingBase getPulling() {
        int idPull = (Integer)this.field_70180_af.func_187225_a(PULLING_ENTITY);
        if (idPull > 0) {
            try {
                return (EntityLivingBase)this.field_70170_p.func_73045_a(idPull);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PULLING, (Object)false);
        this.field_70180_af.func_187214_a(PULLING_ENTITY, (Object)-1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_85052_h() == null || this.func_85052_h().field_70128_L) {
            this.setDespawning();
        }
        if (!this.isPulling() && this.field_70173_aa > 20) {
            this.setDespawning();
        }
        if (!this.isDespawning()) {
            EntityLivingBase throwing = this.func_85052_h();
            double dist = Math.max(0.01, (double)throwing.func_70032_d((Entity)this));
            if (!this.field_70128_L && this.isPulling()) {
                if (this.getPulling() != null) {
                    EntityLivingBase at = this.getPulling();
                    this.field_70165_t = at.field_70165_t;
                    this.field_70163_u = at.field_70163_u;
                    this.field_70161_v = at.field_70161_v;
                }
                if (this.getPulling() != null && this.field_70173_aa > 60 && dist < 2.0 || this.getPulling() == null && this.field_70173_aa > 15 && dist < 2.0 || this.timeout > 15) {
                    this.setDespawning();
                } else {
                    int roughDst;
                    this.func_85052_h().field_70143_R = -5.0f;
                    double mx = this.field_70165_t - this.func_85052_h().field_70165_t;
                    double my = this.field_70163_u - this.func_85052_h().field_70163_u;
                    double mz = this.field_70161_v - this.func_85052_h().field_70161_v;
                    Vec3d v2 = new Vec3d(mx /= dist * 5.0, my /= dist * 5.0, mz /= dist * 5.0);
                    if (v2.func_72433_c() > 0.25) {
                        v2 = v2.func_72432_b();
                        mx = v2.field_72450_a / 4.0;
                        my = v2.field_72448_b / 4.0;
                        mz = v2.field_72449_c / 4.0;
                    }
                    this.func_85052_h().field_70159_w += mx;
                    this.func_85052_h().field_70181_x += my + 0.04;
                    this.func_85052_h().field_70179_y += mz;
                    if (!this.boosted) {
                        this.func_85052_h().field_70181_x += (double)0.4f;
                        this.boosted = true;
                    }
                    this.timeout = (roughDst = (int)(dist / 2.0)) >= this.previousDist ? ++this.timeout : 0;
                    this.previousDist = roughDst;
                }
            }
        } else {
            this.despawnTick();
        }
        if (this.field_70170_p.field_72995_K) {
            this.pullFactor = !this.isPulling() ? (this.pullFactor += 0.02f) : (this.pullFactor *= 0.66f);
            this.spawnSparkles();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnSparkles() {
        if (this.despawning == 3 && !this.isPulling()) {
            Vector3 ePos = RenderingUtils.interpolatePosition((Entity)this, 1.0f);
            List<Vector3> positions = this.buildPoints(1.0f);
            for (Vector3 v : positions) {
                if (this.field_70146_Z.nextInt(3) != 0) continue;
                v.add(ePos);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
                p.scale(this.field_70146_Z.nextFloat() * 0.2f + 0.2f).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                if (this.field_70146_Z.nextBoolean()) {
                    p.setColor(Color.WHITE);
                }
                Vector3 m = new Vector3();
                MiscUtils.applyRandomOffset(m, this.field_70146_Z, 0.005f);
                p.motion(m.getX(), m.getY(), m.getZ()).setMaxAge(15 + this.field_70146_Z.nextInt(10));
            }
        }
    }

    public float despawnPercentage(float partial) {
        int tick = this.despawning;
        float p = (float)tick - (1.0f - partial);
        return Math.min(1.0f, Math.max(0.0f, p /= 10.0f));
    }

    public boolean isDespawning() {
        return this.despawning != -1;
    }

    private void setDespawning() {
        if (this.despawning == -1) {
            this.despawning = 0;
        }
    }

    private void despawnTick() {
        ++this.despawning;
        if (this.despawning > 10) {
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 64.0;
        if (Double.isNaN(d0)) {
            d0 = 64.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public List<Vector3> buildPoints(float partial) {
        if (this.func_85052_h() == null) {
            return Collections.emptyList();
        }
        LinkedList list = Lists.newLinkedList();
        Vector3 interpThrower = RenderingUtils.interpolatePosition((Entity)this.func_85052_h(), partial);
        interpThrower.add(this.func_85052_h().field_70130_N / 2.0f, 0.0, this.func_85052_h().field_70130_N / 2.0f);
        Vector3 interpHook = RenderingUtils.interpolatePosition((Entity)this, partial);
        interpHook.add(this.field_70130_N / 2.0f, 0.0, this.field_70130_N / 2.0f);
        Vector3 origin = new Vector3();
        Vector3 to = interpThrower.clone().subtract(interpHook).addY(this.func_85052_h().field_70131_O / 4.0f);
        float lineLength = (float)(to.length() * 5.0);
        list.add(origin.clone());
        int iter = (int)lineLength;
        for (int xx = 1; xx < iter - 1; ++xx) {
            float dist = (float)xx * (lineLength / (float)iter);
            double dx = (interpThrower.getX() - interpHook.getX()) / (double)iter * (double)xx + (double)(MathHelper.func_76126_a((float)(dist / 10.0f)) * this.pullFactor);
            double dy = (interpThrower.getY() - interpHook.getY() + (double)(this.func_85052_h().field_70131_O / 2.0f)) / (double)iter * (double)xx + (double)(MathHelper.func_76126_a((float)(dist / 7.0f)) * this.pullFactor);
            double dz = (interpThrower.getZ() - interpHook.getZ()) / (double)iter * (double)xx + (double)(MathHelper.func_76126_a((float)(dist / 2.0f)) * this.pullFactor);
            list.add(new Vector3(dx, dy, dz));
        }
        list.add(to.clone());
        return list;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, velocity, 0.0f);
    }

    public EntityLivingBase func_85052_h() {
        return this.throwingEntity != null ? this.throwingEntity : super.func_85052_h();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    protected void func_70184_a(RayTraceResult result) {
        Vec3d hit = result.field_72307_f;
        switch (result.field_72313_a) {
            case BLOCK: {
                this.setPulling(true, null);
                break;
            }
            case ENTITY: {
                Entity e = result.field_72308_g;
                if (e == null || this.func_85052_h() != null && e.equals((Object)this.func_85052_h())) {
                    return;
                }
                this.setPulling(true, result.field_72308_g instanceof EntityLivingBase ? (EntityLivingBase)result.field_72308_g : null);
                hit = new Vec3d(hit.field_72450_a, hit.field_72448_b + (double)(result.field_72308_g.field_70131_O * 3.0f / 4.0f), hit.field_72449_c);
            }
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70165_t = hit.field_72450_a;
        this.field_70163_u = hit.field_72448_b;
        this.field_70161_v = hit.field_72449_c;
    }
}

