/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.base.render.INBTModel;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktProgressionUpdate;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemKnowledgeShare
extends Item
implements INBTModel {
    public ItemKnowledgeShare() {
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack creative = new ItemStack((Item)this);
            this.setCreative(creative);
            items.add((Object)creative);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.isCreative(stack)) {
            tooltip.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"misc.knowledge.inscribed.creative", (Object[])new Object[0]));
            return;
        }
        if (this.getKnowledge(stack) == null) {
            tooltip.add(I18n.func_135052_a((String)"misc.knowledge.missing", (Object[])new Object[0]));
        } else {
            String name = this.getKnowledgeOwnerName(stack);
            if (name != null) {
                tooltip.add(I18n.func_135052_a((String)"misc.knowledge.inscribed", (Object[])new Object[]{TextFormatting.BLUE + name}));
            }
        }
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack, ModelResourceLocation suggestedDefaultLocation) {
        if (this.isCreative(stack) || this.getKnowledgeOwnerName(stack) != null) {
            return new ModelResourceLocation(new ResourceLocation(suggestedDefaultLocation.func_110624_b(), suggestedDefaultLocation.func_110623_a() + "_written"), suggestedDefaultLocation.func_177518_c());
        }
        return suggestedDefaultLocation;
    }

    @Override
    public List<ResourceLocation> getAllPossibleLocations(ModelResourceLocation defaultLocation) {
        LinkedList<ResourceLocation> out = new LinkedList<ResourceLocation>();
        out.add((ResourceLocation)defaultLocation);
        out.add(new ResourceLocation(defaultLocation.func_110624_b(), defaultLocation.func_110623_a() + "_written"));
        return out;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_190926_b() || worldIn.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!this.isCreative(stack) && (playerIn.func_70093_af() || this.getKnowledge(stack) == null)) {
            this.tryInscribeKnowledge(stack, playerIn);
        } else {
            this.tryGiveKnowledge(stack, playerIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() || worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!this.isCreative(stack) && (player.func_70093_af() || this.getKnowledge(stack) == null)) {
            this.tryInscribeKnowledge(stack, player);
        } else {
            this.tryGiveKnowledge(stack, player);
        }
        return EnumActionResult.SUCCESS;
    }

    private void tryGiveKnowledge(ItemStack stack, EntityPlayer player) {
        if (this.isCreative(stack)) {
            ResearchManager.forceMaximizeAll(player);
            return;
        }
        if (this.canInscribeKnowledge(stack, player)) {
            return;
        }
        PlayerProgress progress = this.getKnowledge(stack);
        if (progress == null) {
            return;
        }
        ProgressionTier prev = progress.getTierReached();
        if (ResearchManager.mergeApplyPlayerprogress(progress, player) && progress.getTierReached().isThisLater(prev)) {
            PktProgressionUpdate pkt = new PktProgressionUpdate(progress.getTierReached());
            PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        }
    }

    private void tryInscribeKnowledge(ItemStack stack, EntityPlayer player) {
        if (this.canInscribeKnowledge(stack, player)) {
            this.setKnowledge(stack, player, ResearchManager.getProgress(player, Side.SERVER));
        }
    }

    @Nullable
    public EntityPlayer getKnowledgeOwner(ItemStack stack, MinecraftServer server) {
        if (this.isCreative(stack)) {
            return null;
        }
        NBTTagCompound compound = NBTHelper.getPersistentData(stack);
        if (!compound.func_186855_b("knowledgeOwnerUUID")) {
            return null;
        }
        UUID owner = compound.func_186857_a("knowledgeOwnerUUID");
        return server.func_184103_al().func_177451_a(owner);
    }

    @Nullable
    public String getKnowledgeOwnerName(ItemStack stack) {
        if (this.isCreative(stack)) {
            return null;
        }
        NBTTagCompound compound = NBTHelper.getPersistentData(stack);
        if (!compound.func_74764_b("knowledgeOwnerName")) {
            return null;
        }
        return compound.func_74779_i("knowledgeOwnerName");
    }

    @Nullable
    public PlayerProgress getKnowledge(ItemStack stack) {
        if (this.isCreative(stack)) {
            return null;
        }
        NBTTagCompound compound = NBTHelper.getPersistentData(stack);
        if (!compound.func_74764_b("knowledgeTag")) {
            return null;
        }
        NBTTagCompound tag = compound.func_74775_l("knowledgeTag");
        try {
            PlayerProgress progress = new PlayerProgress();
            progress.loadKnowledge(tag);
            return progress;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public boolean canInscribeKnowledge(ItemStack stack, EntityPlayer player) {
        if (this.isCreative(stack)) {
            return false;
        }
        NBTTagCompound compound = NBTHelper.getPersistentData(stack);
        if (!compound.func_186855_b("knowledgeOwnerUUID")) {
            return true;
        }
        UUID owner = compound.func_186857_a("knowledgeOwnerUUID");
        return player.func_110124_au().equals(owner);
    }

    public void setKnowledge(ItemStack stack, EntityPlayer player, PlayerProgress progress) {
        if (this.isCreative(stack)) {
            return;
        }
        NBTTagCompound knowledge = new NBTTagCompound();
        progress.storeKnowledge(knowledge);
        NBTTagCompound compound = NBTHelper.getPersistentData(stack);
        compound.func_74778_a("knowledgeOwnerName", player.func_70005_c_());
        compound.func_186854_a("knowledgeOwnerUUID", player.func_110124_au());
        compound.func_74782_a("knowledgeTag", (NBTBase)knowledge);
    }

    public boolean isCreative(ItemStack stack) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        if (!cmp.func_74764_b("creativeKnowledge")) {
            return false;
        }
        return cmp.func_74767_n("creativeKnowledge");
    }

    private void setCreative(ItemStack stack) {
        NBTHelper.getPersistentData(stack).func_74757_a("creativeKnowledge", true);
    }
}

