/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.crystal;

import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class ToolCrystalProperties
extends CrystalProperties {
    public ToolCrystalProperties(int size, int purity, int collectiveCapability) {
        super(size, purity, collectiveCapability);
    }

    public static ToolCrystalProperties merge(CrystalProperties ... properties) {
        return ToolCrystalProperties.merge(Arrays.asList(properties));
    }

    public static ToolCrystalProperties merge(List<CrystalProperties> properties) {
        int totalSize = 0;
        int totalPurity = 0;
        int totalCollectivity = 0;
        for (CrystalProperties c : properties) {
            totalSize += c.getSize();
            totalPurity += c.getPurity();
            totalCollectivity += c.getCollectiveCapability();
        }
        return new ToolCrystalProperties(totalSize, totalPurity / properties.size(), totalCollectivity / properties.size());
    }

    public static ToolCrystalProperties readFromNBT(NBTTagCompound compound) {
        ToolCrystalProperties prop = new ToolCrystalProperties(0, 0, 0);
        prop.size = compound.func_74762_e("size");
        prop.purity = compound.func_74762_e("purity");
        prop.collectiveCapability = compound.func_74762_e("collect");
        return prop;
    }

    public void damageCutting() {
        this.collectiveCapability = Math.max(0, this.collectiveCapability - 1);
    }

    @Override
    @Nullable
    public ToolCrystalProperties grindCopy(Random rand) {
        CrystalProperties out = super.grindCopy(rand);
        if (out == null) {
            return null;
        }
        return new ToolCrystalProperties(out.size, out.purity, out.collectiveCapability);
    }

    public float getEfficiencyMultiplier() {
        float mult = (float)this.collectiveCapability / 100.0f;
        return Math.max(0.05f, mult * mult);
    }
}

