/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.client;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import io.netty.buffer.ByteBuf;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PktEngraveGlass
implements IMessage,
IMessageHandler<PktEngraveGlass, IMessage> {
    public int dimId;
    public BlockPos pos;
    public List<DrawnConstellation> constellations = new LinkedList<DrawnConstellation>();

    public PktEngraveGlass() {
    }

    public PktEngraveGlass(int dimId, BlockPos pos, List<DrawnConstellation> constellations) {
        this.dimId = dimId;
        this.pos = pos;
        this.constellations = constellations;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimId = buf.readInt();
        this.pos = ByteBufUtils.readPos(buf);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String name = ByteBufUtils.readString(buf);
            int x = buf.readInt();
            int z = buf.readInt();
            IConstellation c = ConstellationRegistry.getConstellationByName(name);
            if (c == null) continue;
            this.constellations.add(new DrawnConstellation(new Point(x, z), c));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimId);
        ByteBufUtils.writePos(buf, this.pos);
        buf.writeInt(this.constellations.size());
        for (DrawnConstellation c : this.constellations) {
            ByteBufUtils.writeString(buf, c.constellation.getUnlocalizedName());
            buf.writeInt(c.point.x);
            buf.writeInt(c.point.y);
        }
    }

    public IMessage onMessage(PktEngraveGlass message, MessageContext ctx) {
        TileMapDrawingTable tmt;
        WorldServer w = DimensionManager.getWorld((int)message.dimId);
        if (w != null && (tmt = MiscUtils.getTileAt((IBlockAccess)w, message.pos, TileMapDrawingTable.class, true)) != null) {
            tmt.tryEngraveGlass(message.constellations);
        }
        return null;
    }
}

