/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.client;

import hellfirepvp.astralsorcery.client.gui.GuiTelescope;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktRotateTelescope
implements IMessage,
IMessageHandler<PktRotateTelescope, PktRotateTelescope> {
    private boolean isClockwise = false;
    private int dimId = -1;
    private BlockPos pos = BlockPos.field_177992_a;

    public PktRotateTelescope() {
    }

    public PktRotateTelescope(boolean isClockwise, int dimId, BlockPos pos) {
        this.isClockwise = isClockwise;
        this.dimId = dimId;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.isClockwise = buf.readBoolean();
        this.pos = ByteBufUtils.readPos(buf);
        this.dimId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isClockwise);
        ByteBufUtils.writePos(buf, this.pos);
        buf.writeInt(this.dimId);
    }

    public PktRotateTelescope onMessage(PktRotateTelescope message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            WorldServer ws;
            TileTelescope tt;
            if (DimensionManager.isDimensionRegistered((int)message.dimId) && (tt = MiscUtils.getTileAt((IBlockAccess)(ws = DimensionManager.getWorld((int)message.dimId)), message.pos, TileTelescope.class, true)) != null) {
                tt.setRotation(message.isClockwise ? tt.getRotation().nextClockWise() : tt.getRotation().nextCounterClockWise());
                return new PktRotateTelescope(message.isClockwise, message.dimId, message.pos);
            }
        } else {
            this.applyRotation(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void applyRotation(PktRotateTelescope pkt) {
        TileTelescope tt;
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == pkt.dimId && (tt = MiscUtils.getTileAt((IBlockAccess)Minecraft.func_71410_x().field_71441_e, pkt.pos, TileTelescope.class, true)) != null) {
            tt.setRotation(pkt.isClockwise ? tt.getRotation().nextClockWise() : tt.getRotation().nextCounterClockWise());
        }
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiTelescope) {
            ((GuiTelescope)Minecraft.func_71410_x().field_71462_r).handleRotationChange(pkt.isClockwise);
        }
    }
}

