/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.item.tool.ItemChargedCrystalAxe;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktDualParticleEvent
implements IMessage,
IMessageHandler<PktDualParticleEvent, IMessage> {
    private int typeOrdinal;
    private double originX;
    private double originY;
    private double originZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double additionalData = 0.0;

    public PktDualParticleEvent() {
    }

    public PktDualParticleEvent(DualParticleEventType type, Vector3 origin, Vector3 target) {
        this.typeOrdinal = type.ordinal();
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        this.targetX = target.getX();
        this.targetY = target.getY();
        this.targetZ = target.getZ();
    }

    public void setAdditionalData(double additionalData) {
        this.additionalData = additionalData;
    }

    public double getAdditionalData() {
        return this.additionalData;
    }

    public void fromBytes(ByteBuf buf) {
        this.typeOrdinal = buf.readInt();
        this.originX = buf.readDouble();
        this.originY = buf.readDouble();
        this.originZ = buf.readDouble();
        this.targetX = buf.readDouble();
        this.targetY = buf.readDouble();
        this.targetZ = buf.readDouble();
        this.additionalData = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.typeOrdinal);
        buf.writeDouble(this.originX);
        buf.writeDouble(this.originY);
        buf.writeDouble(this.originZ);
        buf.writeDouble(this.targetX);
        buf.writeDouble(this.targetY);
        buf.writeDouble(this.targetZ);
        buf.writeDouble(this.additionalData);
    }

    public IMessage onMessage(PktDualParticleEvent message, MessageContext ctx) {
        try {
            DualParticleEventType type = DualParticleEventType.values()[message.typeOrdinal];
            EventAction trigger = type.getTrigger(ctx.side);
            if (trigger != null) {
                trigger.trigger(message);
            }
        }
        catch (Exception exc) {
            AstralSorcery.log.warn("[AstralSorcery] Error executing DualParticleEventType " + message.typeOrdinal + " from " + this.getOriginVec() + " to " + this.getTargetVec());
        }
        return null;
    }

    public Vector3 getOriginVec() {
        return new Vector3(this.originX, this.originY, this.originZ);
    }

    public Vector3 getTargetVec() {
        return new Vector3(this.targetX, this.targetY, this.targetZ);
    }

    private static interface EventAction {
        public void trigger(PktDualParticleEvent var1);
    }

    public static enum DualParticleEventType {
        CHARGE_HARVEST;


        @SideOnly(value=Side.CLIENT)
        private static EventAction getClientTrigger(DualParticleEventType type) {
            switch (type) {
                case CHARGE_HARVEST: {
                    return ItemChargedCrystalAxe::playDrainParticles;
                }
            }
            return null;
        }

        public EventAction getTrigger(Side side) {
            if (!side.isClient()) {
                return null;
            }
            return DualParticleEventType.getClientTrigger(this);
        }
    }
}

