/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFloatingCube;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktLiquidInteractionBurst
implements IMessageHandler<PktLiquidInteractionBurst, IMessage>,
IMessage {
    private static Random rand = new Random();
    private FluidStack comp1;
    private FluidStack comp2;
    private Vector3 pos;

    public PktLiquidInteractionBurst() {
    }

    public PktLiquidInteractionBurst(FluidStack comp1, FluidStack comp2, Vector3 pos) {
        this.comp1 = comp1;
        this.comp2 = comp2;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.comp1 = ByteBufUtils.readFluidStack(buf);
        this.comp2 = ByteBufUtils.readFluidStack(buf);
        this.pos = ByteBufUtils.readVector(buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeFluidStack(buf, this.comp1);
        ByteBufUtils.writeFluidStack(buf, this.comp2);
        ByteBufUtils.writeVector(buf, this.pos);
    }

    public IMessage onMessage(PktLiquidInteractionBurst message, MessageContext ctx) {
        this.playClientEffect(message);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void playClientEffect(PktLiquidInteractionBurst message) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        TextureAtlasSprite tas1 = RenderingUtils.tryGetFlowingTextureOfFluidStack(message.comp1);
        for (int i = 0; i < 11 + rand.nextInt(3); ++i) {
            EntityFXFloatingCube cube = RenderingUtils.spawnFloatingBlockCubeParticle(message.pos, tas1);
            cube.setTextureSubSizePercentage(0.0625f).setMaxAge(20 + rand.nextInt(20));
            cube.setWorldLightCoord((World)Minecraft.func_71410_x().field_71441_e, message.pos.toBlockPos());
            cube.setScale(0.35f).tumble().setMotion(rand.nextFloat() * 0.017f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.017f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.017f * (float)(rand.nextBoolean() ? 1 : -1));
        }
        TextureAtlasSprite tas2 = RenderingUtils.tryGetFlowingTextureOfFluidStack(message.comp2);
        for (int i = 0; i < 11 + rand.nextInt(3); ++i) {
            EntityFXFloatingCube cube = RenderingUtils.spawnFloatingBlockCubeParticle(message.pos, tas2);
            cube.setTextureSubSizePercentage(0.0625f).setMaxAge(20 + rand.nextInt(20));
            cube.setWorldLightCoord((World)Minecraft.func_71410_x().field_71441_e, message.pos.toBlockPos());
            cube.setScale(0.35f).tumble().setMotion(rand.nextFloat() * 0.027f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.027f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.027f * (float)(rand.nextBoolean() ? 1 : -1));
        }
    }
}

