/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageAttunementRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageConstellationRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageDiscoveryRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageLightProximityRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageRecipe;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageStructure;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageText;
import hellfirepvp.astralsorcery.client.gui.journal.page.JournalPageTraitRecipe;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.SpriteQuery;
import hellfirepvp.astralsorcery.common.block.BlockBlackMarble;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.block.BlockCustomSandOre;
import hellfirepvp.astralsorcery.common.block.BlockMachine;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.item.ItemColoredLens;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.block.ItemCollectorCrystal;
import hellfirepvp.astralsorcery.common.item.tool.wand.ItemWand;
import hellfirepvp.astralsorcery.common.item.tool.wand.WandAugment;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.lib.RecipesAS;
import hellfirepvp.astralsorcery.common.registry.RegistryBookLookups;
import hellfirepvp.astralsorcery.common.registry.RegistryRecipes;
import hellfirepvp.astralsorcery.common.tile.TileBore;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RegistryResearch {
    public static void init() {
        RegistryResearch.initDiscovery();
        RegistryResearch.initCrafting();
        RegistryResearch.initAttunement();
        RegistryResearch.initConstellation();
        RegistryResearch.initRadiance();
    }

    private static void initRadiance() {
        ResearchProgression.Registry regRadiance = ResearchProgression.RADIANCE.getRegistry();
        ResearchNode resHintRecipes = new ResearchNode(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_4.ordinal()), "CRAFTING_FOCUS_HINT", 4, 5);
        resHintRecipes.addPage(RegistryResearch.getTextPage("CRAFTING_FOCUS_HINT.1"));
        resHintRecipes.addPage(RegistryResearch.getTextPage("CRAFTING_FOCUS_HINT.2"));
        ResearchNode resAttWands = new ResearchNode(new ItemStack((Item)ItemsAS.wand), "ATT_WANDS", 3, 4);
        resAttWands.addPage(RegistryResearch.getTextPage("ATT_WANDS.1"));
        resAttWands.addPage(RegistryResearch.getTextPage("ATT_WANDS.2"));
        ResearchNode resAttWandArmara = new ResearchNode(ItemWand.setAugment(new ItemStack((Item)ItemsAS.wand), WandAugment.ARMARA), "ATT_WAND_ARMARA", 1, 5);
        resAttWandArmara.addPage(RegistryResearch.getTextPage("ATT_WAND_ARMARA.1"));
        resAttWandArmara.addPage(new JournalPageTraitRecipe(RegistryRecipes.rWandAugmentArmara));
        ResearchNode resAttWandDiscidia = new ResearchNode(ItemWand.setAugment(new ItemStack((Item)ItemsAS.wand), WandAugment.DISCIDIA), "ATT_WAND_DISCIDIA", 1, 3);
        resAttWandDiscidia.addPage(RegistryResearch.getTextPage("ATT_WAND_DISCIDIA.1"));
        resAttWandDiscidia.addPage(new JournalPageTraitRecipe(RegistryRecipes.rWandAugmentDiscidia));
        ResearchNode resAttWandAevitas = new ResearchNode(ItemWand.setAugment(new ItemStack((Item)ItemsAS.wand), WandAugment.AEVITAS), "ATT_WAND_AEVITAS", 4, 2);
        resAttWandAevitas.addPage(RegistryResearch.getTextPage("ATT_WAND_AEVITAS.1"));
        resAttWandAevitas.addPage(new JournalPageTraitRecipe(RegistryRecipes.rWandAugmentAevitas));
        ResearchNode resAttWandVicio = new ResearchNode(ItemWand.setAugment(new ItemStack((Item)ItemsAS.wand), WandAugment.VICIO), "ATT_WAND_VICIO", 5, 3);
        resAttWandVicio.addPage(RegistryResearch.getTextPage("ATT_WAND_VICIO.1"));
        resAttWandVicio.addPage(new JournalPageTraitRecipe(RegistryRecipes.rWandAugmentVicio));
        ResearchNode resAttWandEvorsio = new ResearchNode(ItemWand.setAugment(new ItemStack((Item)ItemsAS.wand), WandAugment.EVORSIO), "ATT_WAND_EVORSIO", 2, 2);
        resAttWandEvorsio.addPage(RegistryResearch.getTextPage("ATT_WAND_EVORSIO.1"));
        resAttWandEvorsio.addPage(new JournalPageTraitRecipe(RegistryRecipes.rWandAugmentEvorsio));
        ResearchNode resCape = new ResearchNode(new ItemStack((Item)ItemsAS.armorImbuedCape), "ATT_CAPE", 3, 6);
        resCape.addPage(RegistryResearch.getTextPage("ATT_CAPE.1"));
        resCape.addPage(new JournalPageTraitRecipe(RegistryRecipes.rCapeBase));
        resCape.addPage(RegistryResearch.getTextPage("ATT_CAPE.3"));
        resCape.addPage(RegistryResearch.getTextPage("ATT_CAPE.4"));
        ResearchNode resChalice = new ResearchNode(new ItemStack((Block)BlocksAS.blockChalice), "C_CHALICE", 5, 4);
        resChalice.addPage(RegistryResearch.getTextPage("C_CHALICE.1"));
        resChalice.addPage(new JournalPageTraitRecipe(RegistryRecipes.rChalice));
        resChalice.addPage(RegistryResearch.getTextPage("C_CHALICE.3"));
        resChalice.addPage(RegistryResearch.getTextPage("C_CHALICE.4"));
        resChalice.addPage(RegistryResearch.getTextPage("C_CHALICE.5"));
        ResearchNode resBore = new ResearchNode(new ItemStack((Block)BlocksAS.blockBore), "BORE_CORE", 7, 5);
        resBore.addPage(RegistryResearch.getTextPage("BORE_CORE.1"));
        resBore.addPage(RegistryResearch.getTextPage("BORE_CORE.2"));
        resBore.addPage(new JournalPageTraitRecipe(RegistryRecipes.rBore));
        resBore.addPage(RegistryResearch.getTextPage("BORE_CORE.4"));
        resBore.addPage(new JournalPageStructure(MultiBlockArrays.patternFountain));
        ResearchNode resBoreLiquid = new ResearchNode(new ItemStack((Block)BlocksAS.blockBoreHead, 1, TileBore.BoreType.LIQUID.ordinal()), "BORE_HEAD_LIQUID", 8, 4);
        resBoreLiquid.addPage(RegistryResearch.getTextPage("BORE_HEAD_LIQUID.1"));
        resBoreLiquid.addPage(RegistryResearch.getTextPage("BORE_HEAD_LIQUID.2"));
        resBoreLiquid.addPage(new JournalPageTraitRecipe(RegistryRecipes.rBoreHeadLiquid));
        resBoreLiquid.addPage(RegistryResearch.getTextPage("BORE_HEAD_LIQUID.4"));
        resBoreLiquid.addPage(new JournalPageTraitRecipe(RegistryRecipes.rResonatorLiquid));
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.armorImbuedCape), resCape, 1, ResearchProgression.RADIANCE);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockChalice), resChalice, 1, ResearchProgression.RADIANCE);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockBore), resBore, 2, ResearchProgression.RADIANCE);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockBoreHead, 1, 0), resBoreLiquid, 1, ResearchProgression.RADIANCE);
        resAttWandArmara.addSourceConnectionFrom(resAttWands);
        resAttWandDiscidia.addSourceConnectionFrom(resAttWands);
        resAttWandAevitas.addSourceConnectionFrom(resAttWands);
        resAttWandVicio.addSourceConnectionFrom(resAttWands);
        resAttWandEvorsio.addSourceConnectionFrom(resAttWands);
        resAttWands.addSourceConnectionFrom(resHintRecipes);
        resCape.addSourceConnectionFrom(resHintRecipes);
        resChalice.addSourceConnectionFrom(resHintRecipes);
        resBore.addSourceConnectionFrom(resChalice);
        resBoreLiquid.addSourceConnectionFrom(resBore);
        regRadiance.register(resAttWands);
        regRadiance.register(resAttWandArmara);
        regRadiance.register(resAttWandAevitas);
        regRadiance.register(resAttWandDiscidia);
        regRadiance.register(resAttWandVicio);
        regRadiance.register(resAttWandEvorsio);
        regRadiance.register(resCape);
        regRadiance.register(resHintRecipes);
        regRadiance.register(resChalice);
        regRadiance.register(resBore);
        regRadiance.register(resBoreLiquid);
    }

    private static void initConstellation() {
        ResearchProgression.Registry regConstellation = ResearchProgression.CONSTELLATION.getRegistry();
        ResearchNode resInfuser = new ResearchNode(new ItemStack((Block)BlocksAS.starlightInfuser), "INFUSER", 4, 2);
        resInfuser.addPage(RegistryResearch.getTextPage("INFUSER.1"));
        resInfuser.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rStarlightInfuser));
        resInfuser.addPage(RegistryResearch.getTextPage("INFUSER.3"));
        resInfuser.addPage(new JournalPageStructure(MultiBlockArrays.patternStarlightInfuser));
        ResearchNode resTreeBeacon = new ResearchNode(new ItemStack((Block)BlocksAS.treeBeacon), "TREEBEACON", 3, 0);
        resTreeBeacon.addPage(RegistryResearch.getTextPage("TREEBEACON.1"));
        resTreeBeacon.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rTreeBeacon));
        resTreeBeacon.addPage(RegistryResearch.getTextPage("TREEBEACON.3"));
        ResearchNode resChargedTools = new ResearchNode(new ItemStack[]{new ItemStack((Item)ItemsAS.chargedCrystalAxe), new ItemStack((Item)ItemsAS.chargedCrystalPickaxe), new ItemStack((Item)ItemsAS.chargedCrystalShovel), new ItemStack((Item)ItemsAS.chargedCrystalSword)}, "CHARGED_TOOLS", 5, 0);
        resChargedTools.addPage(RegistryResearch.getTextPage("CHARGED_TOOLS.1"));
        resChargedTools.addPage(RegistryResearch.getTextPage("CHARGED_TOOLS.2"));
        ItemStack[] stacks = new ItemStack[ItemColoredLens.ColorType.values().length - 1];
        ItemColoredLens.ColorType[] values = ItemColoredLens.ColorType.values();
        for (int i = 0; i < values.length - 1; ++i) {
            ItemColoredLens.ColorType ct = values[i];
            stacks[i] = ct.asStack();
        }
        ResearchNode resColoredLenses = new ResearchNode(stacks, "LENSES_EFFECTS", 2, 1);
        resColoredLenses.addPage(RegistryResearch.getTextPage("LENSES_EFFECTS.1"));
        resColoredLenses.addPage(RegistryResearch.getTextPage("LENSES_EFFECTS.2"));
        resColoredLenses.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rGlassLensFire));
        resColoredLenses.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rGlassLensBreak));
        resColoredLenses.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rGlassLensDamage));
        resColoredLenses.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rGlassLensGrowth));
        resColoredLenses.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rGlassLensRegeneration));
        resColoredLenses.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rGlassLensPush));
        ResearchNode resSpectralLens = new ResearchNode(ItemColoredLens.ColorType.SPECTRAL.asStack(), "SPECTRAL_LENS", 1, 2);
        resSpectralLens.addPage(RegistryResearch.getTextPage("SPECTRAL_LENS.1"));
        resSpectralLens.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rGlassLensSpectral));
        ResearchNode resRitualLink = new ResearchNode(new ItemStack((Block)BlocksAS.ritualLink), "RITUAL_LINK", 1, 0);
        resRitualLink.addPage(RegistryResearch.getTextPage("RITUAL_LINK.1"));
        resRitualLink.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rRitualLink));
        resRitualLink.addPage(new JournalPageStructure(MultiBlockArrays.patternRitualPedestalWithLink));
        ResearchNode resIllWand = new ResearchNode(new ItemStack((Item)ItemsAS.illuminationWand), "ILLUMINATION_WAND", 6, 1);
        resIllWand.addPage(RegistryResearch.getTextPage("ILLUMINATION_WAND.1"));
        resIllWand.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rIlluminationWand));
        resIllWand.addPage(RegistryResearch.getTextPage("ILLUMINATION_WAND.3"));
        ResearchNode resPrism = new ResearchNode(new ItemStack((Block)BlocksAS.lensPrism), "PRISM", 4, 1);
        resPrism.addPage(RegistryResearch.getTextPage("PRISM.1"));
        resPrism.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rPrism));
        ResearchNode resCollCrystal = new ResearchNode(new ItemStack((Block)BlocksAS.collectorCrystal), "COLL_CRYSTAL", 5, 3);
        resCollCrystal.addPage(RegistryResearch.getTextPage("COLL_CRYSTAL.1"));
        resCollCrystal.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rCollectRock));
        ItemStack cel = new ItemStack((Block)BlocksAS.celestialCollectorCrystal);
        ItemCollectorCrystal.setType(cel, BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL);
        ResearchNode resEnhancedCollCrystal = new ResearchNode(cel, "ENHANCED_COLLECTOR", 4, 5);
        resEnhancedCollCrystal.addPage(RegistryResearch.getTextPage("ENHANCED_COLLECTOR.1"));
        resEnhancedCollCrystal.addPage(new JournalPageStructure(MultiBlockArrays.patternCollectorEnhancement, null, new Vector3(0, -36, 0)));
        ResearchNode resCelCrystalCluster = new ResearchNode(new ItemStack((Block)BlocksAS.celestialCrystals, 1, 3), "CEL_CRYSTAL_GROW", 2, 3);
        resCelCrystalCluster.addPage(RegistryResearch.getTextPage("CEL_CRYSTAL_GROW.1"));
        resCelCrystalCluster.addPage(RegistryResearch.getTextPage("CEL_CRYSTAL_GROW.2"));
        ResearchNode resCelCrystals = new ResearchNode(new ItemStack((Item)ItemsAS.celestialCrystal), "CEL_CRYSTALS", 3, 4);
        resCelCrystals.addPage(RegistryResearch.getTextPage("CEL_CRYSTALS.1"));
        ResearchNode resDrawing = new ResearchNode(new ItemStack((Block)BlocksAS.drawingTable), "DRAWING_TABLE", 3, 3);
        resDrawing.addPage(RegistryResearch.getTextPage("DRAWING_TABLE.1"));
        resDrawing.addPage(RegistryResearch.getTextPage("DRAWING_TABLE.2"));
        resDrawing.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rDrawingTable));
        resDrawing.addPage(RegistryResearch.getTextPage("DRAWING_TABLE.4"));
        resDrawing.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rInfusedGlass));
        resDrawing.addPage(RegistryResearch.getTextPage("DRAWING_TABLE.6"));
        resDrawing.addPage(RegistryResearch.getTextPage("DRAWING_TABLE.7"));
        resDrawing.addPage(RegistryResearch.getTextPage("DRAWING_TABLE.8"));
        ResearchNode resTraitUpgrade = new ResearchNode(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_4.ordinal()), "ALTAR4", 6, 3);
        resTraitUpgrade.addPage(RegistryResearch.getTextPage("ALTAR4.1"));
        resTraitUpgrade.addPage(new JournalPageConstellationRecipe(RegistryRecipes.rAltarUpgradeTrait));
        resTraitUpgrade.addPage(new JournalPageStructure(MultiBlockArrays.patternAltarTrait));
        resTraitUpgrade.addPage(RegistryResearch.getTextPage("ALTAR4.4"));
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.celestialCrystal, 1, Short.MAX_VALUE), resCelCrystalCluster, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.celestialCrystals, 1, Short.MAX_VALUE), resCelCrystalCluster, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.collectorCrystal, 1, Short.MAX_VALUE), resCollCrystal, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.lensPrism, 1, Short.MAX_VALUE), resPrism, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(ItemColoredLens.ColorType.FIRE.asStack(), resColoredLenses, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(ItemColoredLens.ColorType.BREAK.asStack(), resColoredLenses, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(ItemColoredLens.ColorType.GROW.asStack(), resColoredLenses, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(ItemColoredLens.ColorType.DAMAGE.asStack(), resColoredLenses, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(ItemColoredLens.ColorType.REGEN.asStack(), resColoredLenses, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(ItemColoredLens.ColorType.PUSH.asStack(), resColoredLenses, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(ItemColoredLens.ColorType.SPECTRAL.asStack(), resSpectralLens, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.illuminationWand, 1, Short.MAX_VALUE), resIllWand, 0, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.starlightInfuser, 1, Short.MAX_VALUE), resInfuser, 1, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.treeBeacon, 1, Short.MAX_VALUE), resTreeBeacon, 1, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.ritualLink, 1, Short.MAX_VALUE), resRitualLink, 1, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), resInfuser, 1, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.drawingTable, 1, Short.MAX_VALUE), resDrawing, 1, ResearchProgression.CONSTELLATION);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_4.ordinal()), resTraitUpgrade, 1, ResearchProgression.CONSTELLATION);
        resCelCrystals.addSourceConnectionFrom(resCelCrystalCluster);
        resPrism.addSourceConnectionFrom(resInfuser);
        resIllWand.addSourceConnectionFrom(resInfuser);
        resCollCrystal.addSourceConnectionFrom(resInfuser);
        resTreeBeacon.addSourceConnectionFrom(resInfuser);
        resChargedTools.addSourceConnectionFrom(resInfuser);
        resSpectralLens.addSourceConnectionFrom(resColoredLenses);
        resEnhancedCollCrystal.addSourceConnectionFrom(resCollCrystal);
        resDrawing.addSourceConnectionFrom(resColoredLenses);
        resDrawing.addSourceConnectionFrom(resInfuser);
        resEnhancedCollCrystal.addSourceConnectionFrom(resCelCrystals);
        resTraitUpgrade.addSourceConnectionFrom(resInfuser);
        regConstellation.register(resColoredLenses);
        regConstellation.register(resPrism);
        regConstellation.register(resCollCrystal);
        regConstellation.register(resCelCrystalCluster);
        regConstellation.register(resCelCrystals);
        regConstellation.register(resIllWand);
        regConstellation.register(resInfuser);
        regConstellation.register(resTreeBeacon);
        regConstellation.register(resChargedTools);
        regConstellation.register(resRitualLink);
        regConstellation.register(resSpectralLens);
        regConstellation.register(resEnhancedCollCrystal);
        regConstellation.register(resDrawing);
        regConstellation.register(resTraitUpgrade);
    }

    private static void initAttunement() {
        ResearchProgression.Registry regAttunement = ResearchProgression.ATTUNEMENT.getRegistry();
        ResearchNode resLinkTool = new ResearchNode(new ItemStack((Item)ItemsAS.linkingTool), "LINKTOOL", 1, 3);
        resLinkTool.addPage(RegistryResearch.getTextPage("LINKTOOL.1"));
        resLinkTool.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rLinkTool));
        resLinkTool.addPage(RegistryResearch.getTextPage("LINKTOOL.3"));
        resLinkTool.addPage(RegistryResearch.getTextPage("LINKTOOL.4"));
        ResearchNode resLens = new ResearchNode(new ItemStack((Block)BlocksAS.lens), "LENS", 0, 4);
        resLens.addPage(RegistryResearch.getTextPage("LENS.1"));
        resLens.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rLens));
        resLens.addPage(RegistryResearch.getTextPage("LENS.3"));
        resLens.addPage(RegistryResearch.getTextPage("LENS.4"));
        ResearchNode resStarOre = new ResearchNode(new ItemStack(Blocks.field_150366_p), "STARMETAL_ORE", 2, 4);
        resStarOre.addPage(RegistryResearch.getTextPage("STARMETAL_ORE.1"));
        ResearchNode resOtherOres = new ResearchNode(new ItemStack[]{new ItemStack(Blocks.field_150402_ci), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150482_ag), new ItemStack(Blocks.field_189878_dg), new ItemStack(Blocks.field_150423_aK), new ItemStack(Blocks.field_150368_y)}, "TRANSMUTATION_ORES", 3, 3);
        resOtherOres.addPage(RegistryResearch.getTextPage("TRANSMUTATION_ORES.1"));
        ResearchNode resStarResult = new ResearchNode(ItemCraftingComponent.MetaType.STARMETAL_INGOT.asStack(), "STARMETAL_RES", 4, 5);
        resStarResult.addPage(RegistryResearch.getTextPage("STARMETAL_RES.1"));
        resStarResult.addPage(RegistryResearch.getTextPage("STARMETAL_RES.2"));
        ResearchNode resPlayerAtt = new ResearchNode(new ItemStack((Block)BlocksAS.attunementAltar), "ATT_PLAYER", 5, 3);
        resPlayerAtt.addPage(RegistryResearch.getTextPage("ATT_PLAYER.1"));
        resPlayerAtt.addPage(RegistryResearch.getTextPage("ATT_PLAYER.2"));
        resPlayerAtt.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rAttunementAltar));
        resPlayerAtt.addPage(RegistryResearch.getTextPage("ATT_PLAYER.4"));
        resPlayerAtt.addPage(new JournalPageStructure(MultiBlockArrays.patternAttunementFrame));
        resPlayerAtt.addPage(RegistryResearch.getTextPage("ATT_PLAYER.6"));
        ResearchNode resAttPerks = new ResearchNode(new ItemStack((Block)BlocksAS.attunementRelay), "ATT_PERKS", 6, 3);
        resAttPerks.addPage(RegistryResearch.getTextPage("ATT_PERKS.1"));
        resAttPerks.addPage(RegistryResearch.getTextPage("ATT_PERKS.2"));
        ResearchNode resCrystalAtt = new ResearchNode(new ItemStack((Item)ItemsAS.rockCrystal), "ATT_CRYSTAL", 7, 4);
        resCrystalAtt.addPage(RegistryResearch.getTextPage("ATT_CRYSTAL.1"));
        resCrystalAtt.addPage(RegistryResearch.getTextPage("ATT_CRYSTAL.2"));
        ResearchNode resRitPedestal = new ResearchNode(new ItemStack((Block)BlocksAS.ritualPedestal), "RIT_PEDESTAL", 8, 3);
        resRitPedestal.addPage(RegistryResearch.getTextPage("RIT_PEDESTAL.1"));
        resRitPedestal.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rRitualPedestal));
        resRitPedestal.addPage(new JournalPageStructure(MultiBlockArrays.patternRitualPedestal));
        ResearchNode resRitualAccel = new ResearchNode(new ItemStack((Block)BlocksAS.ritualPedestal), "PED_ACCEL", 8, 2);
        resRitualAccel.addPage(RegistryResearch.getTextPage("PED_ACCEL.1"));
        resRitualAccel.addPage(RegistryResearch.getTextPage("PED_ACCEL.2"));
        ResearchNode resConstellationUpgrade = new ResearchNode(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_3.ordinal()), "ALTAR3", 5, 7);
        resConstellationUpgrade.addPage(RegistryResearch.getTextPage("ALTAR3.1"));
        resConstellationUpgrade.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rAltarUpgradeConstellation));
        resConstellationUpgrade.addPage(new JournalPageStructure(MultiBlockArrays.patternAltarConstellation));
        resConstellationUpgrade.addPage(RegistryResearch.getTextPage("ALTAR3.4"));
        ResearchNode resMountedTelescope = new ResearchNode(BlockMachine.MachineType.TELESCOPE.asStack(), "TELESCOPE", 1, 5);
        resMountedTelescope.addPage(RegistryResearch.getTextPage("TELESCOPE.1"));
        resMountedTelescope.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rTelescope));
        resMountedTelescope.addPage(RegistryResearch.getTextPage("TELESCOPE.3"));
        resMountedTelescope.addPage(RegistryResearch.getTextPage("TELESCOPE.4"));
        ResearchNode resToolWands = new ResearchNode(new ItemStack[]{new ItemStack((Item)ItemsAS.architectWand), new ItemStack((Item)ItemsAS.exchangeWand)}, "TOOL_WANDS", 4, 3);
        resToolWands.addPage(RegistryResearch.getTextPage("TOOL_WANDS.1"));
        resToolWands.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rArchitectWand));
        resToolWands.addPage(RegistryResearch.getTextPage("TOOL_WANDS.3"));
        resToolWands.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rExchangeWand));
        ResearchNode resToolGrapple = new ResearchNode(new ItemStack((Item)ItemsAS.grapplingWand), "GRAPPLE_WAND", 3, 2);
        resToolGrapple.addPage(RegistryResearch.getTextPage("GRAPPLE_WAND.1"));
        resToolGrapple.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rGrappleWand));
        ResearchNode resQuickCharge = new ResearchNode(new SpriteQuery(AssetLoader.TextureLocation.EFFECT, "star1", 6, 8), "QUICK_CHARGE", 4, 4);
        resQuickCharge.addPage(RegistryResearch.getTextPage("QUICK_CHARGE.1"));
        ResearchNode resStarlightNetwork = new ResearchNode(new ItemStack((Block)BlocksAS.lens), "STARLIGHT_NETWORK", 3, 5);
        resStarlightNetwork.addPage(RegistryResearch.getTextPage("STARLIGHT_NETWORK.1"));
        ResearchNode resCelestialGateway = new ResearchNode(new ItemStack((Block)BlocksAS.celestialGateway), "CELESTIAL_GATEWAY", 6, 5);
        resCelestialGateway.addPage(RegistryResearch.getTextPage("CELESTIAL_GATEWAY.1"));
        resCelestialGateway.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rCelestialGateway));
        resCelestialGateway.addPage(RegistryResearch.getTextPage("CELESTIAL_GATEWAY.3"));
        resCelestialGateway.addPage(new JournalPageStructure(MultiBlockArrays.patternCelestialGateway));
        ResearchNode resShiftStar = new ResearchNode(new ItemStack((Item)ItemsAS.shiftingStar), "SHIFT_STAR", 6, 2);
        resShiftStar.addPage(RegistryResearch.getTextPage("SHIFT_STAR.1"));
        resShiftStar.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rShiftStar));
        ResearchNode resKnowledgeShare = new ResearchNode(new ItemStack((Item)ItemsAS.knowledgeShare), "KNOWLEDGE_SHARE", 2, 6);
        resKnowledgeShare.addPage(RegistryResearch.getTextPage("KNOWLEDGE_SHARE.1"));
        resKnowledgeShare.addPage(new JournalPageAttunementRecipe(RegistryRecipes.rKnowledgeShare));
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.lens, 1, Short.MAX_VALUE), resLens, 0, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.linkingTool, 1, Short.MAX_VALUE), resLinkTool, 0, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(BlockCustomOre.OreType.STARMETAL.asStack(), resStarOre, 0, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(ItemCraftingComponent.MetaType.STARMETAL_INGOT.asStack(), resStarResult, 0, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(ItemCraftingComponent.MetaType.STARDUST.asStack(), resStarResult, 0, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_3.ordinal()), resConstellationUpgrade, 1, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.ritualPedestal, 1, Short.MAX_VALUE), resRitPedestal, 1, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.attunementAltar, 1, Short.MAX_VALUE), resPlayerAtt, 2, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.attunementRelay, 1, Short.MAX_VALUE), resPlayerAtt, 1, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.tunedRockCrystal, 1, Short.MAX_VALUE), resCrystalAtt, 1, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.tunedCelestialCrystal, 1, Short.MAX_VALUE), resCrystalAtt, 1, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.architectWand, 1, Short.MAX_VALUE), resToolWands, 1, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.exchangeWand, 1, Short.MAX_VALUE), resToolWands, 2, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(BlockMachine.MachineType.TELESCOPE.asStack(), resMountedTelescope, 1, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.celestialGateway, 1, Short.MAX_VALUE), resCelestialGateway, 1, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.shiftingStar, 1, Short.MAX_VALUE), resShiftStar, 0, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.grapplingWand, 1, Short.MAX_VALUE), resToolGrapple, 0, ResearchProgression.ATTUNEMENT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.knowledgeShare, 1, Short.MAX_VALUE), resKnowledgeShare, 0, ResearchProgression.ATTUNEMENT);
        regAttunement.register(resLens);
        regAttunement.register(resLinkTool);
        regAttunement.register(resStarOre);
        regAttunement.register(resStarResult);
        regAttunement.register(resOtherOres);
        regAttunement.register(resPlayerAtt);
        regAttunement.register(resCrystalAtt);
        regAttunement.register(resAttPerks);
        regAttunement.register(resRitPedestal);
        regAttunement.register(resRitualAccel);
        regAttunement.register(resConstellationUpgrade);
        regAttunement.register(resMountedTelescope);
        regAttunement.register(resToolWands);
        regAttunement.register(resQuickCharge);
        regAttunement.register(resStarlightNetwork);
        regAttunement.register(resCelestialGateway);
        regAttunement.register(resShiftStar);
        regAttunement.register(resToolGrapple);
        regAttunement.register(resKnowledgeShare);
        resStarOre.addSourceConnectionFrom(resLinkTool);
        resStarOre.addSourceConnectionFrom(resLens);
        resStarResult.addSourceConnectionFrom(resStarOre);
        resConstellationUpgrade.addSourceConnectionFrom(resStarResult);
        resOtherOres.addSourceConnectionFrom(resStarOre);
        resPlayerAtt.addSourceConnectionFrom(resQuickCharge);
        resCrystalAtt.addSourceConnectionFrom(resPlayerAtt);
        resAttPerks.addSourceConnectionFrom(resPlayerAtt);
        resRitPedestal.addSourceConnectionFrom(resCrystalAtt);
        resRitualAccel.addSourceConnectionFrom(resRitPedestal);
        resToolWands.addSourceConnectionFrom(resQuickCharge);
        resQuickCharge.addSourceConnectionFrom(resStarResult);
        resStarlightNetwork.addSourceConnectionFrom(resStarOre);
        resCelestialGateway.addSourceConnectionFrom(resStarResult);
        resShiftStar.addSourceConnectionFrom(resPlayerAtt);
        resToolGrapple.addSourceConnectionFrom(resQuickCharge);
    }

    private static void initCrafting() {
        ResearchProgression.Registry regCrafting = ResearchProgression.BASIC_CRAFT.getRegistry();
        ResearchNode resTelescope = new ResearchNode(new ItemStack((Item)ItemsAS.handTelescope), "HAND_TELESCOPE", 2, 2);
        resTelescope.addPage(RegistryResearch.getTextPage("HAND_TELESCOPE.1"));
        resTelescope.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rCCGlassLens));
        resTelescope.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rHandTelescope));
        resTelescope.addPage(RegistryResearch.getTextPage("HAND_TELESCOPE.4"));
        ResearchNode resRelay = new ResearchNode(new ItemStack((Block)BlocksAS.attunementRelay), "SPEC_RELAY", 2, 0);
        resRelay.addPage(RegistryResearch.getTextPage("SPEC_RELAY.1"));
        resRelay.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rAttenuationAltarRelay));
        resRelay.addPage(new JournalPageStructure(MultiBlockArrays.patternCollectorRelay));
        resRelay.addPage(RegistryResearch.getTextPage("SPEC_RELAY.4"));
        ResearchNode resWell = new ResearchNode(new ItemStack((Block)BlocksAS.blockWell), "WELL", 0, 2);
        resWell.addPage(RegistryResearch.getTextPage("WELL.1"));
        resWell.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rLightwell));
        resWell.addPage(RegistryResearch.getTextPage("WELL.3"));
        ResearchNode resResonator = new ResearchNode(new ItemStack((Item)ItemsAS.skyResonator), "SKY_RESO", 1, 0);
        resResonator.addPage(RegistryResearch.getTextPage("SKY_RESO.1"));
        resResonator.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rSkyResonator));
        resResonator.addPage(RegistryResearch.getTextPage("SKY_RESO.3"));
        ResearchNode resGrindstone = new ResearchNode(BlockMachine.MachineType.GRINDSTONE.asStack(), "GRINDSTONE", 3, 4);
        resGrindstone.addPage(RegistryResearch.getTextPage("GRINDSTONE.1"));
        resGrindstone.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rGrindstone));
        resGrindstone.addPage(RegistryResearch.getTextPage("GRINDSTONE.3"));
        ResearchNode resTools = new ResearchNode(new ItemStack[]{new ItemStack((Item)ItemsAS.crystalPickaxe), new ItemStack((Item)ItemsAS.crystalSword), new ItemStack((Item)ItemsAS.crystalAxe), new ItemStack((Item)ItemsAS.crystalShovel)}, "TOOLS", 2, 5);
        resTools.addPage(RegistryResearch.getTextPage("TOOLS.1"));
        resTools.addPage(RegistryResearch.getTextPage("TOOLS.2"));
        resTools.addPage(RegistryResearch.getTextPage("TOOLS.3"));
        resTools.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rCToolSword));
        resTools.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rCToolPick));
        resTools.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rCToolAxe));
        resTools.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rCToolShovel));
        ResearchNode resIlluminator = new ResearchNode(new ItemStack((Block)BlocksAS.blockIlluminator), "ILLUMINATOR", 4, 1);
        resIlluminator.addPage(RegistryResearch.getTextPage("ILLUMINATOR.1"));
        resIlluminator.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rIlluminator));
        resIlluminator.addPage(RegistryResearch.getTextPage("ILLUMINATOR.3"));
        ResearchNode resNocturnalPowder = new ResearchNode(ItemUsableDust.DustType.NOCTURNAL.asStack(), "NOC_POWDER", 4, 4);
        resNocturnalPowder.addPage(RegistryResearch.getTextPage("NOC_POWDER.1"));
        resNocturnalPowder.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rNocturnalPowder));
        resNocturnalPowder.addPage(RegistryResearch.getTextPage("NOC_POWDER.3"));
        ResearchNode resRockCrystals = new ResearchNode(new ItemStack((Item)ItemsAS.rockCrystal), "ROCK_CRYSTALS", 0, 4);
        resRockCrystals.addPage(RegistryResearch.getTextPage("ROCK_CRYSTALS.1"));
        ResearchNode resCrystalGrowth = new ResearchNode(new ItemStack((Item)ItemsAS.rockCrystal), "CRYSTAL_GROWTH", 1, 3);
        resCrystalGrowth.addPage(RegistryResearch.getTextPage("CRYSTAL_GROWTH.1"));
        ResearchNode resAltarUpgradeAttenuation = new ResearchNode(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_2.ordinal()), "ALTAR2", 2, 1);
        resAltarUpgradeAttenuation.addPage(RegistryResearch.getTextPage("ALTAR2.1"));
        resAltarUpgradeAttenuation.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rAltarUpgradeAttenuation));
        resAltarUpgradeAttenuation.addPage(new JournalPageStructure(MultiBlockArrays.patternAltarAttunement));
        ResearchNode resIlluminationPowder = new ResearchNode(ItemUsableDust.DustType.ILLUMINATION.asStack(), "ILLUM_POWDER", 3, 3);
        resIlluminationPowder.addPage(RegistryResearch.getTextPage("ILLUM_POWDER.1"));
        resIlluminationPowder.addPage(new JournalPageDiscoveryRecipe(RegistryRecipes.rIlluminationPowder));
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_2.ordinal()), resAltarUpgradeAttenuation, 1, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.crystalShovel, 1, Short.MAX_VALUE), resTools, 5, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.crystalAxe, 1, Short.MAX_VALUE), resTools, 4, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.crystalPickaxe, 1, Short.MAX_VALUE), resTools, 3, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.crystalSword, 1, Short.MAX_VALUE), resTools, 2, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(BlockMachine.MachineType.GRINDSTONE.asStack(), resGrindstone, 1, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockWell, 1, Short.MAX_VALUE), resWell, 1, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(ItemCraftingComponent.MetaType.GLASS_LENS.asStack(), resTelescope, 1, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.handTelescope, 1, Short.MAX_VALUE), resTelescope, 2, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.skyResonator, 1, Short.MAX_VALUE), resResonator, 1, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.attunementRelay, 1, Short.MAX_VALUE), resRelay, 1, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(ItemUsableDust.DustType.ILLUMINATION.asStack(), resIlluminationPowder, 1, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(ItemUsableDust.DustType.NOCTURNAL.asStack(), resNocturnalPowder, 1, ResearchProgression.BASIC_CRAFT);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockIlluminator, 1, Short.MAX_VALUE), resIlluminator, 1, ResearchProgression.BASIC_CRAFT);
        regCrafting.register(resIlluminator);
        regCrafting.register(resTelescope);
        regCrafting.register(resGrindstone);
        regCrafting.register(resTools);
        regCrafting.register(resWell);
        regCrafting.register(resAltarUpgradeAttenuation);
        regCrafting.register(resResonator);
        regCrafting.register(resRockCrystals);
        regCrafting.register(resRelay);
        regCrafting.register(resCrystalGrowth);
        regCrafting.register(resIlluminationPowder);
        regCrafting.register(resNocturnalPowder);
        resGrindstone.addSourceConnectionFrom(resRockCrystals);
        resTools.addSourceConnectionFrom(resRockCrystals);
        resAltarUpgradeAttenuation.addSourceConnectionFrom(resWell);
        resResonator.addSourceConnectionFrom(resWell);
        resRelay.addSourceConnectionFrom(resResonator);
        resCrystalGrowth.addSourceConnectionFrom(resWell, resRockCrystals);
        resIlluminator.addSourceConnectionFrom(resIlluminationPowder);
        resNocturnalPowder.addSourceConnectionFrom(resIlluminationPowder);
    }

    private static void initDiscovery() {
        ResearchProgression.Registry regDiscovery = ResearchProgression.DISCOVERY.getRegistry();
        ResearchNode resShrines = new ResearchNode(new ItemStack((Block)BlocksAS.collectorCrystal), "SHRINES", 0, 1);
        resShrines.addPage(RegistryResearch.getTextPage("SHRINES.1"));
        resShrines.addPage(RegistryResearch.getTextPage("SHRINES.2"));
        resShrines.addPage(RegistryResearch.getTextPage("SHRINES.3"));
        ResearchNode resConPaper = new ResearchNode(new ItemStack((Item)ItemsAS.constellationPaper), "CPAPER", 1, 0);
        resConPaper.addPage(RegistryResearch.getTextPage("CPAPER.1"));
        resConPaper.addPage(new JournalPageRecipe(RecipesAS.rRJournal));
        resConPaper.addPage(RegistryResearch.getTextPage("CPAPER.3"));
        resConPaper.addPage(new JournalPageRecipe(RecipesAS.rCCParchment));
        ResearchNode resWand = new ResearchNode(new ItemStack((Item)ItemsAS.wand), "WAND", 2, 2);
        resWand.addPage(RegistryResearch.getTextPage("WAND.1"));
        if (Config.lightProximityResonatingWandRecipe) {
            resWand.addPage(new JournalPageLightProximityRecipe(RecipesAS.rLPRWand));
        }
        resWand.addPage(RegistryResearch.getTextPage("WAND.3"));
        ResearchNode resOres = new ResearchNode(new ItemStack[]{new ItemStack((Block)BlocksAS.customOre, 1, BlockCustomOre.OreType.ROCK_CRYSTAL.ordinal()), new ItemStack((Block)BlocksAS.customSandOre, 1, BlockCustomSandOre.OreType.AQUAMARINE.ordinal())}, "ORES", 1, 3);
        resOres.addPage(RegistryResearch.getTextPage("ORES.1"));
        resOres.addPage(RegistryResearch.getTextPage("ORES.2"));
        ItemStack[] stacks = new ItemStack[BlockMarble.MarbleBlockType.values().length + 1];
        BlockMarble.MarbleBlockType[] values = BlockMarble.MarbleBlockType.values();
        for (int i = 0; i < values.length; ++i) {
            BlockMarble.MarbleBlockType mbt = values[i];
            stacks[i] = new ItemStack((Block)BlocksAS.blockMarble, 1, mbt.getMeta());
        }
        stacks[stacks.length - 1] = new ItemStack((Block)BlocksAS.blockMarbleStairs);
        ResearchNode resMarbleTypes = new ResearchNode(stacks, "MARBLETYPES", 3, 1);
        resMarbleTypes.addPage(RegistryResearch.getTextPage("MARBLETYPES.1"));
        resMarbleTypes.addPage(new JournalPageRecipe(RecipesAS.rMarbleBricks));
        resMarbleTypes.addPage(new JournalPageRecipe(RecipesAS.rMarblePillar));
        resMarbleTypes.addPage(new JournalPageRecipe(RecipesAS.rMarbleChiseled));
        resMarbleTypes.addPage(new JournalPageRecipe(RecipesAS.rMarbleArch));
        resMarbleTypes.addPage(new JournalPageRecipe(RecipesAS.rMarbleRuned));
        resMarbleTypes.addPage(new JournalPageRecipe(RecipesAS.rMarbleEngraved));
        resMarbleTypes.addPage(new JournalPageRecipe(RecipesAS.rMarbleStairs));
        resMarbleTypes.addPage(new JournalPageRecipe(RecipesAS.rMarbleSlab));
        stacks = new ItemStack[BlockBlackMarble.BlackMarbleBlockType.values().length];
        BlockBlackMarble.BlackMarbleBlockType[] sValues = BlockBlackMarble.BlackMarbleBlockType.values();
        for (int i = 0; i < sValues.length; ++i) {
            BlockBlackMarble.BlackMarbleBlockType mbt = sValues[i];
            stacks[i] = new ItemStack((Block)BlocksAS.blockBlackMarble, 1, mbt.getMeta());
        }
        ResearchNode resSootyMarble = new ResearchNode(stacks, "SOOTYMARBLE", 5, 2);
        resSootyMarble.addPage(RegistryResearch.getTextPage("SOOTYMARBLE.1"));
        resSootyMarble.addPage(new JournalPageRecipe(RecipesAS.rBlackMarbleRaw));
        resSootyMarble.addPage(new JournalPageRecipe(RecipesAS.rBlackMarbleBricks));
        resSootyMarble.addPage(new JournalPageRecipe(RecipesAS.rBlackMarblePillar));
        resSootyMarble.addPage(new JournalPageRecipe(RecipesAS.rBlackMarbleChiseled));
        resSootyMarble.addPage(new JournalPageRecipe(RecipesAS.rBlackMarbleArch));
        resSootyMarble.addPage(new JournalPageRecipe(RecipesAS.rBlackMarbleRuned));
        resSootyMarble.addPage(new JournalPageRecipe(RecipesAS.rBlackMarbleEngraved));
        ResearchNode resTable = new ResearchNode(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_1.ordinal()), "ALTAR1", 4, 3);
        resTable.addPage(RegistryResearch.getTextPage("ALTAR1.1"));
        resTable.addPage(RegistryResearch.getTextPage("ALTAR1.2"));
        if (Config.lightProximityAltarRecipe) {
            resTable.addPage(new JournalPageLightProximityRecipe(RecipesAS.rLPRAltar));
        }
        resTable.addPage(RegistryResearch.getTextPage("ALTAR1.4"));
        resTable.addPage(RegistryResearch.getTextPage("ALTAR1.5"));
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_1.ordinal()), resTable, 1, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockBlackMarble.BlackMarbleBlockType.RAW.asStack(), resSootyMarble, 1, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockBlackMarble.BlackMarbleBlockType.BRICKS.asStack(), resSootyMarble, 2, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockBlackMarble.BlackMarbleBlockType.PILLAR.asStack(), resSootyMarble, 3, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockBlackMarble.BlackMarbleBlockType.CHISELED.asStack(), resSootyMarble, 4, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockBlackMarble.BlackMarbleBlockType.ARCH.asStack(), resSootyMarble, 5, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockBlackMarble.BlackMarbleBlockType.RUNED.asStack(), resSootyMarble, 6, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockBlackMarble.BlackMarbleBlockType.ENGRAVED.asStack(), resSootyMarble, 7, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockMarble.MarbleBlockType.BRICKS.asStack(), resMarbleTypes, 1, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockMarble.MarbleBlockType.PILLAR.asStack(), resMarbleTypes, 2, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockMarble.MarbleBlockType.CHISELED.asStack(), resMarbleTypes, 3, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockMarble.MarbleBlockType.ARCH.asStack(), resMarbleTypes, 4, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockMarble.MarbleBlockType.RUNED.asStack(), resMarbleTypes, 5, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockMarble.MarbleBlockType.ENGRAVED.asStack(), resMarbleTypes, 6, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockMarbleStairs, 1, Short.MAX_VALUE), resMarbleTypes, 7, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(new ItemStack((Block)BlocksAS.blockMarbleSlab, 1, Short.MAX_VALUE), resMarbleTypes, 8, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(ItemCraftingComponent.MetaType.AQUAMARINE.asStack(), resOres, 0, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(ItemCraftingComponent.MetaType.PARCHMENT.asStack(), resConPaper, 3, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.rockCrystal, 1, Short.MAX_VALUE), resOres, 0, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.wand, 1, Short.MAX_VALUE), resWand, 0, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.journal, 1, Short.MAX_VALUE), resConPaper, 0, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(new ItemStack((Item)ItemsAS.constellationPaper, 1, Short.MAX_VALUE), resConPaper, 0, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockCustomOre.OreType.ROCK_CRYSTAL.asStack(), resOres, 0, ResearchProgression.DISCOVERY);
        RegistryBookLookups.registerItemLookup(BlockCustomSandOre.OreType.AQUAMARINE.asStack(), resOres, 0, ResearchProgression.DISCOVERY);
        regDiscovery.register(resShrines);
        regDiscovery.register(resWand);
        regDiscovery.register(resOres);
        regDiscovery.register(resConPaper);
        regDiscovery.register(resTable);
        regDiscovery.register(resMarbleTypes);
        regDiscovery.register(resSootyMarble);
        resWand.addSourceConnectionFrom(resShrines);
        resConPaper.addSourceConnectionFrom(resShrines);
        resTable.addSourceConnectionFrom(resWand);
        resWand.addSourceConnectionFrom(resOres);
        resSootyMarble.addSourceConnectionFrom(resMarbleTypes);
    }

    private static JournalPageText getTextPage(String identifier) {
        return new JournalPageText("astralsorcery".toLowerCase() + ".journal." + identifier + ".text");
    }
}

