/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry.structures;

import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.LootTableUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import hellfirepvp.astralsorcery.common.util.struct.StructureBlockArray;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StructureDesertShrine
extends StructureBlockArray {
    private static Random rand = new Random();

    public StructureDesertShrine() {
        this.load();
    }

    @Override
    public Map<BlockPos, IBlockState> placeInWorld(World world, BlockPos center) {
        center = center.func_177977_b();
        Map<BlockPos, IBlockState> result = super.placeInWorld(world, center);
        this.placeSand(world, center);
        return result;
    }

    @Override
    public Map<BlockPos, IBlockState> placeInWorld(World world, BlockPos center, StructureBlockArray.PastPlaceProcessor processor) {
        center = center.func_177977_b();
        Map<BlockPos, IBlockState> result = super.placeInWorld(world, center, processor);
        this.placeSand(world, center);
        return result;
    }

    private void placeSand(World world, BlockPos center) {
        BlockMarble marble = BlocksAS.blockMarble;
        IBlockState mch = marble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.CHISELED));
        IBlockState mpl = marble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.PILLAR));
        this.placeBlockCube(world, center, -4, 1, -4, 4, 1, 4);
        world.func_175656_a(center.func_177982_a(0, 1, 0), mpl);
        world.func_175656_a(center.func_177982_a(0, 2, 0), mch);
        world.func_175656_a(center.func_177982_a(3, 1, 3), mpl);
        world.func_175656_a(center.func_177982_a(3, 2, 3), mpl);
        world.func_175656_a(center.func_177982_a(3, 3, 3), mch);
        world.func_175656_a(center.func_177982_a(-3, 1, 3), mpl);
        world.func_175656_a(center.func_177982_a(-3, 2, 3), mpl);
        world.func_175656_a(center.func_177982_a(-3, 3, 3), mch);
        world.func_175656_a(center.func_177982_a(-3, 1, -3), mpl);
        world.func_175656_a(center.func_177982_a(-3, 2, -3), mpl);
        world.func_175656_a(center.func_177982_a(-3, 3, -3), mch);
        world.func_175656_a(center.func_177982_a(3, 1, -3), mpl);
        world.func_175656_a(center.func_177982_a(3, 2, -3), mpl);
        world.func_175656_a(center.func_177982_a(3, 3, -3), mch);
        this.topBlockWithOffset(3, 4, 3, world, center, 1.0);
        this.topBlockWithOffset(-3, 4, 3, world, center, 1.0);
        this.topBlockWithOffset(3, 4, -3, world, center, 1.0);
        this.topBlockWithOffset(-3, 4, -3, world, center, 1.0);
        this.topBlockWithOffset(0, 3, 0, world, center, 1.0);
        this.topBlockWithOffset(1, 2, 0, world, center, 1.0);
        this.topBlockWithOffset(-1, 2, 0, world, center, 1.0);
        this.topBlockWithOffset(0, 2, 1, world, center, 1.0);
        this.topBlockWithOffset(0, 2, -1, world, center, 1.0);
        this.topBlockWithOffset(-3, 2, -4, world, center, 1.0);
        this.topBlockWithOffset(-4, 2, -3, world, center, 1.0);
        this.topBlockWithOffset(-3, 2, -2, world, center, 1.0);
        this.topBlockWithOffset(-2, 2, -3, world, center, 1.0);
        this.topBlockWithOffset(-3, 2, 4, world, center, 1.0);
        this.topBlockWithOffset(-4, 2, 3, world, center, 1.0);
        this.topBlockWithOffset(-3, 2, 2, world, center, 1.0);
        this.topBlockWithOffset(-2, 2, 3, world, center, 1.0);
        this.topBlockWithOffset(3, 2, -4, world, center, 1.0);
        this.topBlockWithOffset(4, 2, -3, world, center, 1.0);
        this.topBlockWithOffset(3, 2, -2, world, center, 1.0);
        this.topBlockWithOffset(2, 2, -3, world, center, 1.0);
        this.topBlockWithOffset(3, 2, 4, world, center, 1.0);
        this.topBlockWithOffset(4, 2, 3, world, center, 1.0);
        this.topBlockWithOffset(3, 2, 2, world, center, 1.0);
        this.topBlockWithOffset(2, 2, 3, world, center, 1.0);
        this.topBlockWithOffset(3, 3, 4, world, center, 0.5);
        this.topBlockWithOffset(4, 3, 3, world, center, 0.5);
        this.topBlockWithOffset(3, 3, 2, world, center, 0.5);
        this.topBlockWithOffset(2, 3, 3, world, center, 0.5);
        this.topBlockWithOffset(-3, 3, 4, world, center, 0.5);
        this.topBlockWithOffset(-4, 3, 3, world, center, 0.5);
        this.topBlockWithOffset(-3, 3, 2, world, center, 0.5);
        this.topBlockWithOffset(-2, 3, 3, world, center, 0.5);
        this.topBlockWithOffset(3, 3, -4, world, center, 0.5);
        this.topBlockWithOffset(4, 3, -3, world, center, 0.5);
        this.topBlockWithOffset(3, 3, -2, world, center, 0.5);
        this.topBlockWithOffset(2, 3, -3, world, center, 0.5);
        this.topBlockWithOffset(-3, 3, -4, world, center, 0.5);
        this.topBlockWithOffset(-4, 3, -3, world, center, 0.5);
        this.topBlockWithOffset(-3, 3, -2, world, center, 0.5);
        this.topBlockWithOffset(-2, 3, -3, world, center, 0.5);
        this.topBlockWithOffset(1, 2, 1, world, center, 0.5);
        this.topBlockWithOffset(-1, 2, 1, world, center, 0.5);
        this.topBlockWithOffset(1, 2, -1, world, center, 0.5);
        this.topBlockWithOffset(-1, 2, -1, world, center, 0.5);
        this.topBlockWithOffset(0, 3, 1, world, center, 0.4);
        this.topBlockWithOffset(1, 3, 0, world, center, 0.4);
        this.topBlockWithOffset(0, 3, -1, world, center, 0.4);
        this.topBlockWithOffset(-1, 3, 0, world, center, 0.4);
        this.topBlockWithOffset(0, 2, 2, world, center, 0.4);
        this.topBlockWithOffset(2, 2, 0, world, center, 0.4);
        this.topBlockWithOffset(0, 2, -2, world, center, 0.4);
        this.topBlockWithOffset(-2, 2, 0, world, center, 0.4);
        this.topBlockWithOffset(2, 2, 2, world, center, 0.3);
        this.topBlockWithOffset(4, 2, 2, world, center, 0.3);
        this.topBlockWithOffset(2, 2, 4, world, center, 0.3);
        this.topBlockWithOffset(4, 2, 4, world, center, 0.3);
        this.topBlockWithOffset(2, 2, -2, world, center, 0.3);
        this.topBlockWithOffset(4, 2, -2, world, center, 0.3);
        this.topBlockWithOffset(2, 2, -4, world, center, 0.3);
        this.topBlockWithOffset(4, 2, -4, world, center, 0.3);
        this.topBlockWithOffset(-2, 2, 2, world, center, 0.3);
        this.topBlockWithOffset(-4, 2, 2, world, center, 0.3);
        this.topBlockWithOffset(-2, 2, 4, world, center, 0.3);
        this.topBlockWithOffset(-4, 2, 4, world, center, 0.3);
        this.topBlockWithOffset(-2, 2, -2, world, center, 0.3);
        this.topBlockWithOffset(-4, 2, -2, world, center, 0.3);
        this.topBlockWithOffset(-2, 2, -4, world, center, 0.3);
        this.topBlockWithOffset(-4, 2, -4, world, center, 0.3);
    }

    private void topBlockWithOffset(int x, int y, int z, World world, BlockPos center, double chance) {
        if ((double)rand.nextFloat() <= chance) {
            BlockPos at = center.func_177982_a(x, y, z);
            IBlockState top = world.func_180494_b((BlockPos)at).field_76752_A;
            world.func_175656_a(at, top);
        }
    }

    private void placeBlockCube(World world, BlockPos offset, int ox, int oy, int oz, int tx, int ty, int tz) {
        int hz;
        int lz;
        int hy;
        int ly;
        int hx;
        int lx;
        if (ox < tx) {
            lx = ox;
            hx = tx;
        } else {
            lx = tx;
            hx = ox;
        }
        if (oy < ty) {
            ly = oy;
            hy = ty;
        } else {
            ly = ty;
            hy = oy;
        }
        if (oz < tz) {
            lz = oz;
            hz = tz;
        } else {
            lz = tz;
            hz = oz;
        }
        for (int xx = lx; xx <= hx; ++xx) {
            for (int zz = lz; zz <= hz; ++zz) {
                for (int yy = ly; yy <= hy; ++yy) {
                    BlockPos at = offset.func_177982_a(xx, yy, zz);
                    world.func_175656_a(at, world.func_180494_b((BlockPos)at).field_76752_A);
                }
            }
        }
    }

    private void load() {
        BlockMarble marble = BlocksAS.blockMarble;
        IBlockState mch = marble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.CHISELED));
        IBlockState mbr = marble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.BRICKS));
        IBlockState mrw = marble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.RAW));
        IBlockState mar = marble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.ARCH));
        IBlockState mpl = marble.func_176223_P().func_177226_a(BlockMarble.MARBLE_TYPE, (Comparable)((Object)BlockMarble.MarbleBlockType.PILLAR));
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        IBlockState sand = Blocks.field_150354_m.func_176223_P();
        this.addBlockCube(mrw, -4, 0, -3, 4, -7, 3);
        this.addBlockCube(mrw, -3, 0, -4, 3, -7, 4);
        this.addBlockCube(mar, -4, 0, -3, -4, 0, 3);
        this.addBlockCube(mar, 4, 0, -3, 4, 0, 3);
        this.addBlockCube(mar, -3, 0, -4, 3, 0, -4);
        this.addBlockCube(mar, -3, 0, 4, 3, 0, 4);
        this.addBlockCube(mbr, -3, 0, -3, 3, 0, 3);
        this.addBlockCube(mrw, -2, 0, -2, 2, 0, 2);
        this.addBlockCube(air, -2, -2, -2, 2, -5, 2);
        this.addBlockCube(mpl, -3, -2, -1, -3, -5, -1);
        this.addBlockCube(mpl, -3, -2, 1, -3, -5, 1);
        this.addBlockCube(mpl, 3, -2, -1, 3, -5, -1);
        this.addBlockCube(mpl, 3, -2, 1, 3, -5, 1);
        this.addBlockCube(mpl, -1, -2, -3, -1, -5, -3);
        this.addBlockCube(mpl, 1, -2, -3, 1, -5, -3);
        this.addBlockCube(mpl, -1, -2, 3, -1, -5, 3);
        this.addBlockCube(mpl, 1, -2, 3, 1, -5, 3);
        this.addBlockCube(mar, -2, -6, -2, 2, -6, 2);
        this.addBlockCube(air, -2, -6, 0, 2, -6, 0);
        this.addBlockCube(air, 0, -6, -2, 0, -6, 2);
        this.addBlock(-2, -6, -2, mrw);
        this.addBlock(-2, -6, 2, mrw);
        this.addBlock(2, -6, -2, mrw);
        this.addBlock(2, -6, 2, mrw);
        this.addBlock(-3, -3, 0, Blocks.field_150355_j.func_176223_P());
        this.addBlock(3, -3, 0, Blocks.field_150355_j.func_176223_P());
        this.addBlock(0, -3, -3, Blocks.field_150355_j.func_176223_P());
        this.addBlock(0, -3, 3, Blocks.field_150355_j.func_176223_P());
        BlockArray.TileEntityCallback lootCallback = new BlockArray.TileEntityCallback(){

            @Override
            public boolean isApplicable(TileEntity te) {
                return te != null && te instanceof TileEntityChest;
            }

            @Override
            public void onPlace(IBlockAccess access, BlockPos at, TileEntity te) {
                if (te instanceof TileEntityChest) {
                    ((TileEntityChest)te).func_189404_a(LootTableUtil.LOOT_TABLE_SHRINE, STATIC_RAND.nextLong());
                }
            }
        };
        this.addBlock(2, -5, -2, Blocks.field_150486_ae.func_176223_P());
        this.addTileCallback(new BlockPos(2, -5, -2), lootCallback);
        this.addBlock(0, -3, 0, BlocksAS.collectorCrystal.func_176223_P());
        this.addTileCallback(new BlockPos(0, -3, 0), new BlockArray.TileEntityCallback(){

            @Override
            public boolean isApplicable(TileEntity te) {
                return te != null && te instanceof TileCollectorCrystal;
            }

            @Override
            public void onPlace(IBlockAccess access, BlockPos at, TileEntity te) {
                if (te instanceof TileCollectorCrystal) {
                    ((TileCollectorCrystal)te).onPlace(MiscUtils.getRandomEntry(ConstellationRegistry.getMajorConstellations(), STATIC_RAND), CrystalProperties.getMaxRockProperties(), false, BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL);
                }
            }
        });
    }
}

