/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.LightNetworkBuffer;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class WorldNetworkHandler {
    private final LightNetworkBuffer buffer;
    private World world;

    public WorldNetworkHandler(LightNetworkBuffer lightNetworkBuffer, World world) {
        this.buffer = lightNetworkBuffer;
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public static WorldNetworkHandler getNetworkHandler(World world) {
        LightNetworkBuffer buffer = (LightNetworkBuffer)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.LIGHT_NETWORK);
        return buffer.getNetworkHandler(world);
    }

    public void informBlockChange(BlockPos at) {
        List<LightNetworkBuffer.ChunkSectionNetworkData> relatedData = this.getAffectedChunkSections(at);
        if (relatedData.isEmpty()) {
            return;
        }
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(this.getWorld());
        for (LightNetworkBuffer.ChunkSectionNetworkData data : relatedData) {
            if (data == null) continue;
            Collection<IPrismTransmissionNode> transmissionNodes = data.getAllTransmissionNodes();
            for (IPrismTransmissionNode node : transmissionNodes) {
                if (!node.notifyBlockChange(this.getWorld(), at) || handle == null) continue;
                handle.notifyTransmissionNodeChange(node);
            }
        }
    }

    public void informTablePlacement(BlockPos at) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(this.world);
        for (Tuple<BlockPos, IIndependentStarlightSource> source : this.getAllSources()) {
            if (!((IIndependentStarlightSource)source.value).providesAutoLink() || !(((BlockPos)source.key).func_177951_i((Vec3i)at) <= 256.0)) continue;
            IPrismTransmissionNode node = this.getTransmissionNode((BlockPos)source.key);
            if (node == null) {
                AstralSorcery.log.warn("[AstralSorcery] Didn't find a TransmissionNode at a position that's supposed to be a source!");
                AstralSorcery.log.warn("[AstralSorcery] Details: Dim=" + this.getWorld().field_73011_w.getDimension() + " at " + source.key);
                continue;
            }
            if (!(node instanceof ITransmissionSource)) {
                AstralSorcery.log.warn("[AstralSorcery] Found TransmissionNode that isn't a source at a source position!");
                AstralSorcery.log.warn("[AstralSorcery] Details: Dim=" + this.getWorld().field_73011_w.getDimension() + " at " + source.key);
                continue;
            }
            ITransmissionSource sourceNode = (ITransmissionSource)node;
            if (sourceNode.getPos().func_177956_o() <= at.func_177956_o()) continue;
            sourceNode.notifyLink(this.getWorld(), at);
            this.markDirty();
            if (handle == null) continue;
            handle.notifyTransmissionNodeChange(sourceNode);
        }
    }

    public void informTableRemoval(BlockPos at) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(this.world);
        for (Tuple<BlockPos, IIndependentStarlightSource> source : this.getAllSources()) {
            if (!((IIndependentStarlightSource)source.value).providesAutoLink() || !(((BlockPos)source.key).func_177951_i((Vec3i)at) <= 256.0)) continue;
            IPrismTransmissionNode node = this.getTransmissionNode((BlockPos)source.key);
            if (node == null) {
                AstralSorcery.log.warn("[AstralSorcery] Didn't find a TransmissionNode at a position that's supposed to be a source!");
                AstralSorcery.log.warn("[AstralSorcery] Details: Dim=" + this.getWorld().field_73011_w.getDimension() + " at " + source.key);
                continue;
            }
            if (!(node instanceof ITransmissionSource)) {
                AstralSorcery.log.warn("[AstralSorcery] Found TransmissionNode that isn't a source at a source position!");
                AstralSorcery.log.warn("[AstralSorcery] Details: Dim=" + this.getWorld().field_73011_w.getDimension() + " at " + source.key);
                continue;
            }
            ITransmissionSource sourceNode = (ITransmissionSource)node;
            if (!sourceNode.notifyUnlink(this.getWorld(), at)) continue;
            this.markDirty();
            if (handle == null) continue;
            handle.notifyTransmissionNodeChange(sourceNode);
        }
    }

    @Nullable
    public IPrismTransmissionNode getTransmissionNode(@Nullable BlockPos pos) {
        if (pos == null) {
            return null;
        }
        LightNetworkBuffer.ChunkSectionNetworkData section = this.getNetworkData(pos);
        if (section != null) {
            return section.getTransmissionNode(pos);
        }
        return null;
    }

    public void markDirty() {
        this.buffer.markDirty();
    }

    @Nullable
    public IIndependentStarlightSource getSourceAt(BlockPos pos) {
        return this.buffer.getSource(pos);
    }

    public Collection<Tuple<BlockPos, IIndependentStarlightSource>> getAllSources() {
        return this.buffer.getAllSources();
    }

    public void removeSource(IStarlightSource source) {
        this.removeThisSourceFromNext(source);
        this.removeThisNextFromSources(source);
        this.buffer.removeSource(source.getTrPos());
    }

    public void removeTransmission(IStarlightTransmission transmission) {
        this.removeThisSourceFromNext(transmission);
        this.removeThisNextFromSources(transmission);
        this.buffer.removeTransmission(transmission.getTrPos());
    }

    public void addNewSourceTile(IStarlightSource source) {
        this.buffer.addSource(source, source.getTrPos());
        this.linkNextToThisSources(source);
    }

    public void addTransmissionTile(IStarlightTransmission transmission) {
        this.buffer.addTransmission(transmission, transmission.getTrPos());
        this.linkNextToThisSources(transmission);
    }

    private void removeThisNextFromSources(IStarlightTransmission tr) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(this.getWorld());
        if (handle == null) {
            return;
        }
        IPrismTransmissionNode node = tr.getNode();
        if (node == null) {
            new Throwable().printStackTrace();
            AstralSorcery.log.warn("[AstralSorcery] Could not find transmission node for Transmission tile '" + tr.getClass().getSimpleName() + "'");
            AstralSorcery.log.warn("[AstralSorcery] This is an implementation error. Report it along with the steps to create this, if you come across this.");
            return;
        }
        for (BlockPos pos : node.getSources()) {
            IPrismTransmissionNode sourceNode = this.getTransmissionNode(pos);
            if (sourceNode == null) continue;
            handle.notifyTransmissionNodeChange(sourceNode);
        }
    }

    private void removeThisSourceFromNext(IStarlightTransmission tr) {
        IPrismTransmissionNode node = tr.getNode();
        if (node == null) {
            AstralSorcery.log.warn("[AstralSorcery] Could not find transmission node for Transmission tile '" + tr.getClass().getSimpleName() + "'");
            AstralSorcery.log.warn("[AstralSorcery] This is an implementation error. Report it along with the steps to create this, if you come across this.");
            return;
        }
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(this.getWorld());
        if (handle != null) {
            handle.notifyTransmissionNodeChange(node);
        }
        BlockPos thisPos = tr.getTrPos();
        List<NodeConnection<IPrismTransmissionNode>> nodeConnections = node.queryNext(this);
        for (NodeConnection<IPrismTransmissionNode> connection : nodeConnections) {
            if (connection.getNode() == null) continue;
            connection.getNode().notifySourceUnlink(this.getWorld(), thisPos);
            if (handle == null) continue;
            handle.notifyTransmissionNodeChange(connection.getNode());
        }
    }

    private void linkNextToThisSources(IStarlightTransmission tr) {
        IPrismTransmissionNode node = tr.getNode();
        if (node == null) {
            AstralSorcery.log.warn("[AstralSorcery] Previously added Transmission tile '" + tr.getClass().getSimpleName() + "' didn't create a Transmission node!");
            AstralSorcery.log.warn("[AstralSorcery] This is an implementation error. Report it along with the steps to create this, if you come across this.");
            return;
        }
        BlockPos thisPos = tr.getTrPos();
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(this.getWorld());
        List<LightNetworkBuffer.ChunkSectionNetworkData> dataList = this.getAffectedChunkSections(tr.getTrPos());
        for (LightNetworkBuffer.ChunkSectionNetworkData data : dataList) {
            if (data == null) continue;
            for (IPrismTransmissionNode otherNode : data.getAllTransmissionNodes()) {
                List<NodeConnection<IPrismTransmissionNode>> nodeConnections = otherNode.queryNext(this);
                for (NodeConnection<IPrismTransmissionNode> connection : nodeConnections) {
                    if (!connection.getTo().equals((Object)thisPos)) continue;
                    node.notifySourceLink(this.getWorld(), otherNode.getPos());
                    if (handle == null) continue;
                    handle.notifyTransmissionNodeChange(otherNode);
                }
            }
        }
    }

    private List<LightNetworkBuffer.ChunkSectionNetworkData> getAffectedChunkSections(BlockPos centralPos) {
        LinkedList<LightNetworkBuffer.ChunkSectionNetworkData> dataList = new LinkedList<LightNetworkBuffer.ChunkSectionNetworkData>();
        ChunkPos central = new ChunkPos(centralPos);
        int posYLevel = (centralPos.func_177956_o() & 0xFF) >> 4;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                for (int yy = -1; yy <= 1; ++yy) {
                    this.queryData(new ChunkPos(central.field_77276_a + xx, central.field_77275_b + zz), posYLevel + yy, dataList);
                }
            }
        }
        return dataList;
    }

    private void queryData(ChunkPos pos, int yLevel, List<LightNetworkBuffer.ChunkSectionNetworkData> out) {
        LightNetworkBuffer.ChunkSectionNetworkData data = this.buffer.getSectionData(pos, yLevel);
        if (data != null && !data.isEmpty()) {
            out.add(data);
        }
    }

    @Nullable
    private LightNetworkBuffer.ChunkSectionNetworkData getNetworkData(BlockPos at) {
        LightNetworkBuffer.ChunkSectionNetworkData data = this.buffer.getSectionData(at);
        if (data != null && !data.isEmpty()) {
            return data;
        }
        return null;
    }
}

