/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.effect.texture.TextureSpritePlane;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.auxiliary.LiquidStarlightChaliceHandler;
import hellfirepvp.astralsorcery.common.base.FluidRarityRegistry;
import hellfirepvp.astralsorcery.common.block.BlockBoreHead;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.tile.ILiquidStarlightPowered;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.base.TileInventoryBase;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.SimpleSingleFluidCapabilityTank;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.data.VerticalConeBlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.struct.PatternBlockArray;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBore
extends TileInventoryBase
implements IMultiblockDependantTile,
ILiquidStarlightPowered {
    private static int SEGMENT_STARTUP = 60;
    private static int SEGMENT_PREPARATION = 200;
    private SimpleSingleFluidCapabilityTank tank = new SimpleSingleFluidCapabilityTank(1000, EnumFacing.UP);
    private boolean hasMultiblock = false;
    private int operationTicks = 0;
    private int mbStarlight = 0;
    private int productionTimeout = 0;
    private VerticalConeBlockDiscoverer coneBlockDiscoverer;
    private boolean diggingSuccessful = false;
    private float digPercentage = 0.0f;
    private List<BlockPos> digPosResult = null;
    private Object spritePlane = null;

    public TileBore() {
        super(1, EnumFacing.UP);
        this.tank.setAllowInput(false);
    }

    @Override
    protected TileInventoryBase.ItemHandlerTile createNewItemHandler() {
        return new TileInventoryBase.ItemHandlerTileFiltered(this){

            @Override
            public boolean canInsertItem(int slot, ItemStack toAdd, @Nonnull ItemStack existing) {
                return false;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if ((this.ticksExisted & 0x1F) == 0) {
            this.updateMultiblockState();
        }
        if (!this.field_145850_b.field_72995_K) {
            TileChalice tc;
            if (this.coneBlockDiscoverer == null) {
                this.coneBlockDiscoverer = new VerticalConeBlockDiscoverer(this.func_174877_v().func_177979_c(3));
            }
            if (this.mbStarlight <= 12000 && this.getCurrentBoreType() != null && (tc = MiscUtils.getTileAt((IBlockAccess)this.field_145850_b, this.func_174877_v().func_177984_a(), TileChalice.class, false)) != null) {
                LiquidStarlightChaliceHandler.requestLiquidStarlightAndTransferTo(this, tc, this.ticksExisted, 400);
            }
            if (!this.consumeLiquid()) {
                if (this.operationTicks <= 0) return;
                --this.operationTicks;
                this.markForUpdate();
                return;
            }
            if (this.getCurrentBoreType() == null) {
                if (this.operationTicks > 0) {
                    this.markForUpdate();
                }
                this.operationTicks = 0;
                return;
            }
            this.handleSetupProgressTick();
            this.markForUpdate();
            if (this.operationTicks < SEGMENT_PREPARATION) return;
            if (!this.diggingSuccessful) {
                if (this.ticksExisted % 8 != 0) return;
                this.attemptDig();
                return;
            } else {
                if (this.ticksExisted % 32 == 0) {
                    this.checkDigState();
                }
                if (!this.diggingSuccessful) return;
                if (this.productionTimeout > 0) {
                    --this.productionTimeout;
                }
                if (this.productionTimeout > 0) return;
                this.productionTimeout = rand.nextInt(10) + 20;
                BoreType type = this.getCurrentBoreType();
                if (type == null) return;
                switch (type) {
                    case LIQUID: {
                        Chunk ch = this.field_145850_b.func_175726_f(this.func_174877_v());
                        FluidRarityRegistry.ChunkFluidEntry entry = FluidRarityRegistry.getChunkEntry(ch);
                        if (entry == null) return;
                        int mbDrain = rand.nextInt(300) + 300;
                        int actMbDrain = Math.min(entry.getMbRemaining(), mbDrain);
                        if (entry.isValid() && actMbDrain > 0) {
                            FluidStack drained = entry.tryDrain(actMbDrain, false);
                            if (drained == null || drained.getFluid() == null) {
                                drained = new FluidStack(FluidRegistry.WATER, mbDrain);
                            }
                            List<TileChalice> out = LiquidStarlightChaliceHandler.findNearbyChalicesWithSpaceFor(this, drained);
                            out.removeIf(t -> t.func_174877_v().equals((Object)this.func_174877_v().func_177984_a()));
                            if (out.isEmpty()) return;
                            TileChalice target = out.get(rand.nextInt(out.size()));
                            LiquidStarlightChaliceHandler.doFluidTransfer(this, target, drained.copy());
                            entry.tryDrain(actMbDrain, true);
                            return;
                        }
                        FluidStack drained = new FluidStack(FluidRegistry.WATER, mbDrain);
                        List<TileChalice> out = LiquidStarlightChaliceHandler.findNearbyChalicesWithSpaceFor(this, drained);
                        out.removeIf(t -> t.func_174877_v().equals((Object)this.func_174877_v().func_177984_a()));
                        if (out.isEmpty()) return;
                        TileChalice target = out.get(rand.nextInt(out.size()));
                        LiquidStarlightChaliceHandler.doFluidTransfer(this, target, drained.copy());
                    }
                }
            }
            return;
        } else {
            if (!this.hasMultiblock || this.operationTicks <= 0 || this.getCurrentBoreType() == null) return;
            this.updateBoreSprite();
            switch (this.getCurrentWorkingSegment()) {
                case STARTUP: {
                    float chance = (float)this.operationTicks / (float)SEGMENT_STARTUP;
                    this.playVortex(chance);
                    this.playArcs(chance);
                    return;
                }
                case PREPARATION: {
                    float prepChance = ((float)this.operationTicks - (float)SEGMENT_STARTUP) / ((float)SEGMENT_PREPARATION - (float)SEGMENT_STARTUP);
                    this.playArcs(prepChance);
                    this.playVortex(1.0f - prepChance);
                    if (this.operationTicks == SEGMENT_PREPARATION) {
                        this.markDigProcess();
                    }
                    if ((double)prepChance <= 0.85) {
                        this.playInnerVortex(Math.max(0.0, (-0.35 + (double)prepChance) * 2.0));
                        return;
                    }
                    double ch = (double)prepChance - 0.85;
                    this.playInnerVortex(1.0 - (ch /= 0.15));
                    return;
                }
                case DIG: 
                case PRODUCTION: {
                    this.playLightbeam();
                    this.playArcs(1.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playInnerVortex(double chance) {
        for (int i = 0; i < 12; ++i) {
            if (!((double)rand.nextFloat() < chance)) continue;
            Vector3 particlePos = new Vector3((double)this.field_174879_c.func_177958_n() - 0.4 + (double)rand.nextFloat() * 1.8, (double)((float)this.field_174879_c.func_177956_o() - rand.nextFloat() * 3.0f), (double)this.field_174879_c.func_177952_p() - 0.4 + (double)rand.nextFloat() * 1.8);
            Vector3 dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-30.0);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
            if (!rand.nextBoolean()) continue;
            p.setColor(new Color(5793279));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void markDigProcess() {
        int x = this.func_174877_v().func_177958_n();
        int z = this.func_174877_v().func_177952_p();
        for (int yy = 0; yy < this.func_174877_v().func_177956_o(); ++yy) {
            BlockPos pos = new BlockPos(x, yy, z);
            IBlockState at = this.field_145850_b.func_180495_p(pos);
            if (!at.func_185895_e() && !at.func_177230_c().isAir(at, (IBlockAccess)this.field_145850_b, pos)) continue;
            for (int i = 0; i < 20; ++i) {
                Vector3 v = new Vector3((double)x + 0.2 + (double)rand.nextFloat() * 0.6, (double)((float)yy + rand.nextFloat()), (double)z + 0.2 + (double)rand.nextFloat() * 0.6);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
                p.setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
                p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
            }
        }
        Vector3 origin = new Vector3(this.func_174877_v()).add(0.5, 0.5, 0.5);
        Vector3 target = new Vector3(this.func_174877_v()).add(0.5, 0.0, 0.5).setY(0);
        EffectLightbeam beam = EffectHandler.getInstance().lightbeam(target, origin, 1.5).setAlphaMultiplier(1.0f);
        beam.setAlphaFunction(EntityComplexFX.AlphaFunction.FADE_OUT);
        beam.setDistanceCapSq(Config.maxEffectRenderDistanceSq * 5).setColorOverlay(new Color(5793279));
    }

    @SideOnly(value=Side.CLIENT)
    private void playVortex(float chance) {
        for (int i = 0; i < 20; ++i) {
            if (!(rand.nextFloat() < chance)) continue;
            Vector3 particlePos = new Vector3((float)(this.field_174879_c.func_177958_n() - 3) + rand.nextFloat() * 7.0f, (float)this.field_174879_c.func_177956_o() + rand.nextFloat(), (float)(this.field_174879_c.func_177952_p() - 3) + rand.nextFloat() * 7.0f);
            Vector3 dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-30.0);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playArcs(float chance) {
        if ((chance == 1.0f || rand.nextFloat() < chance) && rand.nextInt(10) == 0) {
            Vector3 pos = new Vector3(this).add(0.5, 0.5, 0.5);
            Vector3 dir = new Vector3(1, 0, 0).rotate(Math.toRadians(rand.nextFloat() * 360.0f), Vector3.RotAxis.Y_AXIS);
            dir.normalize().multiply(4);
            Vector3 pos1 = pos.clone().add(dir);
            dir = new Vector3(1, 0, 0).rotate(Math.toRadians(rand.nextFloat() * 360.0f), Vector3.RotAxis.Y_AXIS);
            dir.normalize().multiply(4);
            Vector3 pos2 = pos.clone().add(dir);
            EffectHandler.getInstance().lightning(pos1, pos2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playLightbeam() {
        Vector3 particlePos = new Vector3((double)this.field_174879_c.func_177958_n() - 2.5 + (double)(rand.nextFloat() * 6.0f), (double)this.field_174879_c.func_177956_o() - 1.2 + (double)rand.nextFloat() * 3.4, (double)this.field_174879_c.func_177952_p() - 2.5 + (double)(rand.nextFloat() * 6.0f));
        Vector3 dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-30.0);
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
        p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
        p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Color.WHITE);
        for (int i = 0; i < 5; ++i) {
            Vector3 v = new Vector3(this).add(0.3 + (double)rand.nextFloat() * 0.4, (double)(-rand.nextFloat()) * 1.7, 0.3 + (double)rand.nextFloat() * 0.4);
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(v.getX(), v.getY(), v.getZ());
            particle.gravity(0.004).scale(0.4f).setAlphaMultiplier(1.0f);
            particle.motion(0.0, (double)(-rand.nextFloat()) * 0.015, 0.0);
            particle.setColor(Color.getHSBColor(rand.nextFloat() * 360.0f, 1.0f, 1.0f));
        }
        if (this.ticksExisted % 25 != 0) {
            return;
        }
        float yTarget = (float)this.func_174877_v().func_177956_o() * (1.0f - this.digPercentage);
        Vector3 origin = new Vector3(this.func_174877_v()).add(0.5, 0.5, 0.5);
        Vector3 target = new Vector3(this.func_174877_v()).add(0.5, 0.0, 0.5).setY(yTarget);
        EffectLightbeam beam = EffectHandler.getInstance().lightbeam(target, origin, 9.0).setAlphaMultiplier(1.0f);
        beam.setDistanceCapSq(Config.maxEffectRenderDistanceSq * 5);
        yTarget = (float)this.func_174877_v().func_177956_o() * (0.75f - this.digPercentage / 4.0f);
        target = new Vector3(this.func_174877_v()).add(0.5, 0.0, 0.5).setY(yTarget);
        origin = origin.clone().add((double)rand.nextFloat() * 0.05 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, (double)rand.nextFloat() * 0.05 * (double)(rand.nextBoolean() ? 1 : -1));
        beam = EffectHandler.getInstance().lightbeam(target, origin, 0.8).setAlphaMultiplier(1.0f);
        beam.setDistanceCapSq(Config.maxEffectRenderDistanceSq * 5).setColorOverlay(new Color(6987519));
    }

    private boolean consumeLiquid() {
        if (this.mbStarlight > 0) {
            --this.mbStarlight;
            return true;
        }
        return false;
    }

    private void checkDigState() {
        if (this.digPosResult == null) {
            this.diggingSuccessful = false;
            this.digPercentage = 0.0f;
            return;
        }
        List out = this.digPosResult.stream().filter(p -> !this.field_145850_b.func_175623_d(p) && this.field_145850_b.func_175625_s(p) == null && this.field_145850_b.func_180495_p(p).func_185887_b(this.field_145850_b, p) >= 0.0f).collect(Collectors.toList());
        if (!out.isEmpty()) {
            this.diggingSuccessful = false;
            this.digPercentage = 0.0f;
            this.digPosResult = null;
        } else {
            this.diggingSuccessful = true;
            this.digPercentage = 1.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDig() {
        float downPerc = Math.min(1.0f, this.digPercentage + 0.2f);
        float dst = (float)this.func_174877_v().func_177956_o() * downPerc;
        List<BlockPos> pos = this.coneBlockDiscoverer.tryDiscoverBlocksDown(dst, 5.0f * downPerc);
        List out = pos.stream().filter(p -> !this.field_145850_b.func_175623_d(p) && this.field_145850_b.func_175625_s(p) == null && this.field_145850_b.func_180495_p(p).func_185887_b(this.field_145850_b, p) >= 0.0f).collect(Collectors.toList());
        if (!out.isEmpty() && this.field_145850_b instanceof WorldServer) {
            BlockDropCaptureAssist.startCapturing();
            try {
                for (BlockPos p2 : out) {
                    IBlockState state = this.field_145850_b.func_180495_p(p2);
                    if (state.func_185904_a().func_76224_d()) continue;
                    MiscUtils.breakBlockWithoutPlayer((WorldServer)this.field_145850_b, p2, state, true, true, false);
                }
            }
            finally {
                double x = (double)this.func_174877_v().func_177958_n() + 0.5;
                double y = (double)this.func_174877_v().func_177956_o() + 1.5;
                double z = (double)this.func_174877_v().func_177952_p() + 0.5;
                for (ItemStack stack : BlockDropCaptureAssist.getCapturedStacksAndStop()) {
                    ItemUtils.dropItem(this.field_145850_b, x, y, z, stack);
                }
            }
        }
        this.digPercentage = downPerc;
        boolean bl = this.diggingSuccessful = this.digPercentage >= 1.0f;
        if (this.diggingSuccessful && this.digPosResult == null) {
            this.digPosResult = pos;
        }
    }

    private void handleSetupProgressTick() {
        if (!this.hasMultiblock || this.getCurrentBoreType() == null) {
            this.operationTicks = 0;
            return;
        }
        if (this.operationTicks <= SEGMENT_PREPARATION) {
            ++this.operationTicks;
        }
    }

    @Nonnull
    public OperationSegment getCurrentWorkingSegment() {
        if (this.operationTicks == 0) {
            return OperationSegment.INACTIVE;
        }
        if (this.operationTicks <= SEGMENT_STARTUP) {
            return OperationSegment.STARTUP;
        }
        if (this.operationTicks <= SEGMENT_PREPARATION) {
            return OperationSegment.PREPARATION;
        }
        if (!this.diggingSuccessful) {
            return OperationSegment.DIG;
        }
        return OperationSegment.PRODUCTION;
    }

    @Override
    public boolean canAcceptStarlight(int mbLiquidStarlight) {
        return true;
    }

    @Override
    public void acceptStarlight(int mbLiquidStarlight) {
        this.mbStarlight += mbLiquidStarlight * 2;
        this.markForUpdate();
    }

    private void updateMultiblockState() {
        boolean found = this.getRequiredStructure().matches(this.field_145850_b, this.func_174877_v());
        if (found) {
            found = this.doEmptyCheck();
        }
        boolean update = this.hasMultiblock != found;
        this.hasMultiblock = found;
        if (update) {
            this.markForUpdate();
        }
    }

    private boolean doEmptyCheck() {
        for (int yy = -2; yy <= 2; ++yy) {
            for (int xx = -3; xx <= 3; ++xx) {
                for (int zz = -3; zz <= 3; ++zz) {
                    if (Math.abs(xx) == 3 && Math.abs(zz) == 3) continue;
                    BlockPos at = this.func_174877_v().func_177982_a(xx, yy, zz);
                    if (xx == 0 && zz == 0) {
                        switch (yy) {
                            case -2: {
                                if (this.field_145850_b.func_175623_d(at)) break;
                                return false;
                            }
                        }
                        continue;
                    }
                    if (this.field_145850_b.func_175623_d(at)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureSpritePlane updateBoreSprite() {
        TextureSpritePlane spr = (TextureSpritePlane)this.spritePlane;
        if ((spr == null || spr.canRemove() || spr.isRemoved()) && this.operationTicks > 0) {
            spr = EffectHandler.getInstance().textureSpritePlane(SpriteLibrary.spriteHalo3, Vector3.RotAxis.Y_AXIS.clone());
            spr.setPosition(new Vector3(this).add(0.5, 0.5, 0.5));
            spr.setNoRotation(45.0f).setAlphaMultiplier(1.0f);
            spr.setRefreshFunc(() -> {
                if (this.func_145837_r() || this.getCurrentBoreType() == null || this.operationTicks <= 0) {
                    return false;
                }
                if (this.func_145831_w().field_73011_w == null || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.field_73011_w == null) {
                    return false;
                }
                return this.func_145831_w().field_73011_w.getDimension() == Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
            });
            spr.setRenderAlphaFunction((fx, a) -> a * Math.min(1.0f, (float)this.operationTicks / (float)SEGMENT_STARTUP));
            spr.setScale(5.5f);
            this.spritePlane = spr;
        }
        return spr;
    }

    @Nullable
    public BoreType getCurrentBoreType() {
        IBlockState parent = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (parent.func_177230_c() instanceof BlockBoreHead) {
            return (BoreType)((Object)parent.func_177229_b(BlockBoreHead.BORE_TYPE));
        }
        return null;
    }

    @Override
    @Nullable
    public PatternBlockArray getRequiredStructure() {
        return MultiBlockArrays.patternFountain;
    }

    @Override
    protected void onFirstTick() {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeNBT());
        compound.func_74768_a("operation", this.operationTicks);
        compound.func_74757_a("multiblockState", this.hasMultiblock);
        compound.func_74757_a("digState", this.diggingSuccessful);
        compound.func_74776_a("digPerc", this.digPercentage);
        compound.func_74768_a("mbStarlight", this.mbStarlight);
    }

    @Override
    public void writeSaveNBT(NBTTagCompound compound) {
        super.writeSaveNBT(compound);
        compound.func_74768_a("productionTick", this.productionTimeout);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.tank = SimpleSingleFluidCapabilityTank.deserialize(compound.func_74775_l("tank"));
        if (!this.tank.hasCapability(EnumFacing.UP)) {
            this.tank.accessibleSides.add(EnumFacing.UP);
        }
        this.operationTicks = compound.func_74762_e("operation");
        this.hasMultiblock = compound.func_74767_n("multiblockState");
        this.diggingSuccessful = compound.func_74767_n("digState");
        this.digPercentage = compound.func_74760_g("digPerc");
        this.mbStarlight = compound.func_74762_e("mbStarlight");
    }

    @Override
    public void readSaveNBT(NBTTagCompound compound) {
        super.readSaveNBT(compound);
        this.productionTimeout = compound.func_74762_e("productionTick");
    }

    public static enum BoreType implements IStringSerializable
    {
        LIQUID;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }

    public static enum OperationSegment {
        INACTIVE,
        STARTUP,
        PREPARATION,
        DIG,
        PRODUCTION;

    }
}

