/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationBotania;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    private static final Random rand = new Random();

    public static EntityItem dropItem(World world, double x, double y, double z, ItemStack stack) {
        if (world.field_72995_K) {
            return null;
        }
        EntityItem ei = new EntityItem(world, x, y, z, stack);
        ei.field_70159_w = 0.0;
        ei.field_70181_x = 0.0;
        ei.field_70179_y = 0.0;
        world.func_72838_d((Entity)ei);
        ei.func_174869_p();
        return ei;
    }

    public static EntityItem dropItemNaturally(World world, double x, double y, double z, ItemStack stack) {
        if (world.field_72995_K) {
            return null;
        }
        EntityItem ei = new EntityItem(world, x, y, z, stack);
        ItemUtils.applyRandomDropOffset(ei);
        world.func_72838_d((Entity)ei);
        ei.func_174869_p();
        return ei;
    }

    private static void applyRandomDropOffset(EntityItem item) {
        item.field_70159_w = (double)(rand.nextFloat() * 0.3f) - 0.15;
        item.field_70181_x = (double)(rand.nextFloat() * 0.3f) - 0.15;
        item.field_70179_y = (double)(rand.nextFloat() * 0.3f) - 0.15;
    }

    @Nonnull
    public static ItemStack createBlockStack(IBlockState state) {
        Item i = Item.func_150898_a((Block)state.func_177230_c());
        if (i == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        int meta = state.func_177230_c().func_180651_a(state);
        return new ItemStack(i, 1, meta);
    }

    @Nullable
    public static IBlockState createBlockState(ItemStack stack) {
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        if (b == Blocks.field_150350_a) {
            return null;
        }
        try {
            return b.func_176203_a(stack.func_77960_j());
        }
        catch (Exception exc) {
            return b.func_176223_P();
        }
    }

    public static Collection<ItemStack> scanInventoryFor(IItemHandler handler, Item i) {
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (s.func_190926_b() || s.func_77973_b() != i) continue;
            out.add(ItemUtils.copyStackWithSize(s, s.func_190916_E()));
        }
        return out;
    }

    public static Collection<ItemStack> scanInventoryForMatching(IItemHandler handler, ItemStack match, boolean strict) {
        return ItemUtils.findItemsInInventory(handler, match, strict);
    }

    public static Collection<ItemStack> findItemsInPlayerInventory(EntityPlayer player, ItemStack match, boolean strict) {
        return ItemUtils.findItemsInInventory((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), match, strict);
    }

    public static Collection<ItemStack> findItemsInInventory(IItemHandler handler, ItemStack match, boolean strict) {
        LinkedList<ItemStack> stacksOut = new LinkedList<ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemUtils.matchStacks(s, match) : ItemUtils.matchStackLoosely(s, match))) continue;
            stacksOut.add(ItemUtils.copyStackWithSize(s, s.func_190916_E()));
        }
        return stacksOut;
    }

    public static Map<Integer, ItemStack> findItemsIndexedInInventory(IItemHandler handler, ItemStack match, boolean strict) {
        HashMap<Integer, ItemStack> stacksOut = new HashMap<Integer, ItemStack>();
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack s = handler.getStackInSlot(j);
            if (!(strict ? ItemUtils.matchStacks(s, match) : ItemUtils.matchStackLoosely(s, match))) continue;
            stacksOut.put(j, ItemUtils.copyStackWithSize(s, s.func_190916_E()));
        }
        return stacksOut;
    }

    public static boolean consumeFromPlayerInventory(EntityPlayer player, ItemStack requestingItemStack, ItemStack toConsume, boolean simulate) {
        ItemStack tryConsume;
        IBlockState consumeState;
        int consumed = 0;
        if (Mods.BOTANIA.isPresent() && (consumeState = ItemUtils.createBlockState(toConsume)) != null) {
            Block b = consumeState.func_177230_c();
            int meta = b.func_180651_a(consumeState);
            for (int i = 0; i < toConsume.func_190916_E(); ++i) {
                ItemStack res = ModIntegrationBotania.requestFromInventory(player, requestingItemStack, b, meta, simulate);
                if (res.func_190926_b()) continue;
                ++consumed;
            }
        }
        return (tryConsume = ItemUtils.copyStackWithSize(toConsume, toConsume.func_190916_E() - consumed)).func_190926_b() || ItemUtils.consumeFromInventory((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), tryConsume, simulate);
    }

    public static boolean tryConsumeFromInventory(IItemHandler handler, ItemStack toConsume, boolean simulate) {
        return handler instanceof IItemHandlerModifiable && ItemUtils.consumeFromInventory((IItemHandlerModifiable)handler, toConsume, simulate);
    }

    public static boolean consumeFromInventory(IItemHandlerModifiable handler, ItemStack toConsume, boolean simulate) {
        Map<Integer, ItemStack> contents = ItemUtils.findItemsIndexedInInventory((IItemHandler)handler, toConsume, false);
        if (contents.isEmpty()) {
            return false;
        }
        int cAmt = toConsume.func_190916_E();
        for (int slot : contents.keySet()) {
            ItemStack inSlot = contents.get(slot);
            int toRemove = cAmt > inSlot.func_190916_E() ? inSlot.func_190916_E() : cAmt;
            cAmt -= toRemove;
            if (!simulate) {
                handler.setStackInSlot(slot, ItemUtils.copyStackWithSize(inSlot, inSlot.func_190916_E() - toRemove));
            }
            if (cAmt > 0) continue;
            break;
        }
        return cAmt <= 0;
    }

    public static void dropInventory(IItemHandler handle, World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K) {
            return;
        }
        for (int i = 0; i < handle.getSlots(); ++i) {
            ItemStack stack = handle.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        }
    }

    public static FluidActionResult drainFluidFromItem(ItemStack stack, Fluid fluid, int mbAmount, boolean doDrain) {
        return ItemUtils.drainFluidFromItem(stack, new FluidStack(fluid, mbAmount), doDrain);
    }

    public static FluidActionResult drainFluidFromItem(ItemStack stack, FluidStack fluidStack, boolean doDrain) {
        return FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)FluidHandlerVoid.INSTANCE, (int)fluidStack.amount, null, (boolean)doDrain);
    }

    public static void decrStackInInventory(ItemStackHandler handler, int slot) {
        if (slot < 0 || slot >= handler.getSlots()) {
            return;
        }
        ItemStack st = handler.getStackInSlot(slot);
        if (st.func_190926_b()) {
            return;
        }
        st.func_190920_e(st.func_190916_E() - 1);
        if (st.func_190916_E() <= 0) {
            handler.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public static boolean tryPlaceItemInInventory(@Nonnull ItemStack stack, IItemHandler handler) {
        return ItemUtils.tryPlaceItemInInventory(stack, handler, 0, handler.getSlots());
    }

    public static boolean tryPlaceItemInInventory(@Nonnull ItemStack stack, IItemHandler handler, int start, int end) {
        ItemStack toAdd = stack.func_77946_l();
        if (!ItemUtils.hasInventorySpace(toAdd, handler, start, end)) {
            return false;
        }
        int max = stack.func_77976_d();
        for (int i = start; i < end; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in.func_190926_b()) {
                int added = Math.min(stack.func_190916_E(), max);
                stack.func_190920_e(stack.func_190916_E() - added);
                handler.insertItem(i, ItemUtils.copyStackWithSize(stack, added), false);
                return true;
            }
            if (!ItemUtils.stackEqualsNonNBT(stack, in) || !ItemUtils.matchTags(stack, in)) continue;
            int space = max - in.func_190916_E();
            int added = Math.min(stack.func_190916_E(), space);
            stack.func_190920_e(stack.func_190916_E() - added);
            handler.getStackInSlot(i).func_190920_e(handler.getStackInSlot(i).func_190916_E() + added);
            if (stack.func_190916_E() > 0) continue;
            return true;
        }
        return stack.func_190916_E() == 0;
    }

    public static boolean hasInventorySpace(@Nonnull ItemStack stack, IItemHandler handler, int rangeMin, int rangeMax) {
        int size = stack.func_190916_E();
        int max = stack.func_77976_d();
        for (int i = rangeMin; i < rangeMax && size > 0; ++i) {
            ItemStack in = handler.getStackInSlot(i);
            if (in.func_190926_b()) {
                size -= max;
                continue;
            }
            if (!ItemUtils.stackEqualsNonNBT(stack, in) || !ItemUtils.matchTags(stack, in)) continue;
            int space = max - in.func_190916_E();
            size -= space;
        }
        return size <= 0;
    }

    public static boolean stackEqualsNonNBT(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b() && other.func_190926_b()) {
            return true;
        }
        if (stack.func_190926_b() || other.func_190926_b()) {
            return false;
        }
        Item sItem = stack.func_77973_b();
        Item oItem = other.func_77973_b();
        if (sItem.func_77614_k() || oItem.func_77614_k()) {
            return sItem.equals(other.func_77973_b()) && (stack.func_77952_i() == other.func_77952_i() || stack.func_77952_i() == Short.MAX_VALUE || other.func_77952_i() == Short.MAX_VALUE);
        }
        return sItem.equals(other.func_77973_b());
    }

    public static ItemStack copyStackWithSize(@Nonnull ItemStack stack, int amount) {
        if (stack.func_190926_b() || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = stack.func_77946_l();
        s.func_190920_e(amount);
        return s;
    }

    public static boolean hasOreNamePart(ItemStack stack, String namePart) {
        namePart = namePart.toLowerCase();
        List<String> oreNames = ItemUtils.getOreDictNames(stack);
        for (String s : oreNames) {
            if (!s.contains(namePart)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOreName(ItemStack stack, String name) {
        name = name.toLowerCase();
        return ItemUtils.getOreDictNames(stack).contains(name);
    }

    public static NonNullList<ItemStack> getStacksOfOredict(String name) {
        return OreDictionary.getOres((String)name, (boolean)false);
    }

    private static List<String> getOreDictNames(ItemStack stack) {
        ArrayList out = Lists.newArrayList();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            out.add(OreDictionary.getOreName((int)id).toLowerCase());
        }
        return out;
    }

    public static boolean matchTags(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchStacksStrict(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        return ItemStack.func_77989_b((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchStacks(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)other)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    public static boolean matchStackLoosely(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (stack.func_190926_b()) {
            return other.func_190926_b();
        }
        return stack.func_77969_a(other);
    }

    public static boolean matchesOreDict(String oreDictKey, @Nonnull ItemStack other) {
        NonNullList stacks = OreDictionary.getOres((String)oreDictKey);
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b() || !ItemUtils.matchStackLoosely(stack, other)) continue;
            return true;
        }
        return false;
    }

    private static class FluidHandlerVoid
    implements IFluidHandler {
        private static FluidHandlerVoid INSTANCE = new FluidHandlerVoid();

        private FluidHandlerVoid() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            return resource.amount;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

