/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.NoOpTeleporter;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MiscUtils {
    private static Map<EnumDyeColor, Color> prettierColorMapping = new HashMap<EnumDyeColor, Color>();

    @Nullable
    public static <T> T getTileAt(IBlockAccess world, BlockPos pos, Class<T> tileClass, boolean forceChunkLoad) {
        if (world == null || pos == null) {
            return null;
        }
        if (world instanceof World && !((World)world).func_175667_e(pos) && !forceChunkLoad) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        if (tileClass.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    @Nullable
    public static <T> T getRandomEntry(List<T> list, Random rand) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(rand.nextInt(list.size()));
    }

    public static <T, V extends Comparable<V>> V getMaxEntry(Collection<T> elements, Function<T, V> valueFunction) {
        Comparable max = null;
        for (T element : elements) {
            Comparable val = (Comparable)valueFunction.apply(element);
            if (max != null && max.compareTo(val) >= 0) continue;
            max = val;
        }
        return (V)max;
    }

    @Nonnull
    public static Color flareColorFromDye(EnumDyeColor color) {
        Color c = prettierColorMapping.get(color);
        if (c == null) {
            c = Color.WHITE;
        }
        return c;
    }

    @Nonnull
    public static TextFormatting textFormattingForDye(EnumDyeColor color) {
        switch (color) {
            case WHITE: {
                return TextFormatting.WHITE;
            }
            case ORANGE: {
                return TextFormatting.GOLD;
            }
            case MAGENTA: {
                return TextFormatting.DARK_PURPLE;
            }
            case LIGHT_BLUE: {
                return TextFormatting.DARK_AQUA;
            }
            case YELLOW: {
                return TextFormatting.YELLOW;
            }
            case LIME: {
                return TextFormatting.GREEN;
            }
            case PINK: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case GRAY: {
                return TextFormatting.DARK_GRAY;
            }
            case SILVER: {
                return TextFormatting.GRAY;
            }
            case CYAN: {
                return TextFormatting.BLUE;
            }
            case PURPLE: {
                return TextFormatting.DARK_PURPLE;
            }
            case BLUE: {
                return TextFormatting.DARK_BLUE;
            }
            case BROWN: {
                return TextFormatting.GOLD;
            }
            case GREEN: {
                return TextFormatting.DARK_GREEN;
            }
            case RED: {
                return TextFormatting.DARK_RED;
            }
            case BLACK: {
                return TextFormatting.DARK_GRAY;
            }
        }
        return TextFormatting.WHITE;
    }

    public static String capitalizeFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return String.valueOf(Character.toTitleCase(str.charAt(0))) + str.substring(1);
    }

    public static boolean canToolBreakBlockWithoutPlayer(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull ItemStack stack) {
        if (state.func_185887_b(world, pos) == -1.0f) {
            return false;
        }
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        String tool = state.func_177230_c().getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return state.func_185904_a().func_76229_l() || stack.func_150998_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, null, state);
        if (toolLevel < 0) {
            return state.func_185904_a().func_76229_l() || stack.func_150998_b(state);
        }
        return toolLevel >= state.func_177230_c().getHarvestLevel(state);
    }

    public static boolean breakBlockWithPlayer(BlockPos pos, EntityPlayerMP playerMP) {
        return playerMP.field_71134_c.func_180237_b(pos);
    }

    public static boolean breakBlockWithoutPlayer(WorldServer world, BlockPos pos) {
        return MiscUtils.breakBlockWithoutPlayer(world, pos, world.func_180495_p(pos), true, false, true);
    }

    public static boolean breakBlockWithoutPlayer(WorldServer world, BlockPos pos, IBlockState suggestedBrokenState, boolean breakBlock, boolean ignoreHarvestRestrictions, boolean playEffects) {
        int exp;
        FakePlayer fp = AstralSorcery.proxy.getASFakePlayerServer(world);
        try {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((World)world, pos, suggestedBrokenState, (EntityPlayer)fp);
            MinecraftForge.EVENT_BUS.post((Event)event);
            exp = event.getExpToDrop();
            if (event.isCanceled()) {
                return false;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        Block block = suggestedBrokenState.func_177230_c();
        if (playEffects) {
            world.func_180498_a(null, 2001, pos, Block.func_176210_f((IBlockState)suggestedBrokenState));
        }
        boolean harvestable = true;
        try {
            if (!ignoreHarvestRestrictions) {
                harvestable = block.canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)fp);
            }
        }
        catch (Exception exc) {
            return false;
        }
        world.captureBlockSnapshots = true;
        try {
            if (breakBlock) {
                if (!block.removedByPlayer(suggestedBrokenState, (World)world, pos, (EntityPlayer)fp, harvestable)) {
                    world.captureBlockSnapshots = false;
                    world.capturedBlockSnapshots.forEach(s -> s.restore(true));
                    world.capturedBlockSnapshots.clear();
                    return false;
                }
            } else {
                block.func_176208_a((World)world, pos, suggestedBrokenState, (EntityPlayer)fp);
            }
        }
        catch (Exception exc) {
            world.captureBlockSnapshots = false;
            world.capturedBlockSnapshots.forEach(s -> s.restore(true));
            world.capturedBlockSnapshots.clear();
            return false;
        }
        block.func_176206_d((World)world, pos, suggestedBrokenState);
        if (harvestable) {
            try {
                block.func_180657_a((World)world, (EntityPlayer)fp, pos, suggestedBrokenState, tileentity, ItemStack.field_190927_a);
            }
            catch (Exception exc) {
                world.captureBlockSnapshots = false;
                world.capturedBlockSnapshots.forEach(s -> s.restore(true));
                world.capturedBlockSnapshots.clear();
                return false;
            }
        }
        if (exp > 0) {
            block.func_180637_b((World)world, pos, exp);
        }
        BlockDropCaptureAssist.startCapturing();
        world.captureBlockSnapshots = false;
        world.capturedBlockSnapshots.forEach(s -> s.restore(true));
        world.capturedBlockSnapshots.forEach(s -> world.func_175698_g(s.getPos()));
        world.capturedBlockSnapshots.clear();
        BlockDropCaptureAssist.getCapturedStacksAndStop();
        return true;
    }

    public static void transferEntityTo(Entity entity, int targetDimId, BlockPos targetPos) {
        if (entity.func_130014_f_().field_72995_K) {
            return;
        }
        if (entity.func_130014_f_().field_73011_w.getDimension() != targetDimId) {
            if (entity instanceof EntityPlayerMP) {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().transferPlayerToDimension((EntityPlayerMP)entity, targetDimId, (Teleporter)new NoOpTeleporter(((EntityPlayerMP)entity).func_71121_q()));
            } else {
                entity.func_184204_a(targetDimId);
            }
        }
        entity.func_70634_a((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p() + 0.5);
    }

    public static List<Vector3> getCirclePositions(Vector3 centerOffset, Vector3 axis, double radius, int amountOfPointsOnCircle) {
        LinkedList<Vector3> out = new LinkedList<Vector3>();
        Vector3 circleVec = axis.clone().perpendicular().normalize().multiply(radius);
        double degPerPoint = 360.0 / (double)amountOfPointsOnCircle;
        for (int i = 0; i < amountOfPointsOnCircle; ++i) {
            double deg = (double)i * degPerPoint;
            out.add(circleVec.clone().rotate(Math.toRadians(deg), axis.clone()).add(centerOffset));
        }
        return out;
    }

    @Nullable
    public static RayTraceResult rayTraceLook(EntityPlayer player) {
        double reach = 5.0;
        if (player instanceof EntityPlayerMP) {
            reach = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        return MiscUtils.rayTraceLook((EntityLivingBase)player, reach);
    }

    @Nullable
    public static RayTraceResult rayTraceLook(EntityLivingBase entity, double reachDst) {
        Vec3d pos = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d lookVec = entity.func_70040_Z();
        Vec3d end = pos.func_72441_c(lookVec.field_72450_a * reachDst, lookVec.field_72448_b * reachDst, lookVec.field_72449_c * reachDst);
        return entity.field_70170_p.func_72933_a(pos, end);
    }

    public static Color calcRandomConstellationColor(float perc) {
        return new Color(Color.HSBtoRGB((230.0f + 50.0f * perc) / 360.0f, 0.8f, 0.8f - 0.3f * perc));
    }

    public static void applyRandomOffset(Vector3 target, Random rand) {
        MiscUtils.applyRandomOffset(target, rand, 1.0f);
    }

    public static void applyRandomOffset(Vector3 target, Random rand, float multiplier) {
        target.addX(rand.nextFloat() * multiplier * (float)(rand.nextBoolean() ? 1 : -1));
        target.addY(rand.nextFloat() * multiplier * (float)(rand.nextBoolean() ? 1 : -1));
        target.addZ(rand.nextFloat() * multiplier * (float)(rand.nextBoolean() ? 1 : -1));
    }

    public static boolean isChunkLoaded(World world, BlockPos pos) {
        return world.func_175667_e(pos);
    }

    public static boolean isChunkLoaded(World world, ChunkPos pos) {
        return world.func_175667_e(new BlockPos(pos.field_77276_a * 16, 0, pos.field_77275_b * 16));
    }

    public static boolean isPlayerFakeMP(EntityPlayerMP player) {
        Class<?> plClass;
        if (player instanceof FakePlayer) {
            return true;
        }
        if (Mods.GALACTICRAFT_CORE.isPresent() ? ((plClass = Mods.getGCPlayerClass()) != null ? player.getClass() != EntityPlayerMP.class && player.getClass() != plClass : player.getClass() != EntityPlayerMP.class) : player.getClass() != EntityPlayerMP.class) {
            return true;
        }
        if (player.field_71135_a == null) {
            return true;
        }
        try {
            player.func_71114_r().length();
            player.field_71135_a.field_147371_a.func_74430_c().toString();
        }
        catch (Exception exc) {
            return true;
        }
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al() == null) {
            return true;
        }
        return !FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v().contains(player);
    }

    @Nullable
    public static BlockPos searchAreaForFirst(World world, BlockPos center, int radius, @Nullable Vector3 offsetFrom, BlockStateCheck acceptor) {
        for (int r = 0; r <= radius; ++r) {
            LinkedList<BlockPos> posList = new LinkedList<BlockPos>();
            for (int xx = -r; xx <= r; ++xx) {
                for (int yy = -r; yy <= r; ++yy) {
                    for (int zz = -r; zz <= r; ++zz) {
                        IBlockState state;
                        BlockPos pos = center.func_177982_a(xx, yy, zz);
                        if (!MiscUtils.isChunkLoaded(world, new ChunkPos(pos)) || !acceptor.isStateValid(world, pos, state = world.func_180495_p(pos))) continue;
                        posList.add(pos);
                    }
                }
            }
            if (!posList.isEmpty()) {
                Vector3 offset = new Vector3(center).add(0.5, 0.5, 0.5);
                if (offsetFrom != null) {
                    offset = offsetFrom;
                }
                BlockPos closest = null;
                double prevDst = 0.0;
                for (BlockPos pos : posList) {
                    if (closest != null && !(offset.distance((Vec3i)pos) < prevDst)) continue;
                    closest = pos;
                    prevDst = offset.distance((Vec3i)pos);
                }
                return closest;
            }
            posList.clear();
        }
        return null;
    }

    public static List<BlockPos> searchAreaFor(World world, BlockPos center, Block blockToSearch, int metaToSearch, int radius) {
        LinkedList<BlockPos> found = new LinkedList<BlockPos>();
        for (int xx = -radius; xx <= radius; ++xx) {
            for (int yy = -radius; yy <= radius; ++yy) {
                for (int zz = -radius; zz <= radius; ++zz) {
                    IBlockState state;
                    Block b;
                    BlockPos pos = center.func_177982_a(xx, yy, zz);
                    if (!MiscUtils.isChunkLoaded(world, new ChunkPos(pos)) || !(b = (state = world.func_180495_p(pos)).func_177230_c()).equals(blockToSearch) || b.func_176201_c(state) != metaToSearch) continue;
                    found.add(pos);
                }
            }
        }
        return found;
    }

    static {
        prettierColorMapping.put(EnumDyeColor.WHITE, new Color(0xFFFFFF));
        prettierColorMapping.put(EnumDyeColor.ORANGE, new Color(16747549));
        prettierColorMapping.put(EnumDyeColor.MAGENTA, new Color(0xEF0EFF));
        prettierColorMapping.put(EnumDyeColor.LIGHT_BLUE, new Color(452095));
        prettierColorMapping.put(EnumDyeColor.YELLOW, new Color(16771840));
        prettierColorMapping.put(EnumDyeColor.LIME, new Color(9699088));
        prettierColorMapping.put(EnumDyeColor.PINK, new Color(16718041));
        prettierColorMapping.put(EnumDyeColor.GRAY, new Color(0x5E5E5E));
        prettierColorMapping.put(EnumDyeColor.SILVER, new Color(0xBDBDBD));
        prettierColorMapping.put(EnumDyeColor.CYAN, new Color(5544116));
        prettierColorMapping.put(EnumDyeColor.PURPLE, new Color(12001783));
        prettierColorMapping.put(EnumDyeColor.BLUE, new Color(3932415));
        prettierColorMapping.put(EnumDyeColor.BROWN, new Color(12022025));
        prettierColorMapping.put(EnumDyeColor.GREEN, new Color(43520));
        prettierColorMapping.put(EnumDyeColor.RED, new Color(0xFF0000));
        prettierColorMapping.put(EnumDyeColor.BLACK, new Color(0));
    }
}

