/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PrecisionSingleFluidCapabilityTank
implements IFluidTank,
IFluidTankProperties,
IFluidHandler {
    private double amount = 0.0;
    private int maxCapacity;
    private Fluid fluid = null;
    private boolean allowInput = true;
    private boolean allowOutput = true;
    public List<EnumFacing> accessibleSides = new ArrayList<EnumFacing>();

    private PrecisionSingleFluidCapabilityTank() {
    }

    public PrecisionSingleFluidCapabilityTank(int maxCapacity) {
        this(maxCapacity, EnumFacing.field_82609_l);
    }

    public PrecisionSingleFluidCapabilityTank(int capacity, EnumFacing ... accessibleFrom) {
        this.maxCapacity = Math.max(0, capacity);
        this.accessibleSides = Arrays.asList(accessibleFrom);
    }

    public void setAllowInput(boolean allowInput) {
        this.allowInput = allowInput;
    }

    public void setAllowOutput(boolean allowOutput) {
        this.allowOutput = allowOutput;
    }

    public double getMaxAddable(double toAdd) {
        return Math.min(toAdd, (double)this.maxCapacity - toAdd);
    }

    public int getMaxDrainable(double toDrain) {
        return (int)Math.floor(Math.min(toDrain, this.amount));
    }

    public double addAmount(double amount) {
        if (this.fluid == null) {
            return amount;
        }
        double addable = this.getMaxAddable(amount);
        this.amount += addable;
        return amount - addable;
    }

    @Nullable
    public FluidStack drain(double amount) {
        if (this.fluid == null) {
            return null;
        }
        int drainable = this.getMaxDrainable(amount);
        this.amount -= (double)drainable;
        Fluid drainedFluid = this.fluid;
        if (this.amount <= 0.0) {
            this.setFluid(null);
        }
        return new FluidStack(drainedFluid, drainable);
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.fluid == null) {
            return null;
        }
        return new FluidStack(this.fluid, this.getFluidAmount());
    }

    @Nullable
    public Fluid getTankFluid() {
        return this.fluid;
    }

    public void setFluid(@Nullable Fluid fluid) {
        if (fluid != this.fluid) {
            this.amount = 0.0;
        }
        this.fluid = fluid;
    }

    public int getFluidAmount() {
        return MathHelper.func_76128_c((double)this.amount);
    }

    @Nullable
    public FluidStack getContents() {
        return this.getFluid();
    }

    public int getCapacity() {
        return this.maxCapacity;
    }

    public boolean canFill() {
        return this.allowInput && this.amount < (double)this.maxCapacity;
    }

    public boolean canDrain() {
        return this.allowOutput && this.amount > 0.0 && this.fluid != null;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.canFill() && (this.fluid == null || fluidStack.getFluid().equals(this.fluid)) && this.amount + (double)fluidStack.amount <= (double)this.maxCapacity;
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.canDrain() && this.fluid != null && fluidStack.getFluid().equals(this.fluid) && this.amount >= (double)fluidStack.amount;
    }

    public float getPercentageFilled() {
        return (float)this.amount / (float)this.maxCapacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        int maxAdded = resource.amount;
        int addable = MathHelper.func_76128_c((double)this.getMaxAddable(maxAdded));
        if (addable > 0 && this.fluid == null && doFill) {
            this.setFluid(resource.getFluid());
        }
        if (doFill) {
            addable = (int)((double)addable - this.addAmount(addable));
        }
        return addable;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (!this.canDrainFluidType(resource)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrain()) {
            return null;
        }
        int maxDrainable = this.getMaxDrainable(maxDrain);
        if (doDrain) {
            return this.drain(maxDrainable);
        }
        return new FluidStack(this.fluid, maxDrainable);
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("amt", this.amount);
        tag.func_74768_a("capacity", this.maxCapacity);
        tag.func_74757_a("aIn", this.allowInput);
        tag.func_74757_a("aOut", this.allowOutput);
        if (this.fluid != null) {
            tag.func_74778_a("fluid", this.fluid.getName());
        }
        int[] sides = new int[this.accessibleSides.size()];
        for (int i = 0; i < this.accessibleSides.size(); ++i) {
            EnumFacing side = this.accessibleSides.get(i);
            sides[i] = side.ordinal();
        }
        tag.func_74783_a("sides", sides);
        return tag;
    }

    public void readNBT(NBTTagCompound tag) {
        int[] sides;
        this.amount = tag.func_74769_h("amt");
        this.maxCapacity = tag.func_74762_e("capacity");
        this.allowInput = tag.func_74767_n("aIn");
        this.allowOutput = tag.func_74767_n("aOut");
        this.fluid = tag.func_74764_b("fluid") ? FluidRegistry.getFluid((String)tag.func_74779_i("fluid")) : null;
        for (int i : sides = tag.func_74759_k("sides")) {
            this.accessibleSides.add(EnumFacing.values()[i]);
        }
    }

    public static PrecisionSingleFluidCapabilityTank deserialize(NBTTagCompound tag) {
        PrecisionSingleFluidCapabilityTank tank = new PrecisionSingleFluidCapabilityTank();
        tank.readNBT(tag);
        return tank;
    }

    public boolean hasCapability(EnumFacing facing) {
        return facing == null || this.accessibleSides.contains(facing);
    }

    public IFluidHandler getCapability(EnumFacing facing) {
        if (this.hasCapability(facing)) {
            return this;
        }
        return null;
    }
}

