/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.effect.time;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.data.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopEffectHelper;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopZone;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TimeStopController
implements ITickHandler {
    private Map<Integer, List<TimeStopZone>> activeTimeStopZones = new HashMap<Integer, List<TimeStopZone>>();
    public static TimeStopController INSTANCE = new TimeStopController();

    private TimeStopController() {
    }

    @Nullable
    public static TimeStopZone freezeWorldAt(@Nullable Entity ownerEntity, @Nonnull World world, @Nonnull BlockPos offset, float range, int maxAge) {
        if (world.field_73011_w == null) {
            return null;
        }
        TimeStopZone stopZone = new TimeStopZone(ownerEntity, range, offset, world, maxAge);
        int dimId = world.field_73011_w.getDimension();
        List zones = TimeStopController.INSTANCE.activeTimeStopZones.computeIfAbsent(dimId, id -> new LinkedList());
        zones.add(stopZone);
        ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.SERVER, "TimeFreezeEffects")).server_addNewEffect(dimId, TimeStopEffectHelper.fromZone(stopZone));
        return stopZone;
    }

    @SubscribeEvent
    public void onWorldClear(WorldEvent.Unload event) {
        World w = event.getWorld();
        if (w != null && w.field_73011_w != null) {
            int id = w.field_73011_w.getDimension();
            List<TimeStopZone> freezeAreas = this.activeTimeStopZones.get(id);
            if (freezeAreas != null && !freezeAreas.isEmpty()) {
                for (TimeStopZone stop : freezeAreas) {
                    stop.stopEffect();
                }
            }
            ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.SERVER, "TimeFreezeEffects")).server_clearEffects(id);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingTickTest(LivingEvent.LivingUpdateEvent event) {
        int id;
        List<TimeStopZone> freezeAreas;
        EntityLivingBase e = event.getEntityLiving();
        World w = e.field_70170_p;
        if (w != null && w.field_73011_w != null && (freezeAreas = this.activeTimeStopZones.get(id = w.field_73011_w.getDimension())) != null && !freezeAreas.isEmpty()) {
            for (TimeStopZone stop : freezeAreas) {
                if (!stop.interceptEntityTick(e)) continue;
                stop.handleImportantEntityTicks(e);
                event.setCanceled(true);
                return;
            }
        }
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        for (Map.Entry<Integer, List<TimeStopZone>> zoneMap : this.activeTimeStopZones.entrySet()) {
            Iterator<TimeStopZone> iterator = zoneMap.getValue().iterator();
            while (iterator.hasNext()) {
                TimeStopZone zone = iterator.next();
                if (zone.shouldDespawn()) {
                    zone.stopEffect();
                    ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.SERVER, "TimeFreezeEffects")).server_removeEffect(zoneMap.getKey(), TimeStopEffectHelper.fromZone(zone));
                    iterator.remove();
                    continue;
                }
                zone.onServerTick();
                if (!zone.shouldDespawn()) continue;
                zone.stopEffect();
                ((DataTimeFreezeEffects)SyncDataHolder.getData(Side.SERVER, "TimeFreezeEffects")).server_removeEffect(zoneMap.getKey(), TimeStopEffectHelper.fromZone(zone));
                iterator.remove();
            }
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase.equals((Object)TickEvent.Phase.START);
    }

    @Override
    public String getName() {
        return "TimeStop Controller";
    }
}

