/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.effect.time;

import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TimeStopZone {
    final int ownerId;
    final boolean hasOwner;
    final float range;
    final BlockPos offset;
    private final World world;
    private int ticksToLive = 0;
    private boolean active = true;
    private List<TileEntity> cachedTiles = new LinkedList<TileEntity>();

    TimeStopZone(Entity owner, float range, BlockPos offset, World world, int tickLivespan) {
        this.hasOwner = owner != null;
        this.ownerId = this.hasOwner ? owner.func_145782_y() : -1;
        this.range = range;
        this.offset = offset;
        this.world = world;
        this.ticksToLive = tickLivespan;
    }

    void onServerTick() {
        if (!this.active) {
            return;
        }
        --this.ticksToLive;
        int minX = MathHelper.func_76128_c((double)((double)((float)this.offset.func_177958_n() - this.range) / 16.0));
        int maxX = MathHelper.func_76128_c((double)((double)((float)this.offset.func_177958_n() + this.range) / 16.0));
        int minZ = MathHelper.func_76128_c((double)((double)((float)this.offset.func_177952_p() - this.range) / 16.0));
        int maxZ = MathHelper.func_76128_c((double)((double)((float)this.offset.func_177952_p() + this.range) / 16.0));
        for (int xx = minX; xx <= maxX; ++xx) {
            for (int zz = minZ; zz <= maxZ; ++zz) {
                Chunk ch = this.world.func_72964_e(xx, zz);
                if (ch.func_76621_g()) continue;
                Map map = ch.func_177434_r();
                for (Map.Entry teEntry : map.entrySet()) {
                    TileEntity te = (TileEntity)teEntry.getValue();
                    if (te == null || !(te instanceof ITickable) || !(this.offset.func_185332_f(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()) <= (double)this.range) || !this.world.field_175730_i.contains(te)) continue;
                    this.world.field_175730_i.remove(te);
                    this.safeCacheTile(te);
                }
            }
        }
    }

    private void safeCacheTile(TileEntity te) {
        if (te == null) {
            return;
        }
        for (TileEntity tile : this.cachedTiles) {
            if (!tile.func_174877_v().equals((Object)te.func_174877_v())) continue;
            return;
        }
        this.cachedTiles.add(te);
    }

    public void stopEffect() {
        this.world.field_175730_i.addAll(this.cachedTiles);
        this.cachedTiles.clear();
        this.active = false;
    }

    boolean shouldDespawn() {
        return this.ticksToLive <= 0 || !this.active;
    }

    boolean interceptEntityTick(EntityLivingBase e) {
        return this.active && e != null && (!this.hasOwner || e.func_145782_y() != this.ownerId) && Vector3.atEntityCorner((Entity)e).distance((Vec3i)this.offset) <= (double)this.range;
    }

    void handleImportantEntityTicks(EntityLivingBase e) {
        if (e.field_70737_aN > 0) {
            --e.field_70737_aN;
        }
        if (e.field_70172_ad > 0) {
            --e.field_70172_ad;
        }
    }
}

