/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.init;

import codechicken.enderstorage.block.BlockEnderStorage;
import codechicken.enderstorage.client.render.item.EnderChestItemRender;
import codechicken.enderstorage.client.render.item.EnderTankItemRender;
import codechicken.enderstorage.item.ItemEnderStorage;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.lib.model.ModelRegistryHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModBlocks {
    public static BlockEnderStorage blockEnderStorage;
    public static ItemEnderStorage itemEnderStorage;

    public static void init() {
        blockEnderStorage = new BlockEnderStorage();
        itemEnderStorage = new ItemEnderStorage(blockEnderStorage);
        ForgeRegistries.BLOCKS.register(blockEnderStorage.setRegistryName("ender_storage"));
        ForgeRegistries.ITEMS.register(itemEnderStorage.setRegistryName("ender_storage"));
        GameRegistry.registerTileEntity(TileEnderChest.class, (String)"Ender Chest");
        GameRegistry.registerTileEntity(TileEnderTank.class, (String)"Ender Tank");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (int i = 0; i < BlockEnderStorage.Type.VALUES.length; ++i) {
            BlockEnderStorage.Type variant = BlockEnderStorage.Type.VALUES[i];
            ModelResourceLocation location = new ModelResourceLocation("enderstorage:enderStorage", "type=" + variant.func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)itemEnderStorage, (int)i, (ModelResourceLocation)location);
        }
        ModelRegistryHelper.register((ModelResourceLocation)new ModelResourceLocation("enderstorage:enderStorage", "type=ender_chest"), (IBakedModel)new EnderChestItemRender());
        ModelRegistryHelper.register((ModelResourceLocation)new ModelResourceLocation("enderstorage:enderStorage", "type=ender_tank"), (IBakedModel)new EnderTankItemRender());
    }
}

